/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.common;

import java.io.Serializable;
import java.util.ArrayList;
import org.compiere.util.CLoggerSimple;
import org.compiere.util.CompiereLogger;

public class TableModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static CompiereLogger log = new CLoggerSimple(TableModel.class);
    private transient DirtyListener dirtyListener = null;
    public static final transient State READONLY = new State(){

        public String toString() {
            return "READONLY";
        }
    };
    public static final transient State UPDATE = new State(){

        public String toString() {
            return "UPDATE";
        }
    };
    public static final transient State INSERT = new State(){

        public String toString() {
            return "INSERT";
        }
    };
    protected ArrayList readOnly = new ArrayList(10);
    protected ArrayList values = new ArrayList(10);
    protected transient ArrayList states = new ArrayList(10);
    protected transient ArrayList dirty = new ArrayList(10);

    public String get(int row, int col) {
        if (this.values.size() > row && row >= 0) {
            String[] r = (String[])this.values.get(row);
            return r[col];
        }
        return null;
    }

    public void set(int row, int col, String v) {
        String[] r = (String[])this.values.get(row);
        r[col] = v;
    }

    public boolean isDirty(int row) {
        if (row < 0) {
            return false;
        }
        return (Boolean)this.dirty.get(row);
    }

    public void setDirty(int row, boolean flag) {
        log.finest("set row dirty: " + row + " dirty:" + flag);
        if (this.isDirty(row) != flag) {
            this.dirty.set(row, new Boolean(flag));
            if (this.dirtyListener != null) {
                this.dirtyListener.onDirty(flag);
            }
        }
    }

    public State getRowState(int row) {
        if (this.states.size() > row && row >= 0) {
            return (State)this.states.get(row);
        }
        return null;
    }

    public void setRowState(int row, State state) {
        log.finest("set row state: " + row + "-- " + state);
        this.states.set(row, state);
    }

    public String[] getRow(int row) {
        String[] r = (String[])this.values.get(row);
        return r;
    }

    public void setRow(int row, String[] r) {
        this.values.set(row, r);
    }

    public void addRow(String[] r) {
        this.values.add(r);
        this.states.add(READONLY);
        this.dirty.add(Boolean.FALSE);
        this.readOnly.add(Boolean.FALSE);
    }

    public void copyRow(int toRow, int fromRow) {
        String[] from = (String[])this.values.get(fromRow);
        String[] to = (String[])this.values.get(toRow);
        for (int i = 0; i < from.length; ++i) {
            to[i] = from[i];
        }
        this.states.set(toRow, this.states.get(fromRow));
        this.dirty.set(toRow, this.dirty.get(fromRow));
        this.readOnly.set(toRow, this.readOnly.get(fromRow));
    }

    public void addRow(int row, String[] r) {
        this.values.add(row, r);
        this.states.add(row, READONLY);
        this.dirty.add(row, Boolean.FALSE);
        this.readOnly.add(row, Boolean.FALSE);
    }

    public void removeRow(int row) {
        this.values.remove(row);
        this.states.remove(row);
        this.dirty.remove(row);
        this.readOnly.remove(row);
    }

    public boolean isEmpty() {
        return this.values.size() == 0;
    }

    public int rows() {
        return this.values.size();
    }

    public void resetStates() {
        this.states = new ArrayList(this.values.size());
        this.dirty = new ArrayList(this.values.size());
        for (int i = 0; i < this.values.size(); ++i) {
            this.states.add(READONLY);
            this.dirty.add(Boolean.FALSE);
        }
    }

    public boolean isReadOnly(int row) {
        return (Boolean)this.readOnly.get(row);
    }

    public void setReadOnly(int row, boolean readonly) {
        this.readOnly.set(row, new Boolean(readonly));
    }

    public void setDirtyListener(DirtyListener dirtyListener) {
        this.dirtyListener = dirtyListener;
    }

    public boolean nullValue(int row, int col) {
        return this.get(row, col) == null;
    }

    public static class State {
    }

    public static interface DirtyListener {
        public void onDirty(boolean var1);
    }
}

