/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import org.compiere.util.CompiereLogger;

public class CLoggerSimple
implements CompiereLogger {
    private String m_prefix = null;

    public CLoggerSimple() {
    }

    public CLoggerSimple(String prefix) {
        if (prefix != null && prefix.length() > 0) {
            this.m_prefix = prefix;
        }
    }

    public CLoggerSimple(Class clazz) {
        String prefix = clazz.toString();
        int index = prefix.lastIndexOf(46);
        if (index != -1) {
            prefix = prefix.substring(index);
        }
        this.m_prefix = prefix;
    }

    public void severe(String msg) {
        this.print(msg, true);
    }

    public void warning(String msg) {
        this.print(msg, false);
    }

    public void info(String msg) {
        this.print(msg, 1);
    }

    public void config(String msg) {
        this.print(msg, 2);
    }

    public void fine(String msg) {
        this.print(msg, 3);
    }

    public void finer(String msg) {
        this.print(msg, 4);
    }

    public void finest(String msg) {
        this.print(msg, 5);
    }

    private void print(String msg, boolean error) {
        StringBuffer sb = new StringBuffer();
        if (this.m_prefix != null) {
            sb.append(this.m_prefix).append(": ");
        }
        sb.append(" ").append(msg);
        System.err.println(sb.toString());
    }

    private void print(String msg, int noSpaces) {
        StringBuffer sb = new StringBuffer();
        if (this.m_prefix != null) {
            sb.append(this.m_prefix).append(": ");
        }
        sb.append("                          ".subSequence(0, noSpaces)).append(msg);
        System.out.println(sb.toString());
    }

    public boolean isLevelFinest() {
        return false;
    }
}

