/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.selectors;

import java.util.HashMap;
import java.util.Iterator;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import org.jboss.logging.Logger;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.selectors.ISelectorParser;
import org.jboss.mq.selectors.Identifier;
import org.jboss.mq.selectors.Operator;
import org.jboss.mq.selectors.SelectorParser;

public class Selector {
    static Logger cat = Logger.getLogger(Selector.class);
    private static Class parserClass = SelectorParser.class;
    public String selector;
    public HashMap identifiers;
    public Object result;
    private Class resultType;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;

    public static Class getSelectorParserClass() {
        return parserClass;
    }

    public static void setSelectorParserClass(Class parserClass) {
        Selector.parserClass = parserClass;
    }

    public Selector(String sel) throws InvalidSelectorException {
        this.selector = sel;
        this.identifiers = new HashMap();
        try {
            ISelectorParser bob = (ISelectorParser)parserClass.newInstance();
            this.result = bob.parse(sel, this.identifiers);
            this.resultType = this.result.getClass();
        }
        catch (Exception e) {
            InvalidSelectorException exception = new InvalidSelectorException("The selector is invalid: " + sel);
            exception.setLinkedException(e);
            throw exception;
        }
    }

    public synchronized boolean test(SpyMessage.Header mes) throws JMSException {
        try {
            Object res;
            Iterator i = this.identifiers.values().iterator();
            while (i.hasNext()) {
                Identifier id = (Identifier)i.next();
                Object find = mes.jmsProperties.get(id.name);
                if (find == null) {
                    find = this.getHeaderFieldReferences(mes, id.name);
                }
                if (find == null) {
                    id.value = null;
                    continue;
                }
                Class<?> type = find.getClass();
                if (type.equals(class$java$lang$Boolean == null ? Selector.class$("java.lang.Boolean") : class$java$lang$Boolean) || type.equals(class$java$lang$String == null ? Selector.class$("java.lang.String") : class$java$lang$String) || type.equals(class$java$lang$Double == null ? Selector.class$("java.lang.Double") : class$java$lang$Double) || type.equals(class$java$lang$Float == null ? Selector.class$("java.lang.Float") : class$java$lang$Float) || type.equals(class$java$lang$Integer == null ? Selector.class$("java.lang.Integer") : class$java$lang$Integer) || type.equals(class$java$lang$Long == null ? Selector.class$("java.lang.Long") : class$java$lang$Long) || type.equals(class$java$lang$Short == null ? Selector.class$("java.lang.Short") : class$java$lang$Short) || type.equals(class$java$lang$Byte == null ? Selector.class$("java.lang.Byte") : class$java$lang$Byte)) {
                    id.value = find;
                    continue;
                }
                throw new Exception("Bad property '" + id.name + "' type: " + type);
            }
            if (this.resultType.equals(Identifier.class)) {
                res = ((Identifier)this.result).value;
            } else if (this.resultType.equals(Operator.class)) {
                Operator op = (Operator)this.result;
                res = op.apply();
            } else {
                res = this.result;
            }
            if (res == null) {
                return false;
            }
            if (!res.getClass().equals(Boolean.class)) {
                throw new Exception("Bad object type: " + res);
            }
            return (Boolean)res;
        }
        catch (Exception e) {
            cat.warn("Invalid selector: " + this.selector, e);
            return false;
        }
    }

    public boolean test(SpyMessage msg) throws JMSException {
        return this.test(msg.header);
    }

    private Object getHeaderFieldReferences(SpyMessage.Header header, String idName) throws JMSException {
        if (idName.equals("JMSDeliveryMode")) {
            return new Integer(header.jmsDeliveryMode);
        }
        if (idName.equals("JMSPriority")) {
            return new Integer(header.jmsPriority);
        }
        if (idName.equals("JMSMessageID")) {
            return header.jmsMessageID;
        }
        if (idName.equals("JMSTimestamp")) {
            return new Long(header.jmsTimeStamp);
        }
        if (idName.equals("JMSCorrelationID")) {
            return header.jmsCorrelationIDString;
        }
        if (idName.equals("JMSType")) {
            return header.jmsType;
        }
        return null;
    }
}

