/******************************************************************************
 * Product: Compiere ERP & CRM Smart Business Solution                        *
 * Copyright (C) 1999-2007 ComPiere, Inc. All Rights Reserved.                *
 * This program is free software, you can redistribute it and/or modify it    *
 * under the terms version 2 of the GNU General Public License as published   *
 * by the Free Software Foundation. This program is distributed in the hope   *
 * that it will be useful, but WITHOUT ANY WARRANTY, without even the implied *
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.           *
 * See the GNU General Public License for more details.                       *
 * You should have received a copy of the GNU General Public License along    *
 * with this program, if not, write to the Free Software Foundation, Inc.,    *
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.                     *
 * For the text or an alternative of this public license, you may reach us    *
 * ComPiere, Inc., 3600 Bridge Parkway #102, Redwood City, CA 94065, USA      *
 * or via info@compiere.org or http://www.compiere.org/license.html           *
 *****************************************************************************/
package org.compiere.api;

import org.compiere.common.*;
import org.compiere.controller.*;
import org.compiere.framework.*;
import org.compiere.util.*;

/**
 *  Callout Interface.
 *  Used in UITab and ImpFormatRow
 *
 *  @author     Jorg Janke
 *  @version    $Id: CalloutInterface.java,v 1.1 2008/07/29 16:04:29 jrmt Exp $
 */
public interface CalloutInterface
{
	/**
	 * 	Callout Interface
	 *	@param ctx context
	 * 	@param windowNo window no
	 * 	@param po business object
	 *	@param field field
	 *	@param oldValue old value
	 *	@param newValue new value
	 *	@param method method name
	 *	@return Change Info
	 */
	public ChangeVO start(Ctx ctx, int windowNo, PO po, 
			UIField field, String oldValue, String newValue, String method);
	
}	//	CalloutInterface
