/******************************************************************************
 * Product: Compiere ERP & CRM Smart Business Solution                        *
 * Copyright (C) 1999-2007 ComPiere, Inc. All Rights Reserved.                *
 * This program is free software, you can redistribute it and/or modify it    *
 * under the terms version 2 of the GNU General Public License as published   *
 * by the Free Software Foundation. This program is distributed in the hope   *
 * that it will be useful, but WITHOUT ANY WARRANTY, without even the implied *
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.           *
 * See the GNU General Public License for more details.                       *
 * You should have received a copy of the GNU General Public License along    *
 * with this program, if not, write to the Free Software Foundation, Inc.,    *
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.                     *
 * For the text or an alternative of this public license, you may reach us    *
 * ComPiere, Inc., 3600 Bridge Parkway #102, Redwood City, CA 94065, USA      *
 * or via info@compiere.org or http://www.compiere.org/license.html           *
 *****************************************************************************/
package org.compiere.model;

/** Generated Model - DO NOT CHANGE */
import java.sql.*;
import java.math.*;
import org.compiere.framework.*;
import org.compiere.util.*;
/** Generated Model for AD_Modification
 *  @author Jorg Janke (generated) 
 *  @version Release 3.0.0 - $Id: X_AD_Modification.java,v 1.1.4.1 2009/03/29 07:41:16 jrmt Exp $ */
public class X_AD_Modification extends PO
{
/** Standard Constructor
@param ctx context
@param AD_Modification_ID id
@param trxName transaction
*/
public X_AD_Modification (Ctx ctx, int AD_Modification_ID, String trxName)
{
super (ctx, AD_Modification_ID, trxName);
/** if (AD_Modification_ID == 0)
{
setAD_Modification_ID (0);
setAD_Version_ID (0);
setModificationType (null);
setName (null);
setSeqNo (0);	// @SQL=SELECT COALESCE(MAX(SeqNo),0)+10 FROM AD_Modification WHERE AD_Version_ID='@AD_Version_ID@'
}
 */
}
/** Load Constructor 
@param ctx context
@param rs result set 
@param trxName transaction
*/
public X_AD_Modification (Ctx ctx, ResultSet rs, String trxName)
{
super (ctx, rs, trxName);
}
/** Serial Version No */
static final long serialVersionUID = 27465617318789L;
/** Last Updated Timestamp 2007-07-04 04:46:42.0 */
public static final long updatedMS = 1183492002000L;
/** AD_Table_ID=883 */
public static final int Table_ID=883;

/** TableName=AD_Modification */
public static final String Table_Name="AD_Modification";

protected static KeyNamePair Model = new KeyNamePair(883,"AD_Modification");

protected BigDecimal accessLevel = new BigDecimal(4);
/** AccessLevel
@return 4 - System 
*/
protected int get_AccessLevel()
{
return accessLevel.intValue();
}
/** Load Meta Data
@param ctx context
@return PO Info
*/
protected POInfo initPO (Ctx ctx)
{
POInfo poi = POInfo.getPOInfo (ctx, Table_ID);
return poi;
}
/** Info
@return info
*/
public String toString()
{
StringBuffer sb = new StringBuffer ("X_AD_Modification[").append(get_ID()).append("]");
return sb.toString();
}
/** Set Modification.
@param AD_Modification_ID System Modification or Extension */
public void setAD_Modification_ID (int AD_Modification_ID)
{
if (AD_Modification_ID < 1) throw new IllegalArgumentException ("AD_Modification_ID is mandatory.");
set_ValueNoCheck ("AD_Modification_ID", new Integer(AD_Modification_ID));
}
/** Get Modification.
@return System Modification or Extension */
public int getAD_Modification_ID() 
{
Integer ii = (Integer)get_Value("AD_Modification_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Entity Version.
@param AD_Version_ID Entity Version */
public void setAD_Version_ID (int AD_Version_ID)
{
if (AD_Version_ID < 1) throw new IllegalArgumentException ("AD_Version_ID is mandatory.");
set_ValueNoCheck ("AD_Version_ID", new Integer(AD_Version_ID));
}
/** Get Entity Version.
@return Entity Version */
public int getAD_Version_ID() 
{
Integer ii = (Integer)get_Value("AD_Version_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Description.
@param Description Optional short description of the record */
public void setDescription (String Description)
{
if (Description != null && Description.length() > 255)
{
log.warning("Length > 255 - truncated");
Description = Description.substring(0,255);
}
set_Value ("Description", Description);
}
/** Get Description.
@return Optional short description of the record */
public String getDescription() 
{
return (String)get_Value("Description");
}
/** Set Comment.
@param Help Comment, Help or Hint */
public void setHelp (String Help)
{
if (Help != null && Help.length() > 2000)
{
log.warning("Length > 2000 - truncated");
Help = Help.substring(0,2000);
}
set_Value ("Help", Help);
}
/** Get Comment.
@return Comment, Help or Hint */
public String getHelp() 
{
return (String)get_Value("Help");
}

/** ModificationType AD_Reference_ID=429 */
public static final int MODIFICATIONTYPE_AD_Reference_ID=429;
/** Functionality Improvement = 1 */
public static final String MODIFICATIONTYPE_FunctionalityImprovement = "1";
/** Technology Improvement = 2 */
public static final String MODIFICATIONTYPE_TechnologyImprovement = "2";
/** Business Process Improvement = 3 */
public static final String MODIFICATIONTYPE_BusinessProcessImprovement = "3";
/** Bug Fix = 9 */
public static final String MODIFICATIONTYPE_BugFix = "9";
/** Is test a valid value.
@param test testvalue
@returns true if valid **/
public boolean isModificationTypeValid (String test)
{
return test.equals("1") || test.equals("2") || test.equals("3") || test.equals("9");
}
/** Set Modification Type.
@param ModificationType Type of Modification */
public void setModificationType (String ModificationType)
{
if (ModificationType == null) throw new IllegalArgumentException ("ModificationType is mandatory");
if (!isModificationTypeValid(ModificationType))
throw new IllegalArgumentException ("ModificationType Invalid value - " + ModificationType + " - Reference_ID=429 - 1 - 2 - 3 - 9");
if (ModificationType.length() > 1)
{
log.warning("Length > 1 - truncated");
ModificationType = ModificationType.substring(0,1);
}
set_Value ("ModificationType", ModificationType);
}
/** Get Modification Type.
@return Type of Modification */
public String getModificationType() 
{
return (String)get_Value("ModificationType");
}
/** Set Name.
@param Name Alphanumeric identifier of the entity */
public void setName (String Name)
{
if (Name == null) throw new IllegalArgumentException ("Name is mandatory.");
if (Name.length() > 60)
{
log.warning("Length > 60 - truncated");
Name = Name.substring(0,60);
}
set_Value ("Name", Name);
}
/** Get Name.
@return Alphanumeric identifier of the entity */
public String getName() 
{
return (String)get_Value("Name");
}
/** Get Record ID/ColumnName
@return ID/ColumnName pair */
public KeyNamePair getKeyNamePair() 
{
return new KeyNamePair(get_ID(), getName());
}
/** Set Sequence.
@param SeqNo Method of ordering elements;
 lowest number comes first */
public void setSeqNo (int SeqNo)
{
set_Value ("SeqNo", new Integer(SeqNo));
}
/** Get Sequence.
@return Method of ordering elements;
 lowest number comes first */
public int getSeqNo() 
{
Integer ii = (Integer)get_Value("SeqNo");
if (ii == null) return 0;
return ii.intValue();
}
}
