/******************************************************************************
 * Product: Compiere ERP & CRM Smart Business Solution                        *
 * Copyright (C) 1999-2007 ComPiere, Inc. All Rights Reserved.                *
 * This program is free software, you can redistribute it and/or modify it    *
 * under the terms version 2 of the GNU General Public License as published   *
 * by the Free Software Foundation. This program is distributed in the hope   *
 * that it will be useful, but WITHOUT ANY WARRANTY, without even the implied *
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.           *
 * See the GNU General Public License for more details.                       *
 * You should have received a copy of the GNU General Public License along    *
 * with this program, if not, write to the Free Software Foundation, Inc.,    *
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.                     *
 * For the text or an alternative of this public license, you may reach us    *
 * ComPiere, Inc., 3600 Bridge Parkway #102, Redwood City, CA 94065, USA      *
 * or via info@compiere.org or http://www.compiere.org/license.html           *
 *****************************************************************************/
package org.compiere.model;

/** Generated Model - DO NOT CHANGE */
import java.sql.*;
import java.math.*;
import org.compiere.framework.*;
import org.compiere.util.*;
/** Generated Model for CM_Media_Server
 *  @author Jorg Janke (generated) 
 *  @version Release 3.0.0 - $Id: X_CM_Media_Server.java,v 1.1.4.1 2009/03/29 07:41:07 jrmt Exp $ */
public class X_CM_Media_Server extends PO
{
/** Standard Constructor
@param ctx context
@param CM_Media_Server_ID id
@param trxName transaction
*/
public X_CM_Media_Server (Ctx ctx, int CM_Media_Server_ID, String trxName)
{
super (ctx, CM_Media_Server_ID, trxName);
/** if (CM_Media_Server_ID == 0)
{
setCM_Media_Server_ID (0);
setCM_WebProject_ID (0);
setIsPassive (false);
setName (null);
}
 */
}
/** Load Constructor 
@param ctx context
@param rs result set 
@param trxName transaction
*/
public X_CM_Media_Server (Ctx ctx, ResultSet rs, String trxName)
{
super (ctx, rs, trxName);
}
/** Serial Version No */
static final long serialVersionUID = 27427451846789L;
/** Last Updated Timestamp 2006-04-18 11:15:30.0 */
public static final long updatedMS = 1145326530000L;
/** AD_Table_ID=859 */
public static final int Table_ID=859;

/** TableName=CM_Media_Server */
public static final String Table_Name="CM_Media_Server";

protected static KeyNamePair Model = new KeyNamePair(859,"CM_Media_Server");

protected BigDecimal accessLevel = new BigDecimal(6);
/** AccessLevel
@return 6 - System - Client 
*/
protected int get_AccessLevel()
{
return accessLevel.intValue();
}
/** Load Meta Data
@param ctx context
@return PO Info
*/
protected POInfo initPO (Ctx ctx)
{
POInfo poi = POInfo.getPOInfo (ctx, Table_ID);
return poi;
}
/** Info
@return info
*/
public String toString()
{
StringBuffer sb = new StringBuffer ("X_CM_Media_Server[").append(get_ID()).append("]");
return sb.toString();
}
/** Set Media Server.
@param CM_Media_Server_ID Media Server list to which content should get transfered */
public void setCM_Media_Server_ID (int CM_Media_Server_ID)
{
if (CM_Media_Server_ID < 1) throw new IllegalArgumentException ("CM_Media_Server_ID is mandatory.");
set_ValueNoCheck ("CM_Media_Server_ID", new Integer(CM_Media_Server_ID));
}
/** Get Media Server.
@return Media Server list to which content should get transfered */
public int getCM_Media_Server_ID() 
{
Integer ii = (Integer)get_Value("CM_Media_Server_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Web Project.
@param CM_WebProject_ID A web project is the main data container for Containers, URLs, Ads, Media etc. */
public void setCM_WebProject_ID (int CM_WebProject_ID)
{
if (CM_WebProject_ID < 1) throw new IllegalArgumentException ("CM_WebProject_ID is mandatory.");
set_ValueNoCheck ("CM_WebProject_ID", new Integer(CM_WebProject_ID));
}
/** Get Web Project.
@return A web project is the main data container for Containers, URLs, Ads, Media etc. */
public int getCM_WebProject_ID() 
{
Integer ii = (Integer)get_Value("CM_WebProject_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Description.
@param Description Optional short description of the record */
public void setDescription (String Description)
{
if (Description != null && Description.length() > 255)
{
log.warning("Length > 255 - truncated");
Description = Description.substring(0,255);
}
set_Value ("Description", Description);
}
/** Get Description.
@return Optional short description of the record */
public String getDescription() 
{
return (String)get_Value("Description");
}
/** Set Folder.
@param Folder A folder on a local or remote system to store data into */
public void setFolder (String Folder)
{
if (Folder != null && Folder.length() > 60)
{
log.warning("Length > 60 - truncated");
Folder = Folder.substring(0,60);
}
set_Value ("Folder", Folder);
}
/** Get Folder.
@return A folder on a local or remote system to store data into */
public String getFolder() 
{
return (String)get_Value("Folder");
}
/** Set Comment.
@param Help Comment, Help or Hint */
public void setHelp (String Help)
{
if (Help != null && Help.length() > 2000)
{
log.warning("Length > 2000 - truncated");
Help = Help.substring(0,2000);
}
set_Value ("Help", Help);
}
/** Get Comment.
@return Comment, Help or Hint */
public String getHelp() 
{
return (String)get_Value("Help");
}
/** Set IP Address.
@param IP_Address Defines the IP address to transfer data to */
public void setIP_Address (String IP_Address)
{
if (IP_Address != null && IP_Address.length() > 20)
{
log.warning("Length > 20 - truncated");
IP_Address = IP_Address.substring(0,20);
}
set_Value ("IP_Address", IP_Address);
}
/** Get IP Address.
@return Defines the IP address to transfer data to */
public String getIP_Address() 
{
return (String)get_Value("IP_Address");
}
/** Set Transfer passive.
@param IsPassive FTP passive transfer */
public void setIsPassive (boolean IsPassive)
{
set_Value ("IsPassive", new Boolean(IsPassive));
}
/** Get Transfer passive.
@return FTP passive transfer */
public boolean isPassive() 
{
Object oo = get_Value("IsPassive");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set Name.
@param Name Alphanumeric identifier of the entity */
public void setName (String Name)
{
if (Name == null) throw new IllegalArgumentException ("Name is mandatory.");
if (Name.length() > 60)
{
log.warning("Length > 60 - truncated");
Name = Name.substring(0,60);
}
set_Value ("Name", Name);
}
/** Get Name.
@return Alphanumeric identifier of the entity */
public String getName() 
{
return (String)get_Value("Name");
}
/** Get Record ID/ColumnName
@return ID/ColumnName pair */
public KeyNamePair getKeyNamePair() 
{
return new KeyNamePair(get_ID(), getName());
}
/** Set Password.
@param Password Password of any length (case sensitive) */
public void setPassword (String Password)
{
if (Password != null && Password.length() > 40)
{
log.warning("Length > 40 - truncated");
Password = Password.substring(0,40);
}
set_Value ("Password", Password);
}
/** Get Password.
@return Password of any length (case sensitive) */
public String getPassword() 
{
return (String)get_Value("Password");
}
/** Set URL.
@param URL Full URL address - e.g. http://www.compiere.org */
public void setURL (String URL)
{
if (URL != null && URL.length() > 120)
{
log.warning("Length > 120 - truncated");
URL = URL.substring(0,120);
}
set_Value ("URL", URL);
}
/** Get URL.
@return Full URL address - e.g. http://www.compiere.org */
public String getURL() 
{
return (String)get_Value("URL");
}
/** Set Registered EMail.
@param UserName Email of the responsible for the System */
public void setUserName (String UserName)
{
if (UserName != null && UserName.length() > 40)
{
log.warning("Length > 40 - truncated");
UserName = UserName.substring(0,40);
}
set_Value ("UserName", UserName);
}
/** Get Registered EMail.
@return Email of the responsible for the System */
public String getUserName() 
{
return (String)get_Value("UserName");
}
}
