/******************************************************************************
 * Product: Compiere ERP & CRM Smart Business Solution                        *
 * Copyright (C) 1999-2007 ComPiere, Inc. All Rights Reserved.                *
 * This program is free software, you can redistribute it and/or modify it    *
 * under the terms version 2 of the GNU General Public License as published   *
 * by the Free Software Foundation. This program is distributed in the hope   *
 * that it will be useful, but WITHOUT ANY WARRANTY, without even the implied *
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.           *
 * See the GNU General Public License for more details.                       *
 * You should have received a copy of the GNU General Public License along    *
 * with this program, if not, write to the Free Software Foundation, Inc.,    *
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.                     *
 * For the text or an alternative of this public license, you may reach us    *
 * ComPiere, Inc., 3600 Bridge Parkway #102, Redwood City, CA 94065, USA      *
 * or via info@compiere.org or http://www.compiere.org/license.html           *
 *****************************************************************************/
package org.compiere.model;

/** Generated Model - DO NOT CHANGE */
import java.sql.*;
import java.math.*;
import org.compiere.framework.*;
import org.compiere.util.*;
/** Generated Model for C_BankAccount
 *  @author Jorg Janke (generated) 
 *  @version Release 3.0.0 - $Id: X_C_BankAccount.java,v 1.1.4.1 2009/03/29 07:41:12 jrmt Exp $ */
public class X_C_BankAccount extends PO
{
/** Standard Constructor
@param ctx context
@param C_BankAccount_ID id
@param trxName transaction
*/
public X_C_BankAccount (Ctx ctx, int C_BankAccount_ID, String trxName)
{
super (ctx, C_BankAccount_ID, trxName);
/** if (C_BankAccount_ID == 0)
{
setAccountNo (null);
setBankAccountType (null);
setC_BankAccount_ID (0);
setC_Bank_ID (0);
setC_Currency_ID (0);	// @$C_Currency_ID@
setCreditLimit (Env.ZERO);
setCurrentBalance (Env.ZERO);
setIsDefault (false);
}
 */
}
/** Load Constructor 
@param ctx context
@param rs result set 
@param trxName transaction
*/
public X_C_BankAccount (Ctx ctx, ResultSet rs, String trxName)
{
super (ctx, rs, trxName);
}
/** Serial Version No */
static final long serialVersionUID = 27482614910789L;
/** Last Updated Timestamp 2008-01-16 22:19:54.0 */
public static final long updatedMS = 1200489594000L;
/** AD_Table_ID=297 */
public static final int Table_ID=297;

/** TableName=C_BankAccount */
public static final String Table_Name="C_BankAccount";

protected static KeyNamePair Model = new KeyNamePair(297,"C_BankAccount");

protected BigDecimal accessLevel = new BigDecimal(3);
/** AccessLevel
@return 3 - Client - Org 
*/
protected int get_AccessLevel()
{
return accessLevel.intValue();
}
/** Load Meta Data
@param ctx context
@return PO Info
*/
protected POInfo initPO (Ctx ctx)
{
POInfo poi = POInfo.getPOInfo (ctx, Table_ID);
return poi;
}
/** Info
@return info
*/
public String toString()
{
StringBuffer sb = new StringBuffer ("X_C_BankAccount[").append(get_ID()).append("]");
return sb.toString();
}
/** Set Account Name.
@param A_Name Name on Credit Card or Account holder */
public void setA_Name (String A_Name)
{
if (A_Name != null && A_Name.length() > 60)
{
log.warning("Length > 60 - truncated");
A_Name = A_Name.substring(0,60);
}
set_Value ("A_Name", A_Name);
}
/** Get Account Name.
@return Name on Credit Card or Account holder */
public String getA_Name() 
{
return (String)get_Value("A_Name");
}
/** Set Account No.
@param AccountNo Account Number */
public void setAccountNo (String AccountNo)
{
if (AccountNo == null) throw new IllegalArgumentException ("AccountNo is mandatory.");
if (AccountNo.length() > 20)
{
log.warning("Length > 20 - truncated");
AccountNo = AccountNo.substring(0,20);
}
set_Value ("AccountNo", AccountNo);
}
/** Get Account No.
@return Account Number */
public String getAccountNo() 
{
return (String)get_Value("AccountNo");
}
/** Set BBAN.
@param BBAN Basic Bank Account Number */
public void setBBAN (String BBAN)
{
if (BBAN != null && BBAN.length() > 40)
{
log.warning("Length > 40 - truncated");
BBAN = BBAN.substring(0,40);
}
set_Value ("BBAN", BBAN);
}
/** Get BBAN.
@return Basic Bank Account Number */
public String getBBAN() 
{
return (String)get_Value("BBAN");
}

/** BankAccountType AD_Reference_ID=216 */
public static final int BANKACCOUNTTYPE_AD_Reference_ID=216;
/** Checking = C */
public static final String BANKACCOUNTTYPE_Checking = "C";
/** Savings = S */
public static final String BANKACCOUNTTYPE_Savings = "S";
/** Is test a valid value.
@param test testvalue
@returns true if valid **/
public boolean isBankAccountTypeValid (String test)
{
return test.equals("C") || test.equals("S");
}
/** Set Bank Account Type.
@param BankAccountType Bank Account Type */
public void setBankAccountType (String BankAccountType)
{
if (BankAccountType == null) throw new IllegalArgumentException ("BankAccountType is mandatory");
if (!isBankAccountTypeValid(BankAccountType))
throw new IllegalArgumentException ("BankAccountType Invalid value - " + BankAccountType + " - Reference_ID=216 - C - S");
if (BankAccountType.length() > 1)
{
log.warning("Length > 1 - truncated");
BankAccountType = BankAccountType.substring(0,1);
}
set_Value ("BankAccountType", BankAccountType);
}
/** Get Bank Account Type.
@return Bank Account Type */
public String getBankAccountType() 
{
return (String)get_Value("BankAccountType");
}
/** Set BranchCode.
@param BranchCode BranchCode */
public void setBranchCode (String BranchCode)
{
if (BranchCode != null && BranchCode.length() > 32)
{
log.warning("Length > 32 - truncated");
BranchCode = BranchCode.substring(0,32);
}
set_Value ("BranchCode", BranchCode);
}
/** Get BranchCode.
@return BranchCode */
public String getBranchCode() 
{
return (String)get_Value("BranchCode");
}
/** Set BranchName.
@param BranchName BranchName */
public void setBranchName (String BranchName)
{
if (BranchName != null && BranchName.length() > 60)
{
log.warning("Length > 60 - truncated");
BranchName = BranchName.substring(0,60);
}
set_Value ("BranchName", BranchName);
}
/** Get BranchName.
@return BranchName */
public String getBranchName() 
{
return (String)get_Value("BranchName");
}
/** Set Bank Account.
@param C_BankAccount_ID Account at the Bank */
public void setC_BankAccount_ID (int C_BankAccount_ID)
{
if (C_BankAccount_ID < 1) throw new IllegalArgumentException ("C_BankAccount_ID is mandatory.");
set_ValueNoCheck ("C_BankAccount_ID", new Integer(C_BankAccount_ID));
}
/** Get Bank Account.
@return Account at the Bank */
public int getC_BankAccount_ID() 
{
Integer ii = (Integer)get_Value("C_BankAccount_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Bank.
@param C_Bank_ID Bank */
public void setC_Bank_ID (int C_Bank_ID)
{
if (C_Bank_ID < 1) throw new IllegalArgumentException ("C_Bank_ID is mandatory.");
set_ValueNoCheck ("C_Bank_ID", new Integer(C_Bank_ID));
}
/** Get Bank.
@return Bank */
public int getC_Bank_ID() 
{
Integer ii = (Integer)get_Value("C_Bank_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Get Record ID/ColumnName
@return ID/ColumnName pair */
public KeyNamePair getKeyNamePair() 
{
return new KeyNamePair(get_ID(), String.valueOf(getC_Bank_ID()));
}
/** Set Currency.
@param C_Currency_ID The Currency for this record */
public void setC_Currency_ID (int C_Currency_ID)
{
if (C_Currency_ID < 1) throw new IllegalArgumentException ("C_Currency_ID is mandatory.");
set_Value ("C_Currency_ID", new Integer(C_Currency_ID));
}
/** Get Currency.
@return The Currency for this record */
public int getC_Currency_ID() 
{
Integer ii = (Integer)get_Value("C_Currency_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Credit limit.
@param CreditLimit Amount of Credit allowed */
public void setCreditLimit (BigDecimal CreditLimit)
{
if (CreditLimit == null) throw new IllegalArgumentException ("CreditLimit is mandatory.");
set_Value ("CreditLimit", CreditLimit);
}
/** Get Credit limit.
@return Amount of Credit allowed */
public BigDecimal getCreditLimit() 
{
BigDecimal bd = (BigDecimal)get_Value("CreditLimit");
if (bd == null) return Env.ZERO;
return bd;
}
/** Set Current balance.
@param CurrentBalance Current Balance */
public void setCurrentBalance (BigDecimal CurrentBalance)
{
if (CurrentBalance == null) throw new IllegalArgumentException ("CurrentBalance is mandatory.");
set_Value ("CurrentBalance", CurrentBalance);
}
/** Get Current balance.
@return Current Balance */
public BigDecimal getCurrentBalance() 
{
BigDecimal bd = (BigDecimal)get_Value("CurrentBalance");
if (bd == null) return Env.ZERO;
return bd;
}
/** Set Description.
@param Description Optional short description of the record */
public void setDescription (String Description)
{
if (Description != null && Description.length() > 255)
{
log.warning("Length > 255 - truncated");
Description = Description.substring(0,255);
}
set_Value ("Description", Description);
}
/** Get Description.
@return Optional short description of the record */
public String getDescription() 
{
return (String)get_Value("Description");
}
/** Set IBAN.
@param IBAN International Bank Account Number */
public void setIBAN (String IBAN)
{
if (IBAN != null && IBAN.length() > 40)
{
log.warning("Length > 40 - truncated");
IBAN = IBAN.substring(0,40);
}
set_Value ("IBAN", IBAN);
}
/** Get IBAN.
@return International Bank Account Number */
public String getIBAN() 
{
return (String)get_Value("IBAN");
}
/** Set Default.
@param IsDefault Default value */
public void setIsDefault (boolean IsDefault)
{
set_Value ("IsDefault", new Boolean(IsDefault));
}
/** Get Default.
@return Default value */
public boolean isDefault() 
{
Object oo = get_Value("IsDefault");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
}
