/******************************************************************************
 * Product: Compiere ERP & CRM Smart Business Solution                        *
 * Copyright (C) 1999-2007 ComPiere, Inc. All Rights Reserved.                *
 * This program is free software, you can redistribute it and/or modify it    *
 * under the terms version 2 of the GNU General Public License as published   *
 * by the Free Software Foundation. This program is distributed in the hope   *
 * that it will be useful, but WITHOUT ANY WARRANTY, without even the implied *
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.           *
 * See the GNU General Public License for more details.                       *
 * You should have received a copy of the GNU General Public License along    *
 * with this program, if not, write to the Free Software Foundation, Inc.,    *
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.                     *
 * For the text or an alternative of this public license, you may reach us    *
 * ComPiere, Inc., 3600 Bridge Parkway #102, Redwood City, CA 94065, USA      *
 * or via info@compiere.org or http://www.compiere.org/license.html           *
 *****************************************************************************/
package org.compiere.model;

/** Generated Model - DO NOT CHANGE */
import java.sql.*;
import java.math.*;
import org.compiere.framework.*;
import org.compiere.util.*;
/** Generated Model for M_CostElement
 *  @author Jorg Janke (generated) 
 *  @version Release 3.0.0 - $Id: X_M_CostElement.java,v 1.1.4.1 2009/03/29 07:41:00 jrmt Exp $ */
public class X_M_CostElement extends PO
{
/** Standard Constructor
@param ctx context
@param M_CostElement_ID id
@param trxName transaction
*/
public X_M_CostElement (Ctx ctx, int M_CostElement_ID, String trxName)
{
super (ctx, M_CostElement_ID, trxName);
/** if (M_CostElement_ID == 0)
{
setCostElementType (null);
setIsCalculated (false);
setM_CostElement_ID (0);
setName (null);
}
 */
}
/** Load Constructor 
@param ctx context
@param rs result set 
@param trxName transaction
*/
public X_M_CostElement (Ctx ctx, ResultSet rs, String trxName)
{
super (ctx, rs, trxName);
}
/** Serial Version No */
static final long serialVersionUID = 27408797700789L;
/** Last Updated Timestamp 2005-09-14 13:33:04.0 */
public static final long updatedMS = 1126672384000L;
/** AD_Table_ID=770 */
public static final int Table_ID=770;

/** TableName=M_CostElement */
public static final String Table_Name="M_CostElement";

protected static KeyNamePair Model = new KeyNamePair(770,"M_CostElement");

protected BigDecimal accessLevel = new BigDecimal(2);
/** AccessLevel
@return 2 - Client 
*/
protected int get_AccessLevel()
{
return accessLevel.intValue();
}
/** Load Meta Data
@param ctx context
@return PO Info
*/
protected POInfo initPO (Ctx ctx)
{
POInfo poi = POInfo.getPOInfo (ctx, Table_ID);
return poi;
}
/** Info
@return info
*/
public String toString()
{
StringBuffer sb = new StringBuffer ("X_M_CostElement[").append(get_ID()).append("]");
return sb.toString();
}

/** CostElementType AD_Reference_ID=338 */
public static final int COSTELEMENTTYPE_AD_Reference_ID=338;
/** Burden (M.Overhead) = B */
public static final String COSTELEMENTTYPE_BurdenMOverhead = "B";
/** Material = M */
public static final String COSTELEMENTTYPE_Material = "M";
/** Overhead = O */
public static final String COSTELEMENTTYPE_Overhead = "O";
/** Resource = R */
public static final String COSTELEMENTTYPE_Resource = "R";
/** Outside Processing = X */
public static final String COSTELEMENTTYPE_OutsideProcessing = "X";
/** Is test a valid value.
@param test testvalue
@returns true if valid **/
public boolean isCostElementTypeValid (String test)
{
return test.equals("B") || test.equals("M") || test.equals("O") || test.equals("R") || test.equals("X");
}
/** Set Cost Element Type.
@param CostElementType Type of Cost Element */
public void setCostElementType (String CostElementType)
{
if (CostElementType == null) throw new IllegalArgumentException ("CostElementType is mandatory");
if (!isCostElementTypeValid(CostElementType))
throw new IllegalArgumentException ("CostElementType Invalid value - " + CostElementType + " - Reference_ID=338 - B - M - O - R - X");
if (CostElementType.length() > 1)
{
log.warning("Length > 1 - truncated");
CostElementType = CostElementType.substring(0,1);
}
set_Value ("CostElementType", CostElementType);
}
/** Get Cost Element Type.
@return Type of Cost Element */
public String getCostElementType() 
{
return (String)get_Value("CostElementType");
}

/** CostingMethod AD_Reference_ID=122 */
public static final int COSTINGMETHOD_AD_Reference_ID=122;
/** Average PO = A */
public static final String COSTINGMETHOD_AveragePO = "A";
/** Fifo = F */
public static final String COSTINGMETHOD_Fifo = "F";
/** Average Invoice = I */
public static final String COSTINGMETHOD_AverageInvoice = "I";
/** Lifo = L */
public static final String COSTINGMETHOD_Lifo = "L";
/** Standard Costing = S */
public static final String COSTINGMETHOD_StandardCosting = "S";
/** User Defined = U */
public static final String COSTINGMETHOD_UserDefined = "U";
/** Last Invoice = i */
public static final String COSTINGMETHOD_LastInvoice = "i";
/** Last PO Price = p */
public static final String COSTINGMETHOD_LastPOPrice = "p";
/** _ = x */
public static final String COSTINGMETHOD__ = "x";
/** Is test a valid value.
@param test testvalue
@returns true if valid **/
public boolean isCostingMethodValid (String test)
{
return test == null || test.equals("A") || test.equals("F") || test.equals("I") || test.equals("L") || test.equals("S") || test.equals("U") || test.equals("i") || test.equals("p") || test.equals("x");
}
/** Set Costing Method.
@param CostingMethod Indicates how Costs will be calculated */
public void setCostingMethod (String CostingMethod)
{
if (!isCostingMethodValid(CostingMethod))
throw new IllegalArgumentException ("CostingMethod Invalid value - " + CostingMethod + " - Reference_ID=122 - A - F - I - L - S - U - i - p - x");
if (CostingMethod != null && CostingMethod.length() > 1)
{
log.warning("Length > 1 - truncated");
CostingMethod = CostingMethod.substring(0,1);
}
set_Value ("CostingMethod", CostingMethod);
}
/** Get Costing Method.
@return Indicates how Costs will be calculated */
public String getCostingMethod() 
{
return (String)get_Value("CostingMethod");
}
/** Set Description.
@param Description Optional short description of the record */
public void setDescription (String Description)
{
if (Description != null && Description.length() > 255)
{
log.warning("Length > 255 - truncated");
Description = Description.substring(0,255);
}
set_Value ("Description", Description);
}
/** Get Description.
@return Optional short description of the record */
public String getDescription() 
{
return (String)get_Value("Description");
}
/** Set Calculated.
@param IsCalculated The value is calculated by the system */
public void setIsCalculated (boolean IsCalculated)
{
set_Value ("IsCalculated", new Boolean(IsCalculated));
}
/** Get Calculated.
@return The value is calculated by the system */
public boolean isCalculated() 
{
Object oo = get_Value("IsCalculated");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set Cost Element.
@param M_CostElement_ID Product Cost Element */
public void setM_CostElement_ID (int M_CostElement_ID)
{
if (M_CostElement_ID < 1) throw new IllegalArgumentException ("M_CostElement_ID is mandatory.");
set_ValueNoCheck ("M_CostElement_ID", new Integer(M_CostElement_ID));
}
/** Get Cost Element.
@return Product Cost Element */
public int getM_CostElement_ID() 
{
Integer ii = (Integer)get_Value("M_CostElement_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Name.
@param Name Alphanumeric identifier of the entity */
public void setName (String Name)
{
if (Name == null) throw new IllegalArgumentException ("Name is mandatory.");
if (Name.length() > 60)
{
log.warning("Length > 60 - truncated");
Name = Name.substring(0,60);
}
set_Value ("Name", Name);
}
/** Get Name.
@return Alphanumeric identifier of the entity */
public String getName() 
{
return (String)get_Value("Name");
}
/** Get Record ID/ColumnName
@return ID/ColumnName pair */
public KeyNamePair getKeyNamePair() 
{
return new KeyNamePair(get_ID(), getName());
}
}
