/******************************************************************************
 * Product: Compiere ERP & CRM Smart Business Solution                        *
 * Copyright (C) 1999-2006 ComPiere, Inc. All Rights Reserved.                *
 * This program is free software; you can redistribute it and/or modify it    *
 * under the terms version 2 of the GNU General Public License as published   *
 * by the Free Software Foundation. This program is distributed in the hope   *
 * that it will be useful, but WITHOUT ANY WARRANTY; without even the implied *
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.           *
 * See the GNU General Public License for more details.                       *
 * You should have received a copy of the GNU General Public License along    *
 * with this program; if not, write to the Free Software Foundation, Inc.,    *
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.                     *
 * For the text or an alternative of this public license, you may reach us    *
 * ComPiere, Inc., 2620 Augustine Dr. #245, Santa Clara, CA 95054, USA        *
 * or via info@compiere.org or http://www.compiere.org/license.html           *
 *****************************************************************************/
package org.compiere.vos;
import java.io.Serializable;
import java.util.*;

import org.compiere.common.constants.Build;
import org.compiere.util.CLoggerSimple;
import org.compiere.util.CompiereLogger;
import org.compiere.util.Ctx;
import org.compiere.util.Evaluatee;
import org.compiere.util.Evaluator;

/**
 *  Model Tab Value Object
 *
 *  @author Jorg Janke
 *  @version  $Id: ComponentVO.java,v 1.1 2008/07/29 16:08:13 jrmt Exp $
 */
public class ComponentVO extends TabFieldsVO
{
	/**
	 * 
	 * 
	 */
	public static CompiereLogger	log = new CLoggerSimple(ComponentVO.class);
	private static final long serialVersionUID = 1L;
	/** Context - replicated    */
	//public  Properties      ctx;
	/** Window No - replicated  */
	public  int				windowNO;

	/** AD Window - replicated  */
	// gwu: AD_Window_ID has been replaced with UWindowID below.
	public  UWindowID       uid;


	public  int    			Referenced_Tab_ID;
	/** Tab No (not AD_Tab_ID) 0.. */
	public  int				tabNo;

	/**	Tab	ID			*/
	public	int		    AD_Tab_ID;
	/** Name			*/
	public	String	    name = "";
	/** Description		*/
	public	String	    description = "";
	/** Help			*/
	public	String	    help = "";
	/** Single Row		*/
	public	boolean	    isSingleRow = false;
	public boolean	isInfoTab = false;
	public long seqNo;
	/** Read Only		*/
	public  boolean     isReadOnly = false;
	public boolean isDisplayed = true;

	/** Insert Record	*/
	public 	boolean		isInsertRecord = true;
	public boolean isTranslationTab;
	public boolean isAdvancedTab;
	/** Tree			*/
	public  boolean	    hasTree = false;
	/** Table			*/
	public  int		    AD_Table_ID;
	/** Primary Parent Column   */
	public  int		    AD_Column_ID = 0;
	/** Table Name		*/
	public  String	    tableName;
	/** Table is View	*/
	public  boolean     isView = false;
	/** Table Access Level	*/
	public  String	    accessLevel;
	/** Security		*/
	public  boolean	    isSecurityEnabled = false;
	/** Table Deleteable	*/
	public  boolean	    isDeleteable = false;
	/** Table High Volume	*/
	public  boolean     isHighVolume = false;
	/** Process			*/
	public	int		    AD_Process_ID = 0;
	/** Commot Warning	*/
	public  String	    commitWarning;
	/** Where			*/
	public  String	    whereClause;
	/** Order by		*/
	public  String      orderByClause;
	/** Tab Read Only	*/
	public  String      readOnlyLogic;
	/** Tab Display		*/
	public  String      displayLogic;
	/** Level			*/
	public  int         tabLevel = 0;
	/** Image			*/
	public int          AD_Image_ID = 0;
	/** Included Tab	*/
	public int          Included_Tab_ID = 0;
	/** Replication Type	*/
	public String		replicationType = "L";

	/** Sort Tab			*/
	public boolean		isSortTab = false;
	/** Column Sort			*/
	public int			AD_ColumnSortOrder_ID = 0;
	/** Column Displayed	*/
	public int			AD_ColumnSortYesNo_ID = 0;

	/** Only Current Rows - derived	*/
	public  boolean     onlyCurrentRows = true;
	/**	Only Current Days - derived	*/
	public int			onlyCurrentDays = 0;

	/** Fields contain MFieldVO entities    */
	public String linkColumnName;


	
	/**
	 * @gwt.typeArgs < java.lang.Integer >
	 */
	public ArrayList keyColsPos = null;

	public boolean canExport = false;
	public boolean canReport = false;

	public int AD_InfoWindow_ID = -1;
	public int componentType;
	public boolean isMultiSelect;

	public static String SELECTED_ROWS = "###SELECTED_ROWS###";
	public static String SELECTED_ROW_NOS = "###SELECTED_ROW_NOS###";
	public static final String SELECTED_ROW_INDEXES = "###SELECTED_ROW_INDEXES###";
	public final static int SEARCH_COMPONENT = 1;
	public final static int SINGLE_TABLE_COMPONENT = 2;
	public final static int MULTI_TABLE_COMPONENT = 3;
	/**
	 * @gwt.typeArgs <java.lang.String>
	 */	 
	public ArrayList	savedQueries = new ArrayList();

	public FieldVO getFieldVO(String columnName) {
		for(int j=0; j<fieldVOs.size(); j++) {
			FieldVO fVO = (FieldVO)fieldVOs.get(j);
			if(columnName.equals(fVO.ColumnName))
				return fVO;
		}
		return null;
	}


	public String getRowKey(String[] row )
	{
		/*	StringBuffer key = new StringBuffer( "" );
		for( int i = 0; i < fieldVOs.size(); i++ )
		{
			FieldVO f = (FieldVO) fieldVOs.get( i );
			if( f.IsKey ){
				if(key.length() > 0){
					key.append("-");
				}
				key.append( row[i] );
			}
		}
		//in this case, we use isParent
		if("".equals(key.toString())) {
			for( int i = 0; i < fieldVOs.size(); i++ )
			{
				FieldVO f = (FieldVO) fieldVOs.get( i );
				if( f.IsParent ){
					if(key.length() > 0){
						key.append("-");
					}
					key.append( row[i] );
				}
			}
		}
		if(Env.isDebug())
			log.finest( "getRowKey: the key is:" + key );
		 */
		StringBuffer key = new StringBuffer("");
		if(keyColsPos == null)
			throw new IllegalStateException("keyColsPos cannot be null!");
		for(int i=0; i<keyColsPos.size(); i++ ) {
			if(key.length() > 0){
				key.append("-");
			}
			key.append(row[((Integer)keyColsPos.get(i)).intValue()]);
		}

		return key.toString();
	}

	public String keyColumnName() {
		return ((FieldVO)fieldVOs.get(((Integer)keyColsPos.get(0)).intValue())).ColumnName;
	}

	public boolean isPrinted()
	{
		return AD_Process_ID != 0;
	}	//	isPrinted

	public boolean isDisplayed(Ctx ctx, Evaluatee eval) {
		//  ** static content **
		//  not displayed
		if (!isDisplayed)
			return false;
		//  no restrictions
		String logic = displayLogic;
		if (logic == null || logic.equals(""))
			return returnDisplayed(ctx);

		//  ** dynamic content **
		if (eval != null)
		{
			boolean retValue = Evaluator.evaluateLogic(eval, logic);
			if(Build.isVerbose())
				log.finest(tableName 
						+ " (" + logic + ") => " + retValue);
			if(!retValue)
				return false;
		}
		return returnDisplayed(ctx);
	}
	private boolean returnDisplayed(Ctx ctx) {
		return (!isAdvancedTab || (isAdvancedTab && "Y".equals(ctx.getContext("ShowAdvanced"))))
		&&(!isTranslationTab || (isTranslationTab && "Y".equals(ctx.getContext("ShowTrl"))))
		&&(!isInfoTab || (isInfoTab && "Y".equals(ctx.getContext("ShowAcct"))));
	}
	public boolean isReadOnly(Evaluatee e) {
		//if("Y".equals(e.get_ValueAsString("Processed")))
		//return true;
		if(isReadOnly || isView)
			return true;

		//  no restrictions
		if (readOnlyLogic == null || readOnlyLogic.equals(""))
			return isReadOnly;

		//  ** dynamic content **  uses get_ValueAsString
		boolean retValue = Evaluator.evaluateLogic(e, readOnlyLogic);
		//log.finest(m_vo.Name 
//		+ " (" + m_vo.ReadOnlyLogic + ") => " + retValue);
		return retValue;
	}


	public static int SEARCH_TAB_NO = 10000;

}

