/******************************************************************************
 * The contents of this file are subject to the   Compiere License  Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * You may obtain a copy of the License at http://www.compiere.org/license.html
 * Software distributed under the License is distributed on an  "AS IS"  basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for
 * the specific language governing rights and limitations under the License.
 * The Original Code is Compiere ERP & CRM Smart Business Solution. The Initial
 * Developer of the Original Code is Jorg Janke. Portions created by Jorg Janke
 * are Copyright (C) 1999-2005 Jorg Janke.
 * All parts are Copyright (C) 1999-2005 ComPiere, Inc.  All Rights Reserved.
 * Contributor(s): ______________________________________.
 *****************************************************************************/
package com.ampiere.grid.ed;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;

import org.compiere.model.GridTab;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MBankStatement;
import org.compiere.model.MInOut;
import org.compiere.model.MInventory;
import org.compiere.model.MInvoice;
import org.compiere.model.MJournal;
import org.compiere.model.MJournalBatch;
import org.compiere.model.MMovement;
import org.compiere.model.MOrder;
import org.compiere.model.MPayment;
import org.compiere.process.DocumentEngine;
import org.compiere.util.CLogger;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.wf.MWFActivity;

import com.ampiere.util.AmpiereUtil;

/**
 *	Displays valid Document Action Options based on context
 *
 * 	@author 	Jorg Janke
 * 	@version 	$Id: WDocAction.java,v 1.1 2008/09/30 12:26:46 clmg Exp $
 */
public class WDocAction
{
	/**
	 *	Constructor.
	 *  Started from APanel. 
	 * 	getNumberOfOptions()is used to determine to show the dialog
	 *  @param WindowNo window no
	 *  @param mTab tab
	 * 	@param Record_ID record id
	 */
	public WDocAction (int WindowNo, GridTab mTab, int Record_ID, Ctx ctx)
	{
		log.config("");

		m_WindowNo = WindowNo;
		m_mTab = mTab;

		//	dynamic init preparation
		//m_AD_Table_ID = Env.getContextAsInt(ctx, WindowNo, "BaseTable_ID");
		m_AD_Table_ID = ctx.getContextAsInt(WindowNo, "BaseTable_ID");
		if (s_value == null) {
			readReference(ctx);
		}

		//
		dynInit(Record_ID, ctx);
	}	//	WDocAction

	//
	private int					m_WindowNo = 0;
	private int					m_AD_Table_ID;
	private GridTab       		m_mTab;
	//
	private String[]			s_value = null;
	private String[]			s_name;
	private String[] 			s_description;

	/**	Logger			*/
	private static CLogger log = CLogger.getCLogger(WDocAction.class);

	//
	private String actionLabel = "";
	private ArrayList<String> actionCombo = new ArrayList<String>();
	private ArrayList<String> actionComboDesc = new ArrayList<String>();
	private ArrayList<String> actionComboValue = new ArrayList<String>();
	private String actionComboSelected = "";
	private String actionComboDescSelected = "";
	private String batchButton = "";

	/**
	 *	Dynamic Init - determine valid DocActions based on DocStatus for the different documents.
	 *  <pre>
	 *  DocStatus (131)
			??                         Unknown
			AP *                       Approved
			CH                         Changed
			CL *                       Closed
			CO *                       Completed
			DR                         Drafted
			IN                         Inactive
			NA                         Not Approved
			PE                         Posting Error
			PO *                       Posted
			PR *                       Printed
			RE                         Reversed
			TE                         Transfer Error
			TR *                       Transferred
			VO *                       Voided
			XX                         Being Processed
	 *
	 *   DocAction (135)
			--                         <None>
			AP *                       Approve
			CL *                       Close
			CO *                       Complete
			PO *                       Post
			PR *                       Print
			RA                         Reverse - Accrual
			RC                         Reverse - Correction
			RE                         RE-activate
			RJ                         Reject
			TR *                       Transfer
			VO *                       Void
			XL                         Unlock
	 *  </pre>
	 * 	@param Record_ID id
	 */
	private void dynInit(int Record_ID, Ctx ctx)
	{
		actionLabel = (Msg.translate(ctx, "DocAction"));
		batchButton = (Msg.getMsg(ctx, "StartBackground"));

		String DocStatus = (String)m_mTab.getValue("DocStatus");
		String DocAction = (String)m_mTab.getValue("DocAction");
		//
		Object Processing = m_mTab.getValue("Processing");
//		String OrderType = Env.getContext(ctx, m_WindowNo, "OrderType");
//		String IsSOTrx = Env.getContext(ctx, m_WindowNo, "IsSOTrx");
		String OrderType = ctx.getContext(m_WindowNo, "OrderType");
		String IsSOTrx = ctx.getContext(m_WindowNo, "IsSOTrx");

		if (DocStatus == null)
		{
			log.log(Level.SEVERE, "***ERROR***");
			return;
		}

		log.fine("DocStatus=" + DocStatus 
			+ ", DocAction=" + DocAction + ", OrderType=" + OrderType 
			+ ", IsSOTrx=" + IsSOTrx + ", Processing=" + Processing 
			+ ", AD_Table_ID=" + m_AD_Table_ID + ", Record_ID=" + Record_ID);
		//
		String[] options = new String[s_value.length];
		int index = 0;

		/**
		 * 	Check Existence of Workflow Acrivities
		 */

		String wfStatus = MWFActivity.getActiveInfo(ctx, m_AD_Table_ID, Record_ID); 
		if (wfStatus != null)
		{
			log.log(Level.SEVERE, "WFActiveForRecord");
			return;
		}

		//	Status Change
		if (!checkStatus(m_mTab.getTableName(), Record_ID, DocStatus))
		{
//			ADialog.error(m_WindowNo, this, "DocumentStatusChanged");
			log.log(Level.SEVERE, "DocumentStatusChanged");
			return;
		}

		/*******************
		 *  General Actions
		 */

		//	Locked
		if (Processing != null)
		{
			boolean locked = "Y".equals(Processing);
			if (!locked && Processing instanceof Boolean)
				locked = ((Boolean)Processing).booleanValue();
			if (locked)
				options[index++] = DocumentEngine.ACTION_Unlock;
		}

		//	Approval required           ..  NA
		if (DocStatus.equals(DocumentEngine.STATUS_NotApproved))
		{
			options[index++] = DocumentEngine.ACTION_Prepare;
			options[index++] = DocumentEngine.ACTION_Void;
		}
		//	Draft/Invalid				..  DR/IN
		else if (DocStatus.equals(DocumentEngine.STATUS_Drafted)
			|| DocStatus.equals(DocumentEngine.STATUS_Invalid))
		{
			options[index++] = DocumentEngine.ACTION_Complete;
		//	options[index++] = DocumentEngine.ACTION_Prepare;
			options[index++] = DocumentEngine.ACTION_Void;
		}
		//	In Process                  ..  IP
		else if (DocStatus.equals(DocumentEngine.STATUS_InProgress)
			|| DocStatus.equals(DocumentEngine.STATUS_Approved))
		{
			options[index++] = DocumentEngine.ACTION_Complete;
			options[index++] = DocumentEngine.ACTION_Void;
		}
		//	Complete                    ..  CO
		else if (DocStatus.equals(DocumentEngine.STATUS_Completed))
		{
			options[index++] = DocumentEngine.ACTION_Close;
		}
		//	Waiting Payment
		else if (DocStatus.equals(DocumentEngine.STATUS_WaitingPayment)
			|| DocStatus.equals(DocumentEngine.STATUS_WaitingConfirmation))
		{
			options[index++] = DocumentEngine.ACTION_Void;
			options[index++] = DocumentEngine.ACTION_Prepare;
		}
		//	Closed, Voided, REversed    ..  CL/VO/RE
		else if (DocStatus.equals(DocumentEngine.STATUS_Closed) 
			|| DocStatus.equals(DocumentEngine.STATUS_Voided) 
			|| DocStatus.equals(DocumentEngine.STATUS_Reversed))
			return;

		/********************
		 *  Order
		 */
		if (m_AD_Table_ID == MOrder.Table_ID)
		{
			//	Draft                       ..  DR/IP/IN
			if (DocStatus.equals(DocumentEngine.STATUS_Drafted)
				|| DocStatus.equals(DocumentEngine.STATUS_InProgress)
				|| DocStatus.equals(DocumentEngine.STATUS_Invalid))
			{
				options[index++] = DocumentEngine.ACTION_Prepare;
				options[index++] = DocumentEngine.ACTION_Close;
				//	Draft Sales Order Quote/Proposal - Process
				if ("Y".equals(IsSOTrx)
					&& ("OB".equals(OrderType) || "ON".equals(OrderType)))
					DocAction = DocumentEngine.ACTION_Prepare;
			}
			//	Complete                    ..  CO
			else if (DocStatus.equals(DocumentEngine.STATUS_Completed))
			{
				options[index++] = DocumentEngine.ACTION_Void;
				options[index++] = DocumentEngine.ACTION_ReActivate;
			}
			else if (DocStatus.equals(DocumentEngine.STATUS_WaitingPayment))
			{
				options[index++] = DocumentEngine.ACTION_ReActivate;
				options[index++] = DocumentEngine.ACTION_Close;
			}
		}
		/********************
		 *  Shipment
		 */
		else if (m_AD_Table_ID == MInOut.Table_ID)
		{
			//	Complete                    ..  CO
			if (DocStatus.equals(DocumentEngine.STATUS_Completed))
			{
				options[index++] = DocumentEngine.ACTION_Void;
				options[index++] = DocumentEngine.ACTION_Reverse_Correct;
			}
		}
		/********************
		 *  Invoice
		 */
		else if (m_AD_Table_ID == MInvoice.Table_ID)
		{
			//	Complete                    ..  CO
			if (DocStatus.equals(DocumentEngine.STATUS_Completed))
			{
				options[index++] = DocumentEngine.ACTION_Void;
				options[index++] = DocumentEngine.ACTION_Reverse_Correct;
			}
		}
		/********************
		 *  Payment
		 */
		else if (m_AD_Table_ID == MPayment.Table_ID)
		{
			//	Complete                    ..  CO
			if (DocStatus.equals(DocumentEngine.STATUS_Completed))
			{
				options[index++] = DocumentEngine.ACTION_Void;
				options[index++] = DocumentEngine.ACTION_Reverse_Correct;
			}
		}
		/********************
		 *  GL Journal
		 */
		else if (m_AD_Table_ID == MJournal.Table_ID || m_AD_Table_ID == MJournalBatch.Table_ID)
		{
			//	Complete                    ..  CO
			if (DocStatus.equals(DocumentEngine.STATUS_Completed))
			{
				options[index++] = DocumentEngine.ACTION_Reverse_Correct;
				options[index++] = DocumentEngine.ACTION_Reverse_Accrual;
			}
		}
		/********************
		 *  Allocation
		 */
		else if (m_AD_Table_ID == MAllocationHdr.Table_ID)
		{
			//	Complete                    ..  CO
			if (DocStatus.equals(DocumentEngine.STATUS_Completed))
			{
				options[index++] = DocumentEngine.ACTION_Void;
				options[index++] = DocumentEngine.ACTION_Reverse_Correct;
			}
		}
		/********************
		 *  Bank Statement
		 */
		else if (m_AD_Table_ID == MBankStatement.Table_ID)
		{
			//	Complete                    ..  CO
			if (DocStatus.equals(DocumentEngine.STATUS_Completed))
			{
				options[index++] = DocumentEngine.ACTION_Void;
			}
		}
		/********************
		 *  Inventory Movement, Physical Inventory
		 */
		else if (m_AD_Table_ID == MMovement.Table_ID
			|| m_AD_Table_ID == MInventory.Table_ID)
		{
			//	Complete                    ..  CO
			if (DocStatus.equals(DocumentEngine.STATUS_Completed))
			{
				options[index++] = DocumentEngine.ACTION_Void;
				options[index++] = DocumentEngine.ACTION_Reverse_Correct;
			}
		}


		/**
		 *	Fill actionCombo
		 */
		for (int i = 0; i < index; i++)
		{
			//	Serach for option and add it
			boolean added = false;
			for (int j = 0; j < s_value.length && !added; j++)
				if (options[i].equals(s_value[j]))
				{
					actionCombo.add(s_name[j]);
					actionComboDesc.add(s_description[j]);
					actionComboValue.add(s_value[j]);
					added = true;
				}
		}

		//	setDefault
		if (DocAction.equals("--"))		//	If None, suggest closing
			DocAction = DocumentEngine.ACTION_Close;
		String defaultV = "";
		String defaultDesc = "";
		for (int i = 0; i < s_value.length && defaultV.equals(""); i++) {
			if (DocAction.equals(s_value[i])) {
				defaultV = s_name[i];
				defaultDesc = s_description[i];
			}
		}
		if (!defaultV.equals("")) {
			actionComboSelected = defaultV;
			actionComboDescSelected = defaultDesc;
		}
	}	//	dynInit

	/**
	 * 	Check Status Change
	 *	@param TableName table name
	 *	@param Record_ID record
	 *	@param DocStatus current doc status
	 *	@return true if status not changed
	 */
	private boolean checkStatus (String TableName, int Record_ID, String DocStatus)
	{
		String sql = "SELECT 2 FROM " + TableName 
			+ " WHERE " + TableName + "_ID=" + Record_ID
			+ " AND DocStatus='" + DocStatus + "'";
		int result = DB.getSQLValue(null, sql);
		return result == 2;
	}	//	checkStatusChange

	/**
	 *	Number of options available (to decide to display it)
	 *  @return item count
	 */
	public int getNumberOfOptions()
	{
		return actionCombo.size();
	}	//	getNumberOfOptions

	/**
	 *	Fill Vector with DocAction Ref_List(135) values
	 */
	private void readReference(Ctx ctx)
	{
		String sql;
		if (Env.isBaseLanguage(ctx, "AD_Ref_List"))
			sql = "SELECT Value, Name, Description FROM AD_Ref_List "
				+ "WHERE AD_Reference_ID=135 ORDER BY Name";
		else
			sql = "SELECT l.Value, t.Name, t.Description "
				+ "FROM AD_Ref_List l, AD_Ref_List_Trl t "
				+ "WHERE l.AD_Ref_List_ID=t.AD_Ref_List_ID"
				+ " AND t.AD_Language='" + Env.getAD_Language(ctx) + "'"
				+ " AND l.AD_Reference_ID=135 ORDER BY t.Name";

		ArrayList<String> v_value = new ArrayList<String>();
		ArrayList<String> v_name = new ArrayList<String>();
		ArrayList<String> v_description = new ArrayList<String>();
		try
		{
			PreparedStatement pstmt = DB.prepareStatement(sql, null);
			ResultSet rs = pstmt.executeQuery();
			while (rs.next())
			{
				String value = rs.getString(1);
				String name = rs.getString(2);
				String description = rs.getString(3);
				if (description == null)
					description = "";
				//
				v_value.add(value);
				v_name.add(name);
				v_description.add(description);
			}
			rs.close();
			pstmt.close();
		}
		catch (SQLException e)
		{
			log.log(Level.SEVERE, sql, e);
		}

		//	convert to arrays
		int size = v_value.size();
		s_value = new String[size];
		s_name = new String[size];
		s_description = new String[size];
		for (int i = 0; i < size; i++)
		{
			s_value[i] = (String)v_value.get(i);
			s_name[i] = (String)v_name.get(i);
			s_description[i] = (String)v_description.get(i);
		}
	}	//	readReference

	/**
	 * Get dropdown list box
	 * @return
	 */
	public ArrayList<String> getActionCombo() {
		return actionCombo;
	}

	/**
	 * Get description array for action
	 * @return
	 */
	public String getActionComboDescArray() {
		if (actionComboDesc.size() > 0) {
			String p[] = new String [actionComboDesc.size()];
			for (int i = 0; i < actionComboDesc.size(); i++) {
				p[i] = (String)actionComboDesc.get(i);
			}
			return AmpiereUtil.generateJavascriptArray(p);
		}

		return null;
	}

	/**
	 * Get value array for action
	 * @return
	 */
	public String getActionComboValueArray() {
		if (actionComboValue.size() > 0) {
			String p[] = new String [actionComboValue.size()];
			for (int i = 0; i < actionComboValue.size(); i++) {
				p[i] = (String)actionComboValue.get(i);
			}
			return AmpiereUtil.generateJavascriptArray(p);
		}

		return null;
	}

	/**
	 * Get current description for action
	 * @return
	 */
	public String getActionComboDescSelected() {
		return actionComboDescSelected;
	}

	/**
	 * Get current action
	 * @return
	 */
	public String getActionComboSelected() {
		return actionComboSelected;
	}

	/**
	 * Get action dropdown list label
	 * @return
	 */
	public String getActionLabel() {
		return actionLabel;
	}

	/**
	 * Get batch button title
	 * @return
	 */
	public String getBatchButton() {
		return batchButton;
	}
}	//	WDocAction
