/******************************************************************************
 * The contents of this file are subject to the   Compiere License  Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * You may obtain a copy of the License at http://www.compiere.org/license.html
 * Software distributed under the License is distributed on an  "AS IS"  basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for
 * the specific language governing rights and limitations under the License.
 * The Original Code is Compiere ERP & CRM Smart Business Solution. The Initial
 * Developer of the Original Code is Jorg Janke. Portions created by Jorg Janke
 * are Copyright (C) 1999-2005 Jorg Janke.
 * All parts are Copyright (C) 1999-2005 ComPiere, Inc.  All Rights Reserved.
 * Contributor(s): ______________________________________.
 *****************************************************************************/
package com.ampiere.grid.ed;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;

import org.compiere.model.MLocatorLookup;
import org.compiere.model.MRole;
import org.compiere.util.CLogger;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.KeyNamePair;

/**
 *	Dialog to enter Warehouse Locator Info
 *
 *  @author 	Jorg Janke
 *  @version 	$Id: WLocatorDialog.java,v 1.1 2008/09/30 12:26:46 clmg Exp $
 */
public class WLocatorDialog
{
	/**
	 *	Constructor
	 *  @param frame frame
	 *  @param title title
	 *  @param mLocator locator
	 *  @param M_Locator_ID locator id
	 * 	@param mandatory mandatory
	 * 	@param only_Warehouse_ID of not 0 restrict warehouse
	 */
	public WLocatorDialog (String title, MLocatorLookup mLocator,
		int M_Locator_ID, boolean mandatory, int only_Warehouse_ID, int windowNo, Ctx ctx)
	{
//		m_WindowNo = windowNo;
		try
		{
			jbInit(ctx);
		}
		catch(Exception ex)
		{
			log.log(Level.SEVERE, "WLocatorDialog", ex);
		}
		//
		m_mLocator = mLocator;
//		m_M_Locator_ID = M_Locator_ID;
		m_mandatory = mandatory;
		m_only_Warehouse_ID = only_Warehouse_ID;
		//
		initLocator();
	}	//	WLocatorDialog

//	private int				m_WindowNo;
//	private boolean 		m_change = false;
	private MLocatorLookup	m_mLocator;
//	private int				m_M_Locator_ID;
	private boolean			m_mandatory = false;
	private int				m_only_Warehouse_ID = 0;
	//
	private int				m_M_Warehouse_ID;
//	private String			m_M_WarehouseName;
//	private String 			m_M_WarehouseValue;
//	private String 			m_Separator;
//	private int				m_AD_Client_ID;
//	private int				m_AD_Org_ID;
	/**	Logger			*/
	private static CLogger log = CLogger.getCLogger(WLocatorDialog.class);

	//
//	private ArrayList<MLocator> fLocator = new ArrayList<MLocator>();
	private ArrayList<KeyNamePair> fWarehouse = new ArrayList<KeyNamePair>();
//	private String fCreateNew = "";
//	private String lLocator = "";
//	private String lWarehouseInfo = "";
//	private String lWarehouse = "";
//	private String lX = "";
//	private String lY = "";
//	private String lZ = "";
//	private String lValue = "";

	/**
	 *	Static component init
	 *  @throws Exception
	 */
	private void jbInit(Ctx ctx) throws Exception
	{
//		fCreateNew = Msg.translate(ctx, "CreateNew");
//		lLocator = Msg.translate(ctx, "M_Locator_ID");
//		lWarehouseInfo = Msg.translate(ctx, "M_Warehouse_ID");
//		lWarehouse = Msg.translate(ctx, "M_Warehouse_ID");
//		lX = Msg.getElement(ctx, "X");
//		lY = Msg.getElement(ctx, "Y");
//		lZ = Msg.getElement(ctx, "Z");
//		lValue = Msg.translate(ctx, "Value");
	}	//	jbInit

	/**
	 *	Dynanmic Init & fill fields
	 */
	private void initLocator()
	{
		log.fine("");

		//	Load Warehouse
		String sql = "SELECT M_Warehouse_ID, Name FROM M_Warehouse";
		if (m_only_Warehouse_ID != 0)
			sql += " WHERE M_Warehouse_ID=" + m_only_Warehouse_ID;
		String SQL = MRole.getDefault().addAccessSQL(
			sql, "M_Warehouse", MRole.SQL_NOTQUALIFIED, MRole.SQL_RO)
			+ " ORDER BY 2";
		try
		{
			PreparedStatement pstmt = DB.prepareStatement(SQL, null);
			ResultSet rs = pstmt.executeQuery();
			while (rs.next())
				fWarehouse.add(new KeyNamePair(rs.getInt(1), rs.getString(2)));
			rs.close();
			pstmt.close();
		}
		catch (SQLException e)
		{
			log.log(Level.SEVERE, SQL, e);
		}
		log.fine( "Warehouses=" + fWarehouse.size());

		//	Load existing Locators
		m_mLocator.fillComboBox(m_mandatory, true, true, false);
		log.fine(m_mLocator.toString());
//		fLocator.setModel(m_mLocator);
//		fLocator.setValue(m_M_Locator_ID);
	}	//	initLocator

	/**
	 *	Get Warehouse Info
	 *  @param M_Warehouse_ID warehouse
	 */
	protected void getWarehouseInfo (int M_Warehouse_ID)
	{
		if (M_Warehouse_ID == m_M_Warehouse_ID)
			return;
		//	Defaults
		m_M_Warehouse_ID = 0;
//		m_M_WarehouseName = "";
//		m_M_WarehouseValue = "";
//		m_Separator = ".";
//		m_AD_Client_ID = 0;
//		m_AD_Org_ID = 0;
		//
		String SQL = "SELECT M_Warehouse_ID, Value, Name, Separator, AD_Client_ID, AD_Org_ID "
			+ "FROM M_Warehouse WHERE M_Warehouse_ID=?";
		try
		{
			PreparedStatement pstmt = DB.prepareStatement(SQL, null);
			pstmt.setInt(1, M_Warehouse_ID);
			ResultSet rs = pstmt.executeQuery();
			if (rs.next())
			{
				m_M_Warehouse_ID = rs.getInt(1);
//				m_M_WarehouseValue = rs.getString(2);
//				m_M_WarehouseName = rs.getString(3);
//				m_Separator = rs.getString(4);
//				m_AD_Client_ID = rs.getInt(5);
//				m_AD_Org_ID = rs.getInt(6);
			}
			rs.close();
			pstmt.close();
		}
		catch (SQLException e)
		{
			log.log(Level.SEVERE, SQL, e);
		}
	}	//	getWarehouseInfo
}	//	WLocatorDialog
