/**
 * 
 */
package com.ampiere.search;

import java.io.Serializable;
import java.util.Hashtable;

/**
 * @author Shinjirito
 *
 */
public class ColBean implements Serializable {
	private static final long serialVersionUID = -8808925426412412835L;
	private static final int SIZE_INCREMENT = 100;
	private int maxSize = 100;
	private String colId = "";
	private String colName = "";
	private Hashtable<Integer, String> styles = new Hashtable<Integer, String>();
	private Object m_colData[] = new Object [maxSize];
	private String m_colTitle[] = new String [maxSize];

	/**
	 * Set column data
	 * @param index column index
	 * @param data data
	 */
	public void setColData(int index, Object data) {
		if (index >= 0 && index < maxSize) {
			m_colData[index] = data;
		} else if (index >= maxSize) {
			// Increase the capacity of columns
			increaseCapacity();

			// Set data
			m_colData[index] = data;
		}
	}

	/**
	 * Get column data
	 * @param index column index
	 * @return column data
	 */
	public Object getColData(int index) {
		if (index >= 0 && index < maxSize) {
			return m_colData[index];
		}

		return "";
	}

	/**
	 * Set column title
	 * @param index column index
	 * @param title title
	 */
	public void setColTitle(int index, String title) {
		if (index >= 0 && index < maxSize) {
			m_colTitle[index] = title;
		} else if (index >= maxSize) {
			// Increase the capacity of columns
			increaseCapacity();

			// Set title
			m_colTitle[index] = title;
		}
	}

	/**
	 * Get column title
	 * @param index column index
	 * @return column title
	 */
	public String getColTitle(int index) {
		if (index >= 0 && index < maxSize) {
			return m_colTitle[index];
		}

		return "";
	}

	/**
	 * Get column id
	 * @return column id
	 */
	public String getColId() {
		return colId;
	}

	/**
	 * Set column id
	 * @param colId column id
	 */
	public void setColId(String colId) {
		this.colId = colId;
	}

	/**
	 * Get column name
	 * @return column name
	 */
	public String getColName() {
		return colName;
	}

	/**
	 * Set column name
	 * @param colName column name
	 */
	public void setColName(String colName) {
		this.colName = colName;
	}

	/**
	 * Increase the capacity of columns data and title array
	 */
	private void increaseCapacity() {
		int newSize = maxSize + SIZE_INCREMENT;

		// Data array
	    Object oldData[] = m_colData;
	    m_colData = new Object [newSize];
	    System.arraycopy(oldData, 0, m_colData, 0, maxSize);

		// Title array
	    String oldTitle[] = m_colTitle;
	    m_colTitle = new String [newSize];
	    System.arraycopy(oldTitle, 0, m_colTitle, 0, maxSize);

	    maxSize = newSize;
	}

	/**
	 * Set column styles(align, valign, nowrap, etc...)
	 * @param index
	 * @param style
	 */
	public void setStyle(int index, String style) {
		styles.put(index, style);
	}

	/**
	 * Get column style
	 * @return
	 */
	public String getStyle(int index) {
		String t = (String)styles.get(index);
		if (t != null) {
			return t;
		}
		return "";
	}
}
