/**
 * 
 */
package com.ampiere.web.struts.search;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.compiere.util.CLogger;
import org.compiere.util.Msg;
import org.compiere.util.WebSessionCtx;

import com.ampiere.search.InfoPAttribute;

/**
 * @author Shinjirito
 *
 */
public class InfoPAttributeAction extends InfoBaseAction {
	/**	Logger			*/
	protected CLogger	log = CLogger.getCLogger(this.getClass());

	/* (non-Javadoc)
	 * @see com.jware.base.web.struts.jWareBaseAction#doExecute(org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse, org.apache.struts.action.ActionErrors, boolean)
	 */
	public ActionForward doExecute(ActionMapping mapping, ActionForm baseForm,
			HttpServletRequest request, HttpServletResponse response,
			ActionErrors errors, boolean mochaFlag) throws Exception {
		super.doExecute(mapping, baseForm, request, response, errors, mochaFlag);

		HttpSession session = request.getSession();
		InfoPAttributeForm infoPattributeForm = (InfoPAttributeForm)baseForm;
		if (infoPattributeForm != null) {
		  	WebSessionCtx wsc = WebSessionCtx.get(request);
		  	infoPattributeForm.setTitle(Msg.translate(wsc.ctx, "InfoPAttribute"));
		  	infoPattributeForm.setCloseBtnTitle(Msg.translate(wsc.ctx, "Cancel"));
		  	infoPattributeForm.setSubmitBtnTitle(Msg.translate(wsc.ctx, "OK"));
		  	infoPattributeForm.setDateInfos(wsc.language.getLocale(), wsc.dateFormat.toPattern());

			// Set search info form
			InfoPAttribute infoPAttribute = new InfoPAttribute(wsc.ctx);
			session.setAttribute("infoPattributeForm", infoPattributeForm);
			session.setAttribute("infoPAttribute", infoPAttribute);
		}

	    return mapping.findForward("success");
	}
}
