/**
 * 
 */
package com.ampiere.web.struts.search;

import java.util.ArrayList;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.compiere.framework.Lookup;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;

import com.ampiere.search.InfoPAttribute;
import com.ampiere.search.InfoProduct;
import com.ampiere.util.AmpiereUtil;

/**
 * @author Shinjirito
 *
 */
public class InfoProductSearchAction extends InfoBaseAction {
	/**	Logger			*/
	protected CLogger	log = CLogger.getCLogger(getClass());

	/**
	 * 
	 */
	public ActionForward doExecute(ActionMapping mapping, ActionForm baseForm, HttpServletRequest request, HttpServletResponse response, ActionErrors errors, boolean mochaFlag) throws Exception {
		super.doExecute(mapping, baseForm, request, response, errors, mochaFlag);

		WebSessionCtx wsc = WebSessionCtx.get(request);
		HttpSession session = request.getSession();
		InfoProductForm searchInfoFormProduct = (InfoProductForm)baseForm;
		session.setAttribute("searchResultProduct", null);
		if (searchInfoFormProduct != null) {
			int windowNo = searchInfoFormProduct.getWindowNo();
			int AD_Column_ID = searchInfoFormProduct.getColumn_ID();
			String columnName = searchInfoFormProduct.getColumnName();

			// Create column lookup 
			Lookup lookup = createLookup(wsc.ctx, windowNo, AD_Column_ID, columnName);

			// Get where clause
			String whereClause = getWhereClause(wsc.ctx, lookup, columnName);

			String value = searchInfoFormProduct.getValue();
			if (WebEnv.NBSP_UNICODE.equals(value)) {
				value = "";
			}
			String name = searchInfoFormProduct.getName();
			if (WebEnv.NBSP_UNICODE.equals(name)) {
				name = "";
			}
			if (value.length() == 0 && name != null && name.length() > 0) {
				value = "@" + name + "@";   //  Name indicator - otherwise Value
			}
//			int M_Warehouse_ID = Env.getContextAsInt(wsc.ctx, windowNo, "M_Warehouse_ID");
//			int M_PriceList_ID = Env.getContextAsInt(wsc.ctx, windowNo, "M_PriceList_ID");
			int M_Warehouse_ID = wsc.ctx.getContextAsInt(windowNo, "M_Warehouse_ID");
			int M_PriceList_ID = wsc.ctx.getContextAsInt(windowNo, "M_PriceList_ID");

			String attributeWhere = null;
			String paSearchFlag = searchInfoFormProduct.getPaSearchFlag();
			if (paSearchFlag != null && "true".equals(paSearchFlag)) {
				// Product Attribute Search
				InfoPAttribute infoPAttribute = (InfoPAttribute)session.getAttribute("infoPAttribute");
				if (infoPAttribute != null) {
					attributeWhere = infoPAttribute.getWhereClause(searchInfoFormProduct.getPaSearchWhere(), wsc.dateFormat);
				}
				
				if (attributeWhere != null && attributeWhere.length() > 0) {
					value = "";
				}
			}
		    InfoProduct info = new InfoProduct(windowNo, M_Warehouse_ID, M_PriceList_ID, value, false, whereClause, wsc.ctx);
		    info.setQueryParas(searchInfoFormProduct, attributeWhere);

		    // Check record number
		    int rowCount = info.testCount(wsc.ctx);
		    rowCount = AmpiereUtil.setLargeRecordMsg(wsc.ctx, searchInfoFormProduct, rowCount);
		    ArrayList result = info.executeQuery(wsc.ctx, rowCount, lookup);
		    if (result != null && result.size() > 0) {
		    	// Set search result
		    	session.setAttribute("searchResultProduct", result);
		    }
		}

		request.setAttribute("doQuery", "0");
		return mapping.findForward("success");
	}
}
