package com.jware.apps.scheduler.web.struts.schedule;

import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import org.apache.struts.validator.ValidatorForm;

import com.jware.apps.scheduler.util.JobSchedulerUtils;

/**
 * @author Jrmt
 */

public class JobTriggerForm extends ValidatorForm {
	
	public static final String START_TIME_PROP = "startTime";
	public static final String STOP_TIME_PROP = "stopTime";
	public static final String VOLATILITY_PROP = "volatility";
	public static final String MISFIRE_INSTRUCTION_PROP = "misFireInstruction";
	public static final String TRIGGER_NAME_PROP = "triggerName";
	public static final String TRIGGER_GROUP_PROP = "triggerGroup";
	public static final String DESCRIPTION_PROP = "description";
	public static final String JOB_NAME_PROP = "jobName";
	public static final String JOB_GROUP_PROP = "jobGroup";

	public static final String SCHEDULE_ACTION_PROP = "scheduleAction";
	public static final String CANCEL_ACTION_PROP = "cancelAction";

	private String startTime;
	private String stopTime;
	private boolean volatility;
	private int misFireInstruction;
	private String triggerName;
	private String triggerGroup;
	private String jobName;
	private String jobGroup;
	private String description;
	private String nextFireTime;
	private String previousFireTime;
	private String type;

	private String repeatCount;
	private String repeatInterval;
	private String cronExpression;

	private Map paramMap = new HashMap();
	private Map jobParamMap = new HashMap();
	
	public JobTriggerForm() {
	}

	
	public String getStartTime() {
		return startTime;
	}

	public Date getStartTimeAsDate() throws ParseException {
		return JobSchedulerUtils.parseStringToDate(startTime);
	}

	public void setStartTime(String startTime) {
		this.startTime = startTime;
	}

	public String getStopTime() {
		return stopTime;
	}

	public Date getStopTimeAsDate() throws ParseException {
		return JobSchedulerUtils.parseStringToDate(stopTime);
	}

	public void setStopTime(String stopTime) {
		this.stopTime = stopTime;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public boolean isVolatility() {
		return volatility;
	}

	public void setVolatility(boolean volatility) {
		this.volatility = volatility;
	}

	public int getMisFireInstruction() {
		return misFireInstruction;
	}

	public void setMisFireInstruction(int misFireInstruction) {
		this.misFireInstruction = misFireInstruction;
	}

	public String getTriggerName() {
		return triggerName;
	}

	public void setTriggerName(String name) {
		this.triggerName = name;
	}

	public String getTriggerGroup() {
		return triggerGroup;
	}

	public void setTriggerGroup(String group) {
		this.triggerGroup = group;
	}

	public String getJobName() {
		return jobName;
	}

	public void setJobName(String jobName) {
		this.jobName = jobName;
	}

	public String getJobGroup() {
		return jobGroup;
	}

	public void setJobGroup(String jobGroup) {
		this.jobGroup = jobGroup;
	}
	
	/**
	 * Returns the nextFireTime.
	 * @return String
	 */
	public String getNextFireTime() {
		return nextFireTime;
	}

	/**
	 * Sets the nextFireTime.
	 * @param nextFireTime The nextFireTime to set
	 */
	public void setNextFireTime(String nextFireTime) {
		this.nextFireTime = nextFireTime;
	}

	/**
	 * Returns the previousFireTime.
	 * @return String
	 */
	public String getPreviousFireTime() {
		return previousFireTime;
	}

	/**
	 * Sets the previousFireTime.
	 * @param previousFireTime The previousFireTime to set
	 */
	public void setPreviousFireTime(String previousFireTime) {
		this.previousFireTime = previousFireTime;
	}

	/**
	 * Returns the type.
	 * @return String
	 */
	public String getType() {
		return type;
	}

	/**
	 * Sets the type.
	 * @param type The type to set
	 */
	public void setType(String type) {
		this.type = type;
	}
	
	/**
	 * @return Returns the paramMap.
	 */
	public Map getParamMap() {
		return paramMap;
	}
	/**
	 * @param paramMap The paramMap to set.
	 */
	public void setParamMap(Map paramMap) {
		this.paramMap = paramMap;
	}
	
	/**
	 * @return Returns the repeatCount.
	 */
	public String getRepeatCount() {
		return repeatCount;
	}
	/**
	 * @param repeatCount The repeatCount to set.
	 */
	public void setRepeatCount(String repeatCount) {
		this.repeatCount = repeatCount;
	}
	/**
	 * @return Returns the repeatInterval.
	 */
	public String getRepeatInterval() {
		return repeatInterval;
	}
	/**
	 * @param repeatInterval The repeatInterval to set.
	 */
	public void setRepeatInterval(String repeatInterval) {
		this.repeatInterval = repeatInterval;
	}
	/**
	 * @return Returns the cronExpression.
	 */
	public String getCronExpression() {
		return cronExpression;
	}
	/**
	 * @param cronExpression The cronExpression to set.
	 */
	public void setCronExpression(String cronExpression) {
		this.cronExpression = cronExpression;
	}
	/**
	 * @return Returns the jobParamMap.
	 */
	public Map getJobParamMap() {
		return jobParamMap;
	}
	/**
	 * @param jobParamMap The jobParamMap to set.
	 */
	public void setJobParamMap(Map jobParamMap) {
		this.jobParamMap = jobParamMap;
	}
}
