package com.jware.base;

import java.lang.Character.UnicodeBlock;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;


import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.validator.GenericValidator;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.util.MessageResources;

import com.jware.util.DateUtils;


/**
 * Struts validator汎用クラス
 * 
 * @author $Id: JwareValidator.java,v 1.1 2008/09/30 12:26:45 clmg Exp $
 *
 */
public class JwareValidator {

    /**
     * Commons Logging instance.
     */
    protected Log log = LogFactory.getLog(this.getClass().getName());

	private ActionErrors errors = new ActionErrors();

	private MessageResources messageResources = null;

	private Locale locale = null;

	/**
	 * 
	 */
	public JwareValidator(MessageResources messageResources) {
		this(messageResources, null);
	}

	/**
	 *
	 */
	public JwareValidator(MessageResources messageResources, Locale locale) {
		clear();
		this.messageResources = messageResources;
		this.locale = locale;
	}

	/**
	 * ActionErrorsをクリアします
	 */
	public void clear() {
		errors.clear();
	}

	/**
	 * 
	 */
	public boolean isError() {
		if (errors.size() > 0) {
			return true;
		} else {
			return false;
		}
	}

	/**
	 * 
	 */
	public ActionErrors getErrors() {
		return errors;
	}

	/**
	 * 
	 */
	public void addError(String field, String errorKey, String value) {
		String msg = getMessage(value);
		if (msg != null) {
			errors.add(field, new ActionError(errorKey, msg));
		} else {
			errors.add(field, new ActionError(errorKey, value));
		}		
	}

	/**
	 * 
	 */
	public void addError(String field, String errorKey, String[] values) {
		String[] msgs = new String[values.length];
		String buff;
		for (int i=0; i<values.length; i++) {
			buff = getMessage(values[i]);
			if (buff != null) {
				msgs[i] = buff;
			} else {
				msgs[i] = values[i];
			}
		}
		
		errors.add(field, new ActionError(errorKey, msgs));
	}

	/**
	 */
	public boolean isSelected(String field, String fieldname, String errMsg,String value) {
		if (StringUtils.isEmpty(value)) {
			errors.add(field, new ActionError(errMsg, getMessage(fieldname)));
			return false;
		}
		return true;
	}

	/**
	 * 
	 */
	public boolean isChecked(String field, String fieldname, String[] values) {

		if (!(isChecked(field,fieldname,"error.code.E000009",values))) {
			return false;
		}
		return true;		
	}


	/**
	 * 
	 */
	public boolean isChecked(String field, String fieldname, String errMsg,String[] values) {

		if (values == null || values.length == 0) {
			errors.add(field, new ActionError(errMsg, getMessage(fieldname)));
			return false;
		} 
		
		int counts = values.length;
		boolean anyChr = false;
		
		for (int i=0;i<counts;i++) {
			if ((values[i] != null) && (values[i].length() > 0)) {
					anyChr = true;
			}		
		}
		
		if (!anyChr) {
			errors.add(field, new ActionError(errMsg, getMessage(fieldname)));
			return false;			
		}

		return true;

	}


	/**
	 * 
	 */
	public boolean isAlpha(String field, String fieldname, String value, boolean required, int max) {
		return isAlpha(field, fieldname, value, required, max, false, 0);
	}

	/**
	 * 
	 */
	public boolean isAlpha(String field, String fieldname, String value, boolean required, int max, int arrayCount) {
		return isAlpha(field, fieldname, value, required, max, false, arrayCount);
	}

	/**
	 */
	public boolean isAlphaFixedLength(String field, String fieldname, String value, boolean required, int max) {
		return isAlpha(field, fieldname, value, required, max, true, 0);
	}

	/**
	 */
	public boolean isAlphaFixedLength(String field, String fieldname, String value, boolean required, int max, int arrayCount) {
		return isAlpha(field, fieldname, value, required, max, true, arrayCount);
	}

	/**
	 */
	private boolean isAlpha(String field, String fieldname, String value, boolean required, int max, boolean fixedLength, int arrayCount) {
		if (!isString(field, fieldname, value, required, max,0, fixedLength, arrayCount,"")) return false;

		if (!required && StringUtils.isEmpty(value)) return true;

		if (!StringUtils.isAlpha(value)) {
			if (arrayCount > 0) {
				errors.add(field,
					new ActionError("errors.inN.alpha", String.valueOf(arrayCount), getMessage(fieldname)));
			} else {
				errors.add(field, new ActionError("errors.alpha", getMessage(fieldname)));
			}
			return false;
		}
	
		return true;
	}

	/**
	 */
	public boolean isTestNumber(String field,String fieldName,String value) {

		if (StringUtils.isAlpha(value)) {
			errors.add(field, new ActionError("errors.alpha", getMessage(fieldName)));
			return false;
		}
		return true;
	}


	/**
	 */
	public boolean isString(String field, String fieldname, String value, boolean required, int max) {
		return isString(field, fieldname, value, required, max, 0, false, 0,"errors.minlength");
	}
	
	/**
	 */
	public boolean isString(String field, String fieldname, String value, boolean required, int max,int min,String errMsg) {
		return isString(field, fieldname, value, required, max, min, false, 0,errMsg);
	}

	/**
         * errMsg分変更 (従来のはそのまま)
	 */
	public boolean isString(String field, String fieldname, String value, boolean required, int max,int arrayCount) {
		return isString(field, fieldname, value, required, max, 0,false, arrayCount,"errors.minlength");
	}

	/**
         * メッセージ追加指定ヴァージョン(指定したMSGにてチェックをしたい場合は引数にerrMsgを指定で呼ぶ.厳密にはBeautyValidatorから)
	 */
	public boolean isString(String field, String fieldname, String value, boolean required, int max,int min,int arrayCount,String errMsg) {
		return isString(field, fieldname, value, required, max,min, false, arrayCount,errMsg);
	}

	/**
	 */
	public boolean isStringFixedLength(String field, String fieldname, String value, boolean required, int max,int min,String errMsg) {
		return isString(field, fieldname, value, required, max, 0,true, 0,"errors.fixedlength");
	}

	/**
	 */
	public boolean isStringFixedLength(String field, String fieldname, String value, boolean required, int max,int min, int arrayCount,String errMsg) {
		return isString(field, fieldname, value, required, max,min, true, arrayCount,"errors.fixedlength");
	}

	/**
	 *
	 * 
	 * @param field       フィールド名
	 * @param fieldname   
	 * @param value       
	 * @param required    
	 * @param max         
	 * @param fixedLength 
	 * @param arrayCount  
	 * @return true
	 */
	private boolean isString(String field, String fieldname, String value, 
		boolean required, int max,int min, boolean fixedLength, int arrayCount,String errMsg) {
		
		boolean array = false;
		if (arrayCount > 0) {
			array = true;
		}
		
		//
		if (StringUtils.isEmpty(value)) {
			if (required) {
				if (array) {
					errors.add(field,
						new ActionError("errors.inN.required", String.valueOf(arrayCount), getMessage(fieldname)));
				} else {
					errors.add(field, new ActionError("errors.required", getMessage(fieldname)));
				}
				return false;
			} else {
				return true;
			}
		}
		
		//
		if ((fixedLength && value.getBytes().length != max)) {
			if (array) {
				errors.add(field,
					new ActionError("errors.inN.fixedlength", String.valueOf(arrayCount), getMessage(fieldname), String.valueOf(max)));
			} else {
				errors.add(field, new ActionError("errors.fixedlength", getMessage(fieldname), String.valueOf(max)));
			}
			return false;		
		
		//
		} else if (!fixedLength && (value.getBytes().length > max)) {
			if (array) {
				errors.add(field,
					new ActionError("errors.inN.minlength", String.valueOf(arrayCount), getMessage(fieldname), String.valueOf(max)));
			} else {
				errors.add(field, new ActionError(errMsg, getMessage(fieldname), String.valueOf(max),String.valueOf(min)));
			}
			return false;
		}
		
		return true;
	}

	/**
	 * 日付の妥当性チェックを行う。(個別でエラーメッセージをセットしてチェックを行う。)
	 * 
	 * @param field      対象フィールド
	 * @param fieldname  対象フィールド名
	 * @param date       対象日付
	 * @return true もし妥当性がある場合、そうでない場合false
	 */
	public boolean isDate(String field,String fieldName,String errMsg,String date) {
		if (!(DateUtils.isDate(date))) {
			errors.add(field, new ActionError(errMsg, getMessage(fieldName)));
			return false;
		}
		return true;
	}

	/**
	 * 日付の妥当性チェックを行う。(個別でエラーメッセージをセットしてチェックを行う。)
	 * 
	 * @param field      対象フィールド
	 * @param fieldname  対象フィールド名
	 * @param date       対象日付
	 * @return true もし妥当性がある場合、そうでない場合false
	 */
	public boolean isDateNull(String field,String fieldName,String errMsg,String date,boolean nullable) {
		if (!(DateUtils.isDate(date,nullable))) {
			errors.add(field, new ActionError(errMsg, getMessage(fieldName)));
			return false;
		}
		return true;
	}

	/**
	 * 日付前後チェックを行う。
	 *  
	 * @param field      対象フィールド
	 * @param fieldname  対象フィールド名
	 * @param date1      比較対象日付1
	 * @param date2      比較対象日付2
	 * @return true もし妥当性がある場合、そうでない場合false
	 */
	public boolean isDateBeforeAfter(String field,String fieldName,String errMsg,String date1,String date2) {

		//日付の妥当性チェックを行う。
		if (!(isDate(field,fieldName,errMsg,date1))) {
			return false;
		}

		//日付の妥当性チェックを行う。
		if (!(isDate(field,fieldName,errMsg,date2))) {
			return false;
		}

		//日付の前後チェックを行う。
		if (!(DateUtils.isDateBeforeAfter(date1,date2))) {
			errors.add(field, new ActionError(errMsg, getMessage(fieldName)));
			return false;
		}

		return true;

	}

	/**
	 * 日付前後チェックを行う。
	 *  
	 * @param field      対象フィールド
	 * @param fieldname  対象フィールド名
	 * @param date1      比較対象日付1
	 * @param date2      比較対象日付2
	 * @return true もし妥当性がある場合、そうでない場合false
	 */
	public boolean isDateBeforeAfterOnly(String field,String fieldName,String errMsg,String date1,String date2) {


		//日付の前後チェックを行う。
		if (!(DateUtils.isDateBeforeAfterNull(date1,date2))) {
			errors.add(field, new ActionError(errMsg, date1,date2));
			return false;
		}

		return true;

	}

	/**
	 * 日付前後チェックを行う。
	 *  
	 * @param field      対象フィールド
	 * @param fieldname  対象フィールド名
	 * @param date1      比較対象日付1
	 * @param date2      比較対象日付2
	 * @return true もし妥当性がある場合、そうでない場合false
	 */
	public boolean isDateBeforeAfterOnly(
		String field,
		String fieldName,
		String date1,
		String date2) {

		//日付の前後チェックを行う。
		if (!(DateUtils.isDateBeforeAfter(date1,date2))) {
			errors.add(field, new ActionError(field, getMessage(fieldName),date1,date2));
			return false;
		}

		return true;

	}

	/**
	 * 数値チェックを行う。
	 *  
	 * @param field      対象フィールド
	 * @param fieldname  対象フィールド名
	 * @param str      　比較対象文字列
	 * @return true もし妥当性がある場合、そうでない場合false
	 * @param required    true
	 */	
	public boolean isInt(
		String fiels,
		String fieldName,
		String str,
		boolean required) {

		if (required){	
			try {	
				int i = Integer.parseInt(str);	
			} catch (NumberFormatException e) {	
			  errors.add(
			  	fiels,new ActionError("errors.integer",getMessage(fieldName)));
			  return false;	
			}
		}	
		return true;
	}

	/**
	 * 存在チェックを行う。
	 * 
	 * @param data
	 * @return　妥当性があば「true」、そうでない場合は「false」
	 */
	public boolean isExist(String field, String fieldName, String data){
		
		//NULL又は空文字の場合はfalseを返却
		if (data == null || "".equals(data)){

			errors.add(field, new ActionError(field, getMessage(fieldName)));

			return false;

		}
		
		return true;
		
	}
	
	/**
	 * 存在チェックを行う。
	 * 
	 * @param data
	 * @return　妥当性があば「true」、そうでない場合は「false」
	 */
	public boolean isListExist(String field, String fieldName, String[] data){
		
		//NULL又は空文字の場合はfalseを返却
		if (data == null || data.length < 1){

			errors.add(field, new ActionError(field, getMessage(fieldName)));

			return false;

		}

		return true;
		
	}

	/**
	 * 文字の長さのみチェック
	 * 
	 * @param data
	 * @return　NULLでなく文字の長さが「length」以下の場合はtrueを返却
	 */
	public boolean isStringLengthExceed(
		String field, 
		String fieldName, 
		String data, 
		int length){
		
       return isStringLengthExceed(field,fieldName,field,data,length);
       		
	}

	/**
	 * 文字の長さのみチェック(errmsg制御付)
	 * 
	 * @param data
	 * @return　NULLでなく文字の長さが「length」以下の場合はtrueを返却
	 */
	public boolean isStringLengthExceed(
		String field, 
		String fieldName, 
	    String errMsg, 
		String data, 
		int length){
		
		//NULLでなく文字の長さが「length」以下の場合はtrueを返却
		if (data != null && data.length() <= length){

			return true;

		}
		
		errors.add(field, new ActionError(errMsg, getMessage(fieldName)));

		return false;
		
	}

	/**
	 * 日付フォーマットのみチェック
	 * 
	 * @param data
	 * @return　空文字又は日付フォーマットの場合はtrueを返却
	 */
	public boolean isDateNotMatterExistence(
		String field, 
		String fieldName, 
		String data){
		
		//NULLでなく文字の長さが「length」以下の場合はtrueを返却
		if (data == null || "".equals(data)){

			return true;

		}else if(!isDateType(field, fieldName, data)){
			
			return true;
			
		}
		
		return false;
		
	}

	/**
	 * 日付の前後チェック
	 * 
	 * @param data
	 * @return　片方の空文字又はtrue日付前後が正常ならtrueを返却
	 */
	public boolean isDateBeforeAfterNotMatterExistence(
		String field, 
		String fieldName, 
		String before,
		String after){

		//NULLか空文字の場合はtrueを返却
		if(before == null || "".equals(before)){

			return true;

		}
		
		//NULLか空文字の場合はtrueを返却
		if(after == null || "".equals(after)){

			return true;

		}
		
		if(!isDateBeforeAfterOnly(field, fieldName, before, after)){
			
			return false;
			
		}
		
		return true;
		
	}

	public boolean isDateType(
		String field, 
		String fieldName, 
		String data){

		//NULL又は空文字ならnullを返却
		if(data == null || "".equals(data)){

			return false;

		}

		//デートフォーマットクラスのインスタンス作成
		SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd");
		
		try {

			fmt.parse(data);

			return true;

		} catch (ParseException e) {

			errors.add(field, new ActionError(field, getMessage(fieldName)));

			return false;

		}

	}	


	/**
	 * 数値チェックを行う。
	 *  
	 * @param field      対象フィールド
	 * @param fieldname  対象フィールド名
	 * @param str      　比較対象文字列
	 * @return true もし妥当性がある場合、そうでない場合false
	 * @param required    true
	 */	
	public boolean isInt(String fiels,String fieldName,String errMsg,String str) {			
		try {	
			int i = Integer.parseInt(str);	
		} catch (NumberFormatException e) {
			errors.add(fiels,new ActionError(errMsg,getMessage(fieldName)));
		  return false;			
		}	
		return true;
	}

	/**
	 * 数値チェックを行う。
	 *  
	 * @param field      対象フィールド
	 * @param fieldname  対象フィールド名
	 * @param str      　比較対象文字列
	 * @return true もし妥当性がある場合、そうでない場合false
	 * @param required    true
	 */	
	public boolean isIntEx(String fiels,String fieldName,String errMsg,String str,boolean required) {			
		
		if (required) {
			try {	
				int i = Integer.parseInt(str);	
			} catch (NumberFormatException e) {
				if (getMessage(fieldName)==null) {
					errors.add(fiels,new ActionError(errMsg,fieldName));
				} else {
					errors.add(fiels,new ActionError(errMsg,getMessage(fieldName)));
				}
			  return false;			
			}	
		}
		
		return true;
	}
	/**
	 * E-mailのみかチェックします
	 * 
	 * @param field
	 * @param fieldName
	 * @param value
	 * @return
	 */
	public boolean isEmail(String field, String fieldName, String errMsg,String value) {

		//TODO 梅山さんのとおいおい差し替え予定

		if (!(GenericValidator.isEmail(value))) {
			errors.add(field, new ActionError(errMsg, getMessage(fieldName)));
			return false;
		}
		
		return true;
	}

	/**
	 * 全角のみかチェックします。
	 * 
	 * @param field
	 * @param fieldName
	 * @param value
	 * @return true 全文字、全角の場合
	 */
	public boolean isZenkakuOnly(String field, String fieldName, String errMsg,String value) {

		boolean zen_flg = true;
		
		if( value != null ){
						
		    int len = value.length();
		    
			  for(int i=0; i<len; i++) {
				  char chr = value.charAt(i);
				  UnicodeBlock ub = UnicodeBlock.of(chr);
	
				  //TODO 国際的にしないからいい？
	
				  if(ub == UnicodeBlock.BASIC_LATIN){
					zen_flg = false;			  
				  }
				  
				  //半角カナをエラーにする
				  if(ub == UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS) {
					if (chr >= 0xff61 && chr <= 0xff9f) {						
						zen_flg = false;			  
					}
	
				}
				
			  }
			
			if (!(zen_flg)) {
				errors.add(field, new ActionError(errMsg, getMessage(fieldName)));
				return false;
			}
		}
		
		return true;
	}
	
	/**
	 * 全角カナのみかチェックします。
	 * 
	 * @param field
	 * @param fieldName
	 * @param value
	 * @return true 全文字が全角カナの場合
	 */
	public boolean isZenkakuKanaOnly(String field, String fieldName, String errMsg,String value) {

		int kanaCnt = 0;
		if( value != null ){	
					
			int len = value.length();
		    
			  for(int i=0; i<len; i++) {
				  char chr = value.charAt(i);
				  UnicodeBlock ub = UnicodeBlock.of(chr);
		
				  if(ub == UnicodeBlock.KATAKANA){
					kanaCnt++;			  	
				  }
			  }
			
			if (len != kanaCnt) {
				errors.add(field, new ActionError(errMsg, getMessage(fieldName)));
				return false;
			}
			
		}
		
		return true;
	}

	/**
	 * 半角カナを含んでいるかチェックします。
	 * 
	 * @param field
	 * @param fieldName
	 * @param value
	 * @return true もし半角カナを含んでいない場合 false 含む場合
	 */
	public boolean isNotIncludingHankakuKana(String field, String fieldName, String errMsg,String value) {

		boolean kana_flg = false;			
		if( value != null ){
			
			int len = value.length();
		    
			  for(int i=0; i<len; i++) {
				  char chr = value.charAt(i);
				  UnicodeBlock ub = UnicodeBlock.of(chr);
	
				  //半角カナをエラーにする
				  if(ub == UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS) {
					if (chr >= 0xff61 && chr <= 0xff9f) {						
						kana_flg = true;			  
					}
	
				}
				
			  }
			
			if (kana_flg) {
				errors.add(field, new ActionError(errMsg, getMessage(fieldName)));
				return false;
			}
			
		}
		
		return true;
		
	}
	

	/**
	 * 空白も未入力として必須入力のみチェックします。
	 * 
	 * @param field
	 * @param fieldname
	 * @param errMsg
	 * @param value
	 * @return
	 */
	public boolean isRequired(String field, String fieldname, String errMsg,String value) {

		if (StringUtils.isEmpty(value)) {
			errors.add(field, new ActionError(errMsg, getMessage(fieldname)));
			return false;
		} else {
			return true;
		}
	}

	/**
	 * equalsレベルでの同値チェックを行います。
	 * 
	 * @param field
	 * @param fieldname
	 * @param value1
	 * @param value2
	 * @return
	 */
	public boolean notEqual(String field, String fieldname, String errMsg,String value1, String value2) {

		if( value1 != null ){
			if (!value1.equals(value2)) {
				errors.add(field, new ActionError(errMsg, getMessage(fieldname)));
				return false;
			}
		}
		return true;
	}

	/**
	 * 範囲チェック
	 * 
	 * @param field       フィールド名
	 * @param fieldname 
	 * @param errMsg  
	 * @param value       
	 * @param max         
	 * @param min 
	 */
	public boolean isRange(String field, String fieldname, String errMsg, String value, int min, int max) {
		
		if( value != null ){
			
			if (value.getBytes().length > max || value.getBytes().length < min) {
				errors.add(field,
					new ActionError(errMsg, getMessage(fieldname),  String.valueOf(min),String.valueOf(max)));
	
				return false;		
			}
			
		}
		return true;
	}
	
	/**
	 * MessageResourcesの取得
	 * 
	 * @param fieldname フィールド名
	 * @return MessageResources
	 */
	protected String getMessage(String fieldname) {
		if (locale == null) {
			return messageResources.getMessage(fieldname);
		} else {
			return messageResources.getMessage(locale, fieldname);
		}
	}

	/**
	 * 絶対値チェック
	 * 
	 * @param fiels
	 * @param fieldName
	 * @param errMsg
	 * @param str
	 * @param positive true マイナスを許さない場合セット
	 * @return
	 */
	public boolean isPositive (String fiels,String fieldName,String errMsg,String str,boolean required) {

		if ( required == false || str != null ){	
			try {	
				int i = Integer.parseInt(str);
				if( i < 0 ){
				  errors.add(
					  	fiels,new ActionError(errMsg,getMessage(fieldName)));
					  return false;	
				}
			} catch (NumberFormatException e) {	
			  errors.add(
			  	fiels,new ActionError(errMsg,getMessage(fieldName)));
			  return false;	
			}
		}	
	    return true;	
	}

	/**
	 * 数値大小判定（片方がnullの時はNo checkでtrueを返す)
	 * 
	 * @param field
	 * @param fieldname
	 * @param errMsg
	 * @param value1 比較元
	 * @param value2 比較先
	 * @return
	 */
	public boolean isGreaterThan(String field, String fieldname,String value1,String value2) {

		if ((!StringUtils.isEmpty(value1)) && (!StringUtils.isEmpty(value2))) {
			long l1 = Long.valueOf(value1).longValue();
			long l2 = Long.valueOf(value2).longValue();
			if (l1 > l2) {
				errors.add(field, new ActionError("errors.greaterthan", value2,value1));
				return false;
			}
		}

		return true;

	}

	/**
	 * 数値大小判定（片方がnullの時はNo checkでtrueを返す)
	 * 
	 * @param field
	 * @param fieldname
	 * @param errMsg
	 * @param value1 比較元
	 * @param value2 比較先
	 * @return
	 */
	public boolean isGreaterThan(String field, String fieldname,String errMsg,String value1,String value2) {

		if ((!StringUtils.isEmpty(value1)) && (!StringUtils.isEmpty(value2))) {
			long l1 = Long.valueOf(value1).longValue();
			long l2 = Long.valueOf(value2).longValue();
			if (l1 > l2) {
				errors.add(field, new ActionError(errMsg, getMessage(fieldname),value2,value1));
				return false;
			}
		}

		return true;

	}

	/**
	 * 入力した値の正規表現に合うかをチェックする.
	 * @param field
	 * @param fieldname
	 * @param errMsg
	 * @param value　比較値
	 * @param exp 正規表現
	 * @return boolean　
	 */
	
	public boolean matchRegexp( String field, String fieldName, String errMsg, String value, String exp){

		if ( !GenericValidator.matchRegexp(value, exp) ){
			errors.add(field, new ActionError(errMsg, getMessage(fieldName)));
			return false;
		}

		return true;
	}

	/**
	 * 入力した値の正規表現に合うかをチェックする.
	 * @param field
	 * @param fieldname
	 * @param errMsg
	 * @param value　比較値
	 * @param exp 正規表現
	 * @return boolean　
	 */
	
	public boolean notMatchRegexp( String field, String fieldName, String errMsg, String value, String exp){

		if ( GenericValidator.matchRegexp(value, exp) ){
			errors.add(field, new ActionError(errMsg, getMessage(fieldName)));
			return false;
		}

		return true;
	}

	/**
	 * 全角を含んでいるかチェックします。
	 * 
	 * @param field
	 * @param fieldName
	 * @param errMsg
	 * @param value
	 * @return true もし半角カナを含んでいない場合 false 含む場合
	 */
	public boolean isNotIncludingZenkaku(String field, String fieldName, String errMsg, String value) {

		boolean noZen_flg = true;
		int len = value.length();
	    
		  for(int i=0; i<len; i++) {
			  char chr = value.charAt(i);
			  UnicodeBlock ub = UnicodeBlock.of(chr);
	
			  //　Latin文字以外はエラーにする
			  if( ub != UnicodeBlock.BASIC_LATIN ) {
				noZen_flg = false;			  
			  }
		  }
		
		if ( noZen_flg == false ) {
			errors.add(field, new ActionError(errMsg, getMessage(fieldName)));
		}
		
		return noZen_flg;
		
	}

	/**
	 * "0"は入力不可
	 * 
	 * @param field
	 * @param fieldName
	 * @param errMsg
	 * @param value
	 * @return true "0"より大きい数ならOK
	 */
	public boolean notZero(String field, String fieldName, String errMsg, String value) {

		if (Integer.parseInt(value) <= 0){
			errors.add(field, new ActionError(errMsg, getMessage(fieldName)));
			return false;
		}
	
		return true;
		
	}
	
}
