package com.jware.base.service;

import java.beans.PropertyDescriptor;
import java.util.Iterator;
import java.util.Map;


import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.jware.base.error.JwareApplicationException;

/**
 * @author jrmt
 */
public class BaseParam {

    /**
     * Commons Logging instance.
     */
    protected Log log = LogFactory.getLog(this.getClass().getName());

	private boolean newFlg = true;
	
	/**
	 * ログオンユーザー情報を保持するプロパーティ 
	 */
	private int logonUserId;

	/**
	 * 
	 */
	public BaseParam() {
		super();
	}

	/**
	 * @return
	 */
	public int getLogonUserId() {
		return logonUserId;
	}

	/**
	 * @param i
	 */
	public void setLogonUserId(int i) {
		logonUserId = i;
	}



	public void copyPropertiesFrom( Object orig ) throws JwareApplicationException {

		try{
	
			if (orig == null) {
				throw new IllegalArgumentException("Method copyPropertiesFrom : No origin bean specified");
			}
	
			if (orig instanceof DynaBean) {
				DynaProperty origDescriptors[] =
					((DynaBean) orig).getDynaClass().getDynaProperties();
				for (int i = 0; i < origDescriptors.length; i++) {
					String name = origDescriptors[i].getName();
					if (PropertyUtils.isWriteable(this, name)) {
						Object value = ((DynaBean) orig).get(name);
						PropertyUtils.setSimpleProperty(this, name, value);
					}
				}
				
			} else if (orig instanceof Map) {
				
				Iterator names = ((Map) orig).keySet().iterator();
				while (names.hasNext()) {
					String name = (String) names.next();
					if (PropertyUtils.isWriteable(this, name)) {
						Object value = ((Map) orig).get(name);
						PropertyUtils.setSimpleProperty(this, name, value);
					}
				}
				
			} else {
				
				PropertyDescriptor origDescriptors[] =
					PropertyUtils.getPropertyDescriptors(orig);
				for (int i = 0; i < origDescriptors.length; i++) {
					String name = origDescriptors[i].getName();
					if (PropertyUtils.isReadable(orig, name)) {
						if (PropertyUtils.isWriteable(this, name)) {
							Object value = PropertyUtils.getSimpleProperty(orig, name);
							PropertyUtils.setSimpleProperty(this, name, value);
						}
					}
				}
				
			}

		} catch ( Exception e ){

			throw new JwareApplicationException("E999999", e);

		}

	}

	public void copyPropertiesTo( Object dest ) throws JwareApplicationException {

		try {
				
			if (dest == null) {
				throw new IllegalArgumentException("Method copyPropertiesTo : No dest bean specified");
			}
	
			PropertyDescriptor origDescriptors[] =
				PropertyUtils.getPropertyDescriptors(this);
			for (int i = 0; i < origDescriptors.length; i++) {
				String name = origDescriptors[i].getName();
				if (PropertyUtils.isReadable(this, name)) {
					if (dest instanceof DynaBean) {
						if (PropertyUtils.isWriteable(dest, name)) {
							Object value = PropertyUtils.getSimpleProperty(this, name);
							((DynaBean) dest).set(name, value);
						}
					} else /* if (dest is a standard JavaBean) */ {
						if (PropertyUtils.isWriteable(dest, name)) {
							Object value = PropertyUtils.getSimpleProperty(this, name);
							PropertyUtils.setSimpleProperty(dest, name, value);
						}
					}
				}
			}

		} catch ( Exception e ) {

			throw new JwareApplicationException("E999999", e);

		}
		
	}
	
	
	/**
	 * @return Returns the newFlg.
	 */
	public boolean isNewFlg() {
		return newFlg;
	}
	/**
	 * @param newFlg The newFlg to set.
	 */
	public void setNewFlg(boolean newFlg) {
		this.newFlg = newFlg;
	}
}
