package com.jware.util.mail;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/**
 * @author jrmt
 */
public class MailStatus  implements Serializable{

	private String mailHost = null;
	private String mailDomain = null;
	private HashMap statusMap = null;
	private boolean completeFlg = false;
	private Date startTime = null;
	private Date endTime = null;
	private boolean dirty = false;

	private int sendFailed = 0;
	private int retryCount = 0;
	
	private int maxSendable = -1;
	private int limitInterval = 0;
	private boolean abnormalFlg = false;
	
	public MailStatus() {
		super();
		statusMap = new HashMap();
	}

	/**
	 * @return Returns the completeFlg.
	 */
	public boolean isCompleteFlg() {
		return completeFlg;
	}
	/**
	 * @param completeFlg The completeFlg to set.
	 */
	public void setCompleteFlg(boolean completeFlg) {
		this.completeFlg = completeFlg;
	}
	/**
	 * @return Returns the mailHost.
	 */
	public String getMailHost() {
		return mailHost;
	}
	/**
	 * @param mailHost The mailHost to set.
	 */
	public void setMailHost(String mailHost) {
		this.mailHost = mailHost;
	}
	/**
	 * @return Returns the statusMap.
	 */
	public String getStatus(String address) {
		return (String)statusMap.get(address);
	}
	/**
	 * @param statusMap The statusMap to set.
	 */
	public void setStatus(String address, String status) {
		statusMap.put( address, status);
	}
	/**
	 * @return Returns the dirty.
	 */
	public boolean isDirty() {
		return dirty;
	}
	/**
	 * @param dirty The dirty to set.
	 */
	public void setDirty(boolean dirty) {
		this.dirty = dirty;
	}
	/**
	 * @return Returns the endTime.
	 */
	public Date getEndTime() {
		return endTime;
	}
	/**
	 * @param endTime The endTime to set.
	 */
	public void setEndTime(Date endTime) {
		this.endTime = endTime;
	}
	/**
	 * @return Returns the startTime.
	 */
	public Date getStartTime() {
		return startTime;
	}
	/**
	 * @param startTime The startTime to set.
	 */
	public void setStartTime(Date startTime) {
		this.startTime = startTime;
	}
	/**
	 * @return Returns the sendFailed.
	 */
	public int getSendFailed() {
		return sendFailed;
	}
	/**
	 * @param sendFailed The sendFailed to set.
	 */
	public void setSendFailed(int sendFailed) {
		this.sendFailed = sendFailed;
	}
	
	public List getFailedList( ) {
		List result = new LinkedList();
		
		Iterator addressIterator = statusMap.keySet().iterator();
		while( addressIterator.hasNext() ) {
            String address = (String)addressIterator.next();
            if( !"OK".equalsIgnoreCase( (String)statusMap.get(address)) ){
            	result.add(address);
            }
		}
        return result;
	}
	public List getSuccessList( ) {
		List result = new LinkedList();
		
		Iterator addressIterator = statusMap.keySet().iterator();
		while( addressIterator.hasNext() ) {
            String address = (String)addressIterator.next();
            if( "OK".equalsIgnoreCase( (String)statusMap.get(address)) ){
            	result.add(address);
            }
		}
        return result;
	}
	/**
	 * @return Returns the retryCount.
	 */
	public int getRetryCount() {
		return retryCount;
	}
	/**
	 * @param retryCount The retryCount to set.
	 */
	public void setRetryCount(int retryCount) {
		this.retryCount = retryCount;
	}
	/**
	 * @return Returns the mailDomain.
	 */
	public String getMailDomain() {
		return mailDomain;
	}
	/**
	 * @param mailDomain The mailDomain to set.
	 */
	public void setMailDomain(String mailDomain) {
		this.mailDomain = mailDomain;
	}
	/**
	 * @return Returns the limitInterval.
	 */
	public int getLimitInterval() {
		return limitInterval;
	}
	/**
	 * @param limitInterval The limitInterval to set.
	 */
	public void setLimitInterval(int limitInterval) {
		this.limitInterval = limitInterval;
	}
	/**
	 * @return Returns the maxSendable.
	 */
	public int getMaxSendable() {
		return maxSendable;
	}
	/**
	 * @param maxSendable The maxSendable to set.
	 */
	public void setMaxSendable(int maxSendable) {
		this.maxSendable = maxSendable;
	}
	/**
	 * @return Returns the abnormalFlg.
	 */
	public boolean isAbnormalFlg() {
		return abnormalFlg;
	}
	/**
	 * @param abnormalFlg The abnormalFlg to set.
	 */
	public void setAbnormalFlg(boolean abnormalFlg) {
		this.abnormalFlg = abnormalFlg;
	}
}
