/**
 * Copyright 2005 Darren L. Spurgeon
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.ajaxtags.demo.servlet;

import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.ArrayUtils;

/**
 * An example servlet that responds to an ajax:toggle tag action. This servlet
 * would be referenced by the baseUrl attribute of the JSP tag.
 * 
 * @author Darren L. Spurgeon
 * @version $Revision: 1.1 $ $Date: 2008/09/30 12:26:45 $
 */
public class ToggleServlet extends HttpServlet {

  private static final String onOffToggles[] = { "On", "on",
                                                 "Off", "off",
                                                 "True", "true",
                                                 "False", "false" };

  public void doGet(HttpServletRequest request, HttpServletResponse response)
      throws ServletException, IOException {

    String rating = request.getParameter("rating");
    if (rating != null && rating.length() > 0) {
      if (ArrayUtils.contains(onOffToggles, rating))
        request.getSession().setAttribute("toggleRatingOnOff", rating);
      else
        request.getSession().setAttribute("toggleRating", rating);
    } else {
      rating = "";
    }

    PrintWriter pw = response.getWriter();
    pw.write(rating);
    pw.close();
  }

  public void doPost(HttpServletRequest request, HttpServletResponse response)
      throws ServletException, IOException {
    doGet(request, response);
  }

}
