/****************************************************************************
 * Compiere (c) Jorg Janke - All rights reseverd
 * $Id: window.js,v 1.13 2009/04/02 06:58:47 clmg Exp $
 *
 * Web UI Window Utilities
 ***************************************************************************/

/****************************************************************************
 *	Text constants
 */
var deleteText = "ConfirmDelete";

var childWndCount = 0;
var childWndArray = new Array();
var isCallingOut = false;
var saveErrorText = "Could not save changes, save again.";

/****************************************************************************
 *	Field Update
 ***************************************************************************/
function fieldUpdate(e)
{
	if (!top.WCmd)	//	no cmd frame
		return;

	if (!e) e = window.event;
	//	alert('FieldUpdate ' + e.name + '=' + e.value);

	//	update info and submit
	top.WCmd.document.fieldUpdate.formName.value = e.form.name; //e.document.forms[0].name;
	top.WCmd.document.fieldUpdate.fieldName.value = e.name;
	top.WCmd.document.fieldUpdate.fieldValue.value = e.value;
	top.WCmd.document.fieldUpdate.submit();
}	//	fieldUpdate

/**
 *	Create Initial Command Window
 */
function createWCmd()
{
	if (!top.WCmd)	//	no cmd frame
		return;
	// write to the command window.
	var d = top.WCmd.document;
	d.open();
	d.writeln('<form name="fieldUpdate" method="post" action="/compiere/ampiere/WFieldUpdate">');
	d.writeln('<input type="hidden" name="formName" value="x">');
	d.writeln('<input type="hidden" name="fieldName" value="x">');
	d.writeln('<input type="hidden" name="fieldValue" value="x">');
	d.writeln('</form>');
	d.close();
}	//	createWCmd
//	Execute it
createWCmd();


/****************************************************************************
 *	Dynamic Display
 *	- for form: WForm
 *	- changing field should have onChange="dynDisplay" to trigger evaluation
 *	- changed field should have document.WForm.field.displayLogic='expression'	
 */
function dynDisplay()
{
	var el = document.WForm.elements;
	var info = "dynDisplay:";
	//	for all fields
	for (var i = 0; i < el.length; i++)
	{
		//	do we have displayLogic ?
		var dLogic = el[i].displayLogic;		
		if (typeof dLogic == "string" && dLogic.length > 0)
		{
			fieldName = el[i].name;
			if (evaluate(dLogic))
			{
				show(fieldName+"L");
				show(fieldName+"F");
				show(fieldName+"B");
				info += " show:" + fieldName;
			}
			else
			{
				hide(fieldName+"L");
				hide(fieldName+"F");
				hide(fieldName+"B");
				info += " hide:" + fieldName;
			}
		}	//	we have displayLogic
	}	//	for all fields
	window.status = info;
}	//	dynDisplay

/**
 *	Evaluate Display Logic
 *	>> |& <<
 */
function evaluate (dLogic)
{
	var pos1 = dLogic.indexOf('&');
	var pos2 = dLogic.indexOf('|');

	//	only a tuple	
	if (pos1 == pos2)
	{
		return evaluateTuple(dLogic);
	}

	//	and: &
	else if (pos1 > pos2)
	{
		tuples = dLogic.split('&');
		return evaluateTuple(tuples[0]) && evaluate(dLogic.substring(pos1+1));
	}

	//	or: |
	else
	{
		tuples = dLogic.split('|');
		return evaluateTuple(tuples[0]) || evaluate(dLogic.substring(pos2+1));
	}
}	//	evaluate

/**
 *	evaluate tuple 'x = y' or x ^ y or x ! y
 *	>> =!^ <<
 */
function evaluateTuple(myValue)
{
	//	Equals
	var tuples = myValue.split('=');
	if (tuples.length == 2)
		return getRealValue(tuples[0]) == getRealValue(tuples[1]);
	//	Not Equals
	tuples = myValue.split('^');
	if (tuples.length == 2)
		return getRealValue(tuples[0]) != getRealValue(tuples[1]);
	tuples = myValue.split('!');
	if (tuples.length == 2)
		return getRealValue(tuples[0]) != getRealValue(tuples[1]);
	//
	alert ('Error: evaluateTuple="' + myValue + '" invalid.');
	return false;
}	//	evaluateTuple

/**
 *	get (variable) value
 */
function getRealValue (myValue)
{
	var pos1 = myValue.indexOf('@');
	var pos2 = myValue.indexOf('@', pos1+1);

	//	Constant - remove blanks an '"
	if (pos1 == pos2)
		return myValue.replace(/['" ]/g, "");
	
	//	Variable
	var variable = myValue.substring(pos1+1, pos2);
	for (var i = 0; i < document.WForm.elements.length; i++)
	{
		if (document.WForm.elements[i].name == variable)
			return document.WForm.elements[i].value;
	}
	//	Nothing found
	return "";
}	//	getRealValue


/****************************************************************************
 *  Open PopUp with Attachment Info
 */
function startPopup (targetCmd)
{
//    parent.document.getElementById("framesetWindow").rows="300,*";
//    parent.WPopUp.location = '/compiere/ampiere/' + targetCmd;
//    return false;   //  do not submit page

	if (targetCmd == null || targetCmd == "") {
		return;
	}

	var w = 700; //clmg 2009/03/11
	var h = 400;
	var url = ("/compiere/ampiere/" + targetCmd);
	url = encodeURI(url);
	var title = targetCmd;
	if (targetCmd.indexOf("?") >= 0) {
		title = targetCmd.substring(0, targetCmd.indexOf("?") - 1);
	}
	var childWnd = openPopup(url, "StartPopup_" + title, w, h, 0);
	childWndArray[childWndCount++] = childWnd;
}   //  startPopup

/**
 *  Close PopUp
 */
function closePopup ()
{
//    parent.document.getElementById("framesetWindow").rows="0,*";
	window.close();
    return true;   //  do submit page
}   //  closePopUp

/**
 *	Lookup - get FormName and ColumnName and submit to WLookup
 */
function startLookup(columnName, windowNo, AD_Column_ID, lookupColName, viewOnly, value)
{
	if (columnName == null || columnName == "") {
		return;
	}

	var dst_obj = document.getElementById(columnName + "F");
	if(dst_obj.disabled == true){
		return;
	}
	
    var name = "";
    if (value == null) {
	    var obj = document.getElementById(columnName + "F");
	    if (obj != null) {
	        name = obj.value;
	    }
	} else {
		name = value;
	}

	var w = 1000;
	var h = 640;
    var url = "/compiere/ampiere/";
	if (lookupColName == "C_BPartner_ID") {
    	url += "InfoBPartnerAction";
    } else if (lookupColName == "M_Product_ID") {
		url += "InfoProductAction";
	} else {
		url += "InfoLookupAction";
	}

	url += (".do?columnName=" + columnName + "&windowNo=" + windowNo + "&name=" + name + "&column_ID=" + AD_Column_ID + "&viewOnly=" + viewOnly);
	url = encodeURI(url);
	var childWnd = openPopup(url, "InfoLookup_" + columnName, w, h, 0);
	childWndArray[childWndCount++] = childWnd;
}	//	startLookup

/**
 *	Location - get FormName and ColumnName and submit to WLocation
 */
function startLocation(columnName, windowNo, AD_Column_ID, lookupColName, value)
{
	if (columnName == null || columnName == "") {
		return;
	}

    var name = "";
    if (value == null) {
	    var obj = document.getElementById(columnName + "F");
	    if (obj != null) {
	        name = obj.value;
	    }
	} else {
		name = value;
	}

	var w = 410;
	var h = 428;
	var url = "/compiere/ampiere/LocationAction.do?columnName=" + columnName + "&windowNo=" + windowNo + "&column_ID=" + AD_Column_ID;
	var childWnd = openPopup(url, "Location", w, h, 0);
	childWndArray[childWndCount++] = childWnd;
}	//	startLocation

/**
 *	Account - get FormName and ColumnName and submit to WAccount
 */
function startAccount (columnName, value)
{
	if (columnName == null || columnName == "") {
		return;
	}

	var w = 600;
	var h = 640;

	var url = "WAccount?columnName=" + columnName + "&formName=WForm";
	url = encodeURI(url);
	var childWnd = openPopup(url, "StartAccount_" + columnName, w, h, 0);
	childWndArray[childWndCount++] = childWnd;
}	//	startAccount

/****************************************************************************
 *	Field Updated - submit
 */
function startUpdate (column)
{
	isCallingOut = true;
	if (column != null) {
		if(column.form.ChangedColumn){
			column.form.ChangedColumn.value=column.name;
//			column.form.submit();
			makeRequest(column,1);
		}
	}
	//alert(document.getElementById(column.name+'F').value);
	
//    if (column != null) {
//        if (column.form.ChangedColumn) {
//    	    column.form.ChangedColumn.value=column.name;
//            column.form.submit();
//    	} else {
//    	}
//    }
}	//	startUpdate

function startUpdate (column, ajaxFlag)
{
	
	isCallingOut = true;
	if (column != null) {
		if(column.form.ChangedColumn){
			column.form.ChangedColumn.value=column.name;
			if(ajaxFlag==false){
				column.form.submit();
			}else{
				makeRequest(column,1);
			}
		}
	}
}	//	startUpdate

function set_value ( obj_id, value ) {
	if(value!=null && value!=""){
  		var des = document.getElementById(obj_id);
 		des.value = value;
	 } 
}

function set_null ( obj_id ) {
  	var des = document.getElementById(obj_id);
 	des.value = '';
}

function set_visibility ( obj_id, value ) {
	if(value!=null && value!="" && obj_id!=null && obj_id!=""){
  		var des = document.getElementById(obj_id);
 		 des.style.visibility = value;
	 } 
}

function replaceAll( _targetStr_, _searchStr_, _replaceStr_ ){ 

    return _targetStr_.split(_searchStr_).join(_replaceStr_);

}

function setDataXML(req)
{
	//alert('before='+document.getElementById('IsOnlineF').value);
	var elements = req.responseXML.getElementsByTagName('element');
	var elm_id;
	var elm_lookup;
	var elm_visibility;
	var elm_newValue;
	var elm_newValue_obj;
	for (var i=0;i<elements.length;i++)
	{
		elm_id = getNodeValue(elements[i],'id');
		elm_lookup = getNodeValue(elements[i],'lookup');
		// visibility must be '' or 'none'
		elm_visibility = getNodeValue(elements[i],'visibility');
		elm_newValue = getNodeValue(elements[i],'newValue');
		elm_type = getNodeValue(elements[i],'type');
		elm_readonly = getNodeValue(elements[i],'readonly');
		
		var element = document.getElementById(elm_id);
		if(element!=null){
			//show or hide
			if(elm_lookup=='0'){
				if(elm_visibility=='1'){
					element.style.display = '';
				}else{
					element.style.display = 'none';
				}
				//new value
				if(elm_type==1){				
					element.value = elm_newValue;	
				}	
				if(elm_readonly==1){
					element.readOnly = true;
					element.disabled = true;
				}else{
					element.readOnly = false;
					element.disabled = false;
					if(element.className=='imgButtonD'){
						element.className = '';
					}
				}
			}else{
				removeAllOptions(elm_id);
				elm_newValue_obj = getNodeObj(elements[i],'newValue');
				appendAllOptions(elm_id, elm_newValue_obj);
			}
		}
	}
}

function executeScript(req)
{
	var elements = req.responseXML.getElementsByTagName('script');
	var elm_script;
	for (var i=0;i<elements.length;i++)
	{
		elm_script = getNodeValue(elements[i],'item');		
		eval(elm_script);
	}
	//alert('after='+document.getElementById('IsOnlineF').value);
}

function getNodeObj(obj,tag)
{
	if(obj.getElementsByTagName(tag)[0]!=null){
		return obj.getElementsByTagName(tag)[0];
	}else{
		return '';
	}
}

function getNodeValue(obj,tag)
{
	if(obj.getElementsByTagName(tag)[0].firstChild!=null){
		return obj.getElementsByTagName(tag)[0].firstChild.nodeValue;
	}else{
		return '';
	}
}
//remove select option
function removeAllOptions(obj_id)
{
	var selectElement = document.getElementById(obj_id);
	for(i=selectElement.options.length-1;i>=0;i--)
	{
		selectElement.remove(i);
	}
}
//add select option
function appendAllOptions(obj_id, elm_newValue)
{
	var elements = elm_newValue.getElementsByTagName('item');
	var text;
	var value;
	for (var i=0;i<elements.length;i++)
	{
		key = getNodeValue(elements[i],'key');
		value = getNodeValue(elements[i],'value');
		addOption(obj_id,value,key);
	}
}
function addOption(obj_id,text,value )
{
	var selectElement = document.getElementById(obj_id);
	selectElement.options[selectElement.length] = new Option(text, value);
	
	//var optn = document.createElement("OPTION");
	//selectElement.text = text;
	//selectElement.value = value;
	//selectElement.options.add(optn);

		
}
/****************************************************************************
 *	ajax request - submit 
 *  modi by clmg
 */
function makeRequest(column, actionType){
    var d = document;
    //var div = d.getElementById('dd-frame');
    var handleSuccess = function(o){
            if (o.status !== 200) {
            	alert('o.status !== 200');
        		isCallingOut = false;
                return;
            }              
            
            if(o.responseText !== undefined){
            	//reset the 
//            	set_null('ChangedColumn');
//            	
//                var tmp = decodeURIComponent(o.responseText,'UTF-8');
//                tmp = replaceAll(tmp ,"+"," ")
//                var resp_array = tmp.split("**");
//                
//                var element = document.getElementById(resp_array[0]);
//                element.style.display = '';
//            	set_value(resp_array[0], resp_array[1]);
                //set_visibility(resp_array[14], 'visible');
                //set_visibility('WriteOffAmtF', 'hidden');
            }
            
            if(o.responseXML !== undefined){
            	//reset the 
            	set_null('ChangedColumn');            	
            	setDataXML(o);
            	executeScript(o);
            	isCallingOut = false;
            }
    };
    var handleFailure = function(o){
    		isCallingOut = false;
            if(o.responseText !== undefined){
            	 ;
            }
    };

    var callback = {
     success: handleSuccess,
     failure: handleFailure
    };
	
	var apiUrl = "/compiere/ampiere/WWindow";
    var d = document;
    var formObject = column.form;
    YAHOO.util.Connect.setForm(formObject); 
    //YAHOO.util.Connect.setDefaultPostHeader( false );
    YAHOO.util.Connect.initHeader( "Content-Type","application/x-www-form-urlencoded;charset=UTF-8", false );
    var requestUrl = apiUrl + "?actionType=" + actionType;
    var request = YAHOO.util.Connect.asyncRequest('POST', requestUrl, callback);
}




/****************************************************************************
 *	Process Button
 */
function processButton(column, reserve1, reserve2, reserve3)
{
    if (column != null && column.form.ChangedColumn) {
		column.form.PCommand.value = "ButtonCommand";
		column.form.ChangedColumn.value = column.name;
		column.form.Reserve1.value = reserve1;
		column.form.Reserve2.value = reserve2;
		column.form.Reserve3.value = reserve3;
	    column.form.submit();
    }
}	//	processButton

/****************************************************************************
 *	popup process select window
 */
function startButton(columnName, windowNo, processId, AD_Table_ID, recordId) {
	if (columnName == null || columnName == "") {
		return;
	}

	var w = 410;
	var h = 320;
	var url = "";
	var titleAppendix = "";
	if (columnName == "PaymentRule" || columnName == "DocAction" || columnName == "Posted") {
		if (columnName == "Posted") {
			w = 800;
			h = 600;
		}
		url = ("/compiere/ampiere/ButtonAction.do?columnName=" + columnName + "&windowNo=" + windowNo + "&processId=" + processId);
	} else if (columnName == "CreateFrom" && (AD_Table_ID == 392 || AD_Table_ID == 318 || AD_Table_ID == 319)) {
		w = 800;
		h = 600;
		if (AD_Table_ID == 392) {
			// C_BankStatement
			url = ("/compiere/ampiere/CreateFromStatementAction.do?columnName=" + columnName + "&windowNo=" + windowNo + "&processId=" + processId + "&bpartnerID=0");
		} else if (AD_Table_ID == 318) {
			// C_Invoice
			url = ("/compiere/ampiere/CreateFromInvoiceAction.do?columnName=" + columnName + "&windowNo=" + windowNo + "&processId=" + processId + "&bpartnerID=0");
		} else {
			// M_InOut
			url = ("/compiere/ampiere/CreateFromShipmentAction.do?columnName=" + columnName + "&windowNo=" + windowNo + "&processId=" + processId + "&bpartnerID=0");
		}
		titleAppendix += AD_Table_ID;
	} else {
		w = 450;
		h = 380;
		url = ("/compiere/ampiere/WProcessDialog?columnName=" + columnName + "&windowNo=" + windowNo + "&processId=" + processId + "&recordId=" + recordId);
	}

	url = encodeURI(url);
	var childWnd = openPopup(url, "StartButtn_" + columnName + titleAppendix, w, h, 0);
	childWndArray[childWndCount++] = childWnd;
}	// startButton

/****************************************************************************
 *
 */
function tabMouseOver(left, right) {
    var objLeft = document.getElementById(left);
    if (objLeft != null) {
        //objLeft.style.background="url('images/tabLeftBottom.gif') no-repeat left top";
		objLeft.style.background="url('images/main/tab_left.gif') no-repeat 0px -32px";
    }

    var objRight = document.getElementById(right);
    if (objRight != null) {
        //objRight.style.color="#FF9933";
		//objLeft.style.background="url('images/tabRightBottom.gif') no-repeat right top";
		objRight.style.color="#555";
        objRight.style.background="url('images/main/tab_right.gif') no-repeat right -32px";
    }
}

/****************************************************************************
 *
 */
function tabMouseOut(left, right) {
    var objLeft = document.getElementById(left);
    if (objLeft != null) {
        //objLeft.style.background="url('images/tabLeftTop.gif') no-repeat left top";
		objLeft.style.background="url('images/main/tab_left.gif') no-repeat 0px 0px";
    }

    var objRight = document.getElementById(right);
    if (objRight != null) {
        //objRight.style.color="#F4F7DA";
        //objRight.style.background="url('images/tabRightTop.gif') no-repeat right top";
		objRight.style.color="#555";
        objRight.style.background="url('images/main/tab_right.gif') no-repeat right top";
    }
}

/****************************************************************************
*
*/
function btnMouseOver(btn) {
   var objBtn = document.getElementById(btn);
   if (objBtn != null) {
       //objBtn.style.border="2px inset #000";
		objBtn.style.border="1px solid #90c3ec";
   }
}

/****************************************************************************
*
*/
function btnMouseOut(btn) {
   var objBtn = document.getElementById(btn);
   if (objBtn != null) {
       //objBtn.style.border="2px outset #AAA";
		objBtn.style.border="1px solid #e5e5e5";
   }
}

/****************************************************************************
 * Switch menu on/off
 */
function menuSwitch() {
    var obj = parent.WMenu.document.getElementById("MenuOnOff");
    if (obj == null) {
        return;
    }
    if (obj.value == "MenuOn") {
    	obj.value = "MenuOff";
        parent.document.getElementById("framesetMenuWindow").cols="0,*";
    } else {
    	obj.value = "MenuOn";
        parent.document.getElementById("framesetMenuWindow").cols="220,*";
    }
/*
    var obj = document.getElementById("MenuOnOff");
    if (obj.name == "HideMenu") {
        obj.src = "images/ShowMenu24.gif";
        obj.name = "ShowMenu";
        obj.title = titleShow;
        parent.document.getElementById("framesetMenuWindow").cols="0,*";
    } else {
        obj.src = "images/HideMenu24.gif";
        obj.name = "HideMenu";
        obj.title = titleHide;
        parent.document.getElementById("framesetMenuWindow").cols="220,*";
    }
*/
}

/**
 * Show popup window
 */
function openPopup(url, title, width, height, modalDialog) {
	width = getValidWidth(width);
	height = getValidWidth(height);
    if (modalDialog == 1 && window.showModalDialog) {	// Modal dialog (IE only)
        window.showModalDialog(url, title, 'dialogWidth:' + width + 'px;dialogHeight:' + height + 'px');
    } else {
	    var paras = 'width=' + width + ',height=' + height + ',left='+ screen.width + 100 + ',top=' + screen.width + 100;
    	paras += ',scrollbars=yes,status=yes,modal=yes';
    	var x = 0;
    	var y = 0;
    	if (width > 0 && height > 0) {
	    	x = (screen.availWidth - width) / 2;
	    	y = (screen.availHeight - height) / 2;
	    } else {
	    	width = screen.availWidth;
	    	height = screen.availHeight;
	    }
        var popupWnd = window.open(url, title, paras, 'false');
        popupWnd.moveTo(x, y);
        popupWnd.resizeTo(width, height);
        popupWnd.focus();
        return popupWnd;
    }
}

/**
 * Open Report Window
 */
function openReportWindow(url, title) {
	var width = 400;
	var height = 300;
	var left = (screen.availWidth - width) / 2;
	var top = (screen.availHeight - height) / 2;
	var parameter  = "channelmode = no,";
	    parameter += "directories = no,";
	    parameter += "fullscreen = no,";
	    parameter += "height = " + height + ",";
	    parameter += "left = " + left + ",";
	    parameter += "location = no,";
	    parameter += "menubar = no,";
	    parameter += "resizable = no,";
	    parameter += "scrollbars = no,";
	    parameter += "status = no,";
	    parameter += "titlebar = no,";
	    parameter += "toolbar = no,";
	    parameter += "top = " + top + ",";
	    parameter += "width = " + width + ",";
    	parameter += "modal=yes";

    var printWindow = window.open( url, title, parameter );
	childWndArray[childWndCount++] = printWindow;
    printWindow.focus();
}

/**
 * Open Print Window
 */
function openPrintWindow(url, title) {
	var parameter  = "channelmode = no,";
	    parameter += "directories = no,";
	    parameter += "fullscreen = no,";
	    parameter += "height = 600,";
	    parameter += "left = 0,";
	    parameter += "location = no,";
	    parameter += "menubar = no,";
	    parameter += "resizable = yes,";
	    parameter += "scrollbars = yes,";
	    parameter += "status = no,";
	    parameter += "titlebar = yes,";
	    parameter += "toolbar = no,";
	    parameter += "top = 0,";
	    parameter += "width = 800,";
    	parameter += "modal=yes";

    var printWindow = window.open( url, title, parameter );
	childWndArray[childWndCount++] = printWindow;
    printWindow.moveTo( 0, 0 );
    printWindow.resizeTo( screen.width, screen.height );
    printWindow.focus();
}

/**
 * Open Find Window
 */
function openFindWindow(url, title) {
	var parameter = "";
	var width = "700";
	var height = "400";
	x = (screen.availWidth - width) / 2;
	y = (screen.availHeight - height) / 2;
	var findWindow = 0;
	parameter += "channelmode = no,";
    parameter += "directories = no,";
    parameter += "fullscreen = no,";
    parameter += "height = " + height + ",";
    parameter += "left = " + x + ",";
    parameter += "location = no,";
    parameter += "menubar = no,";
    parameter += "resizable = no,";
    parameter += "scrollbars = no,";
    parameter += "status = no,";
    parameter += "titlebar = no,";
    parameter += "toolbar = no,";
    parameter += "top = " + y + ",";
    parameter += "width = " + width + ",";
	parameter += "modal=yes";

    findWindow = window.open( url, title, parameter );
	childWndArray[childWndCount++] = findWindow;
	findWindow.focus();
}

/**
 * Open History Window
 */
function openHistoryWindow(url, title) {
	var parameter = "";
	var width = "300";
	var height = "150";
	x = (screen.availWidth - width) / 2;
	y = (screen.availHeight - height) / 2;
	var findWindow = 0;
	parameter += "channelmode = no,";
    parameter += "directories = no,";
    parameter += "fullscreen = no,";
    parameter += "height = " + height + ",";
    parameter += "left = " + x + ",";
    parameter += "location = no,";
    parameter += "menubar = no,";
    parameter += "resizable = no,";
    parameter += "scrollbars = no,";
    parameter += "status = no,";
    parameter += "titlebar = no,";
    parameter += "toolbar = no,";
    parameter += "top = " + y + ",";
    parameter += "width = " + width + ",";
	parameter += "modal=yes";

    findWindow = window.open( url, title, parameter );
	childWndArray[childWndCount++] = findWindow;
	findWindow.focus();
}

/**
 * Check parent window status
 */
function checkParent(w) {
    if (! w.opener || w.opener.closed) {  // Check if parent window exists
        alert("Not found the parent window!");
        return false;
    }

    return true;
}

/**
 * Update informations(do callout)
 */
function updateInfo(columnName) {
	if (! checkParent(window)) {
        window.close();
		return;
	}

    var radioObjects = window.document.getElementsByName("radioSelect");
    var targetObj = null;
    var updateObj = null;
    var onChangeObj = null;
    if (window.opener.top.WWindow) {
    	targetObj = (window.opener.top.WWindow.document.getElementById(columnName + "D"));
    	updateObj = (window.opener.top.WWindow.document.getElementById(columnName + "F"));
		onChangeObj = new getLocalObj(window.opener.top.WWindow.document, columnName + "D");
    } else {
	    targetObj = (window.opener.top.document.getElementById(columnName + "D"));
	    updateObj = (window.opener.top.document.getElementById(columnName + "F"));
		onChangeObj = new getLocalObj(window.opener.top.document, columnName + "D");
    }
    if (radioObjects != null && targetObj != null && updateObj != null) {
        for (var i = 0; i < radioObjects.length; i++) {
            if (radioObjects[i] != null && radioObjects[i].checked) {
                var s = radioObjects[i].value.split("________");
                if (s != null && s.length == 2) {
                    targetObj.value = s[0];
                    updateObj.value = s[1];

                    // Call onchange event
                    if (onChangeObj != null && onChangeObj.obj.onchange) {
                    	onChangeObj.obj.onchange();
                    }

                    if(updateObj.onchange){
                    	updateObj.onchange();
                    }
                    
                    //startUpdate(updateObj);
                    //startUpdate(updateObj,false);
                }
                window.close();
                window.opener.focus();
                return;
            }
        }
    }

    window.close();
	window.opener.focus();
}	//	updateInfo

/**
 * Extend document.getElementById
 */
function getLocalObj(baseDoc, name) {
	if (document.getElementById) {
		this.obj = baseDoc.getElementById(name);
	} else if (document.all) {
		this.obj = baseDoc.all[name];
	}
} 

/**
 * Get valid width from specified width
 * if width is larger than avaliale screen width, return avaliale screen width
 */
function getValidWidth(width) {
	if (width > screen.availWidth) {
		screen.availWidth;
	} else {
		return width;
	}
}

/**
 * Get valid height from specified height
 * if height is larger than avaliale screen height, return avaliale screen height
 */
function getValidHeight(height) {
	if (height > screen.availHeight) {
		screen.availHeight;
	} else {
		return height;
	}
}

/**
 * Close all sub windows included in childWndArray
 */
function closeMyChildren() {
	if (childWndArray != null && childWndArray.length > 0) {
		for (var i = 0; i < childWndArray.length; i++) {
			childWndArray[i].close();
		}
	}
}

/**
 * Cannot save the data exactly during callout operation, popup warning message
 */
function beforeSave(formName) {
	if (isCallingOut) {
		alert(saveErrorText);
	} else {
		formName.submit();
	}
}
/****************************************************************************
 *	Before Change Tab - Save or Discard
 */
function beforeChangeTab (tabNum)
{
	var changedColumn_obj = document.getElementById('ChangedColumn');
	if(getChangeFlag()=='1'){
		var answer=window.confirm('変更を保存しますか？');
		if (answer){
			document.WForm.PCommand.value = 'Save';
			document.WForm.submit();
			//setTimeout('checkSaveError('+tabNum+');', 10000);			
			//setTimeout("checkSaveError();", 1000);	
			checkSaveError(tabNum);
		}	
		else{
			document.WForm.PTab.value=tabNum;
			document.WForm.submit();
		}
	}else{
		document.WForm.PTab.value=tabNum;
		document.WForm.submit();
	}
}	//	beforeChangeTab

/****************************************************************************
 *	ajax request - check save Error 
 *  modi by clmg
 */
function checkSaveError(tabNum){
    var d = document;
    actionType = '2'; // check Save Error action
    //var div = d.getElementById('dd-frame');
    var handleSuccess = function(o){
            if (o.status !== 200) {
            	alert('o.status !== 200');
                return;
            }              
            
            if(o.responseText !== undefined){
            	//reset the 
            	if(o.responseText=='0'){
        			document.WForm.PTab.value=tabNum;
        			document.WForm.action='/compiere/ampiere/WWindow?PTab='+tabNum;
        			document.WForm.submit();
            	}else{
            		
            	}
            }            
            if(o.responseXML !== undefined){
            	//reset the             
            }
    };
    var handleFailure = function(o){
            if(o.responseText !== undefined){
            	 ;
            }
    };

    var callback = {
     success: handleSuccess,
     failure: handleFailure
    };
	
	var apiUrl = "/compiere/ampiere/WWindow";
    YAHOO.util.Connect.initHeader( "Content-Type","application/x-www-form-urlencoded;charset=UTF-8", false );
    var requestUrl = apiUrl + "?actionType=" + actionType;
    var request = YAHOO.util.Connect.asyncRequest('POST', requestUrl, callback);
}

function setChangeFlag ( ) {
  	var des = document.getElementById('ChangeFlag');
  	if(des!=null){
  		des.value = '1';
  	} 	
}

function getChangeFlag ( ) {
  	var des = document.getElementById('ChangeFlag');
  	if(des!=null){
  		return des.value;
  	}else{
  		return '0';
  	}
 	
}