CREATE OR REPLACE VIEW M_INVENTORYLINE_V
AS 
select i.AD_Client_ID AS AD_Client_ID, i.AD_Org_ID AS AD_Org_ID, i.IsActive AS IsActive,
    i.Created AS Created, i.CreatedBy AS CreatedBy, i.Updated AS Updated, i.UpdatedBy AS UpdatedBy,
    CAST('en_US' AS VARCHAR(5)) AS AD_Language,
	i.C_Charge_ID, 
	i.Description, i.InventoryType, i.IsInternalUse, i.Line, 
	i.M_InventoryLine_ID, i.M_Inventory_ID, 
	i.M_Locator_ID, l.M_Warehouse_ID, 
	i.M_Product_ID, p.Value, 
	i.M_AttributeSetInstance_ID, 
	i.QtyBook, i.QtyCount, i.QtyInternalUse
from M_InventoryLine i
    INNER JOIN M_Product p on (i.M_Product_ID = p.M_Product_ID)
	INNER JOIN M_Locator l on (i.M_Locator_ID=l.M_Locator_ID)
    INNER JOIN M_Warehouse w on (l.M_Warehouse_ID=w.M_Warehouse_ID)
/
