/******************************************************************************
 * Product: Compiere ERP & CRM Smart Business Solution                        *
 * Copyright (C) 1999-2007 ComPiere, Inc. All Rights Reserved.                *
 * This program is free software, you can redistribute it and/or modify it    *
 * under the terms version 2 of the GNU General Public License as published   *
 * by the Free Software Foundation. This program is distributed in the hope   *
 * that it will be useful, but WITHOUT ANY WARRANTY, without even the implied *
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.           *
 * See the GNU General Public License for more details.                       *
 * You should have received a copy of the GNU General Public License along    *
 * with this program, if not, write to the Free Software Foundation, Inc.,    *
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.                     *
 * For the text or an alternative of this public license, you may reach us    *
 * ComPiere, Inc., 3600 Bridge Parkway #102, Redwood City, CA 94065, USA      *
 * or via info@compiere.org or http://www.compiere.org/license.html           *
 *****************************************************************************/
package compiere.model;

/** Generated Model - DO NOT CHANGE */
import org.compiere.model.*;
import java.sql.*;
import java.math.*;
import org.compiere.framework.*;
import org.compiere.util.*;
/** Generated Model for I_PrintFormatItem
 *  @author Jorg Janke (generated) 
 *  @version Release 3.0.0 - $Id: X_I_PrintFormatItem.java,v 1.1.4.1 2009/03/30 11:56:24 jrmt Exp $ */
public class X_I_PrintFormatItem extends PO
{
/** Standard Constructor
@param ctx context
@param I_PrintFormatItem_ID id
@param trxName transaction
*/
public X_I_PrintFormatItem (Ctx ctx, int I_PrintFormatItem_ID, String trxName)
{
super (ctx, I_PrintFormatItem_ID, trxName);
/** if (I_PrintFormatItem_ID == 0)
{
setI_IsImported (false);
setI_PrintFormatItem_ID (0);
setImageIsAttached (false);
setIsAveraged (false);
setIsCentrallyMaintained (false);
setIsCounted (false);
setIsDeviationCalc (false);
setIsFilledRectangle (false);
setIsFixedWidth (false);
setIsForm (false);
setIsGroupBy (false);
setIsHeightOneLine (false);
setIsImageField (false);
setIsMaxCalc (false);
setIsMinCalc (false);
setIsNextLine (false);
setIsNextPage (false);
setIsOrderBy (false);
setIsPageBreak (false);
setIsPrinted (false);
setIsRelativePosition (false);
setIsRunningTotal (false);
setIsSetNLPosition (false);
setIsStandardHeaderFooter (false);
setIsSummarized (false);
setIsSuppressNull (false);
setIsTableBased (false);
setIsVarianceCalc (false);
}
 */
}
/** Load Constructor 
@param ctx context
@param rs result set 
@param trxName transaction
*/
public X_I_PrintFormatItem (Ctx ctx, ResultSet rs, String trxName)
{
super (ctx, rs, trxName);
}
/** Serial Version No */
static final long serialVersionUID = 27485095769789L;
/** Last Updated Timestamp 2008-02-14 15:27:33.0 */
public static final long updatedMS = 1202970453000L;
/** AD_Table_ID=1000008 */
public static final int Table_ID=1000008;

/** TableName=I_PrintFormatItem */
public static final String Table_Name="I_PrintFormatItem";

protected static KeyNamePair Model = new KeyNamePair(1000008,"I_PrintFormatItem");

protected BigDecimal accessLevel = new BigDecimal(6);
/** AccessLevel
@return 6 - System - Client 
*/
protected int get_AccessLevel()
{
return accessLevel.intValue();
}
/** Load Meta Data
@param ctx context
@return PO Info
*/
protected POInfo initPO (Ctx ctx)
{
POInfo poi = POInfo.getPOInfo (ctx, Table_ID);
return poi;
}
/** Info
@return info
*/
public String toString()
{
StringBuffer sb = new StringBuffer ("X_I_PrintFormatItem[").append(get_ID()).append("]");
return sb.toString();
}
/** Set Column.
@param AD_Column_ID Column in the table */
public void setAD_Column_ID (int AD_Column_ID)
{
if (AD_Column_ID <= 0) set_Value ("AD_Column_ID", null);
else
set_Value ("AD_Column_ID", new Integer(AD_Column_ID));
}
/** Get Column.
@return Column in the table */
public int getAD_Column_ID() 
{
Integer ii = (Integer)get_Value("AD_Column_ID");
if (ii == null) return 0;
return ii.intValue();
}

/** AD_ItemColor_ID AD_Reference_ID=266 */
public static final int AD_ITEMCOLOR_ID_AD_Reference_ID=266;
/** Set AD_ItemColor_ID.
@param AD_ItemColor_ID AD_ItemColor_ID */
public void setAD_ItemColor_ID (int AD_ItemColor_ID)
{
if (AD_ItemColor_ID <= 0) set_Value ("AD_ItemColor_ID", null);
else
set_Value ("AD_ItemColor_ID", new Integer(AD_ItemColor_ID));
}
/** Get AD_ItemColor_ID.
@return AD_ItemColor_ID */
public int getAD_ItemColor_ID() 
{
Integer ii = (Integer)get_Value("AD_ItemColor_ID");
if (ii == null) return 0;
return ii.intValue();
}

/** AD_ItemFont_ID AD_Reference_ID=267 */
public static final int AD_ITEMFONT_ID_AD_Reference_ID=267;
/** Set AD_ItemFont_ID.
@param AD_ItemFont_ID AD_ItemFont_ID */
public void setAD_ItemFont_ID (int AD_ItemFont_ID)
{
if (AD_ItemFont_ID <= 0) set_Value ("AD_ItemFont_ID", null);
else
set_Value ("AD_ItemFont_ID", new Integer(AD_ItemFont_ID));
}
/** Get AD_ItemFont_ID.
@return AD_ItemFont_ID */
public int getAD_ItemFont_ID() 
{
Integer ii = (Integer)get_Value("AD_ItemFont_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Print Color.
@param AD_PrintColor_ID Color used for printing and display */
public void setAD_PrintColor_ID (int AD_PrintColor_ID)
{
if (AD_PrintColor_ID <= 0) set_Value ("AD_PrintColor_ID", null);
else
set_Value ("AD_PrintColor_ID", new Integer(AD_PrintColor_ID));
}
/** Get Print Color.
@return Color used for printing and display */
public int getAD_PrintColor_ID() 
{
Integer ii = (Integer)get_Value("AD_PrintColor_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Print Font.
@param AD_PrintFont_ID Maintain Print Font */
public void setAD_PrintFont_ID (int AD_PrintFont_ID)
{
if (AD_PrintFont_ID <= 0) set_Value ("AD_PrintFont_ID", null);
else
set_Value ("AD_PrintFont_ID", new Integer(AD_PrintFont_ID));
}
/** Get Print Font.
@return Maintain Print Font */
public int getAD_PrintFont_ID() 
{
Integer ii = (Integer)get_Value("AD_PrintFont_ID");
if (ii == null) return 0;
return ii.intValue();
}

/** AD_PrintFormatChild_ID AD_Reference_ID=259 */
public static final int AD_PRINTFORMATCHILD_ID_AD_Reference_ID=259;
/** Set Included Print Format.
@param AD_PrintFormatChild_ID Print format that is included here. */
public void setAD_PrintFormatChild_ID (int AD_PrintFormatChild_ID)
{
if (AD_PrintFormatChild_ID <= 0) set_Value ("AD_PrintFormatChild_ID", null);
else
set_Value ("AD_PrintFormatChild_ID", new Integer(AD_PrintFormatChild_ID));
}
/** Get Included Print Format.
@return Print format that is included here. */
public int getAD_PrintFormatChild_ID() 
{
Integer ii = (Integer)get_Value("AD_PrintFormatChild_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Print Format Item.
@param AD_PrintFormatItem_ID Item/Column in the Print format */
public void setAD_PrintFormatItem_ID (int AD_PrintFormatItem_ID)
{
if (AD_PrintFormatItem_ID <= 0) set_Value ("AD_PrintFormatItem_ID", null);
else
set_Value ("AD_PrintFormatItem_ID", new Integer(AD_PrintFormatItem_ID));
}
/** Get Print Format Item.
@return Item/Column in the Print format */
public int getAD_PrintFormatItem_ID() 
{
Integer ii = (Integer)get_Value("AD_PrintFormatItem_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Print Format.
@param AD_PrintFormat_ID Data Print Format */
public void setAD_PrintFormat_ID (int AD_PrintFormat_ID)
{
if (AD_PrintFormat_ID <= 0) set_Value ("AD_PrintFormat_ID", null);
else
set_Value ("AD_PrintFormat_ID", new Integer(AD_PrintFormat_ID));
}
/** Get Print Format.
@return Data Print Format */
public int getAD_PrintFormat_ID() 
{
Integer ii = (Integer)get_Value("AD_PrintFormat_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Graph.
@param AD_PrintGraph_ID Graph included in Reports */
public void setAD_PrintGraph_ID (int AD_PrintGraph_ID)
{
if (AD_PrintGraph_ID <= 0) set_Value ("AD_PrintGraph_ID", null);
else
set_Value ("AD_PrintGraph_ID", new Integer(AD_PrintGraph_ID));
}
/** Get Graph.
@return Graph included in Reports */
public int getAD_PrintGraph_ID() 
{
Integer ii = (Integer)get_Value("AD_PrintGraph_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Print Paper.
@param AD_PrintPaper_ID Printer paper definition */
public void setAD_PrintPaper_ID (int AD_PrintPaper_ID)
{
if (AD_PrintPaper_ID <= 0) set_Value ("AD_PrintPaper_ID", null);
else
set_Value ("AD_PrintPaper_ID", new Integer(AD_PrintPaper_ID));
}
/** Get Print Paper.
@return Printer paper definition */
public int getAD_PrintPaper_ID() 
{
Integer ii = (Integer)get_Value("AD_PrintPaper_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Table.
@param AD_Table_ID Database Table information */
public void setAD_Table_ID (int AD_Table_ID)
{
if (AD_Table_ID <= 0) set_Value ("AD_Table_ID", null);
else
set_Value ("AD_Table_ID", new Integer(AD_Table_ID));
}
/** Get Table.
@return Database Table information */
public int getAD_Table_ID() 
{
Integer ii = (Integer)get_Value("AD_Table_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Arc Diameter.
@param ArcDiameter Arc Diameter for rounded Rectangles */
public void setArcDiameter (int ArcDiameter)
{
set_Value ("ArcDiameter", new Integer(ArcDiameter));
}
/** Get Arc Diameter.
@return Arc Diameter for rounded Rectangles */
public int getArcDiameter() 
{
Integer ii = (Integer)get_Value("ArcDiameter");
if (ii == null) return 0;
return ii.intValue();
}

/** BarcodeType AD_Reference_ID=377 */
public static final int BARCODETYPE_AD_Reference_ID=377;
/** Code 128 A character set = 28A */
public static final String BARCODETYPE_Code128ACharacterSet = "28A";
/** Code 128 B character set = 28B */
public static final String BARCODETYPE_Code128BCharacterSet = "28B";
/** Code 128 C character set = 28C */
public static final String BARCODETYPE_Code128CCharacterSet = "28C";
/** Codabar 2 of 7 linear = 2o9 */
public static final String BARCODETYPE_Codabar2Of7Linear = "2o9";
/** Code 39  3 of 9 linear with Checksum = 3O9 */
public static final String BARCODETYPE_Code393Of9LinearWithChecksum = "3O9";
/** Code 39  3 of 9 linear w/o Checksum = 3o9 */
public static final String BARCODETYPE_Code393Of9LinearWOChecksum = "3o9";
/** PDF417 two dimensional = 417 */
public static final String BARCODETYPE_PDF417TwoDimensional = "417";
/** SCC-14 shipping code UCC/EAN 128 = C14 */
public static final String BARCODETYPE_SCC_14ShippingCodeUCCEAN128 = "C14";
/** SSCC-18 number UCC/EAN 128 = C18 */
public static final String BARCODETYPE_SSCC_18NumberUCCEAN128 = "C18";
/** Code 128 dynamically switching = C28 */
public static final String BARCODETYPE_Code128DynamicallySwitching = "C28";
/** Code 39 linear with Checksum = C39 */
public static final String BARCODETYPE_Code39LinearWithChecksum = "C39";
/** Codeabar linear = COD */
public static final String BARCODETYPE_CodeabarLinear = "COD";
/** EAN 128 = E28 */
public static final String BARCODETYPE_EAN128 = "E28";
/** Global Trade Item No GTIN UCC/EAN 128 = GTN */
public static final String BARCODETYPE_GlobalTradeItemNoGTINUCCEAN128 = "GTN";
/** Codabar Monarch linear = MON */
public static final String BARCODETYPE_CodabarMonarchLinear = "MON";
/** Codabar NW-7 linear = NW7 */
public static final String BARCODETYPE_CodabarNW_7Linear = "NW7";
/** Shipment ID number UCC/EAN 128 = SID */
public static final String BARCODETYPE_ShipmentIDNumberUCCEAN128 = "SID";
/** UCC 128 = U28 */
public static final String BARCODETYPE_UCC128 = "U28";
/** Code 39 USD3 with Checksum = US3 */
public static final String BARCODETYPE_Code39USD3WithChecksum = "US3";
/** Codabar USD-4 linear = US4 */
public static final String BARCODETYPE_CodabarUSD_4Linear = "US4";
/** US Postal Service UCC/EAN 128 = USP */
public static final String BARCODETYPE_USPostalServiceUCCEAN128 = "USP";
/** Code 39 linear w/o Checksum = c39 */
public static final String BARCODETYPE_Code39LinearWOChecksum = "c39";
/** Code 39 USD3 w/o Checksum = us3 */
public static final String BARCODETYPE_Code39USD3WOChecksum = "us3";
/** Is test a valid value.
@param test testvalue
@returns true if valid **/
public boolean isBarcodeTypeValid (String test)
{
return test == null || test.equals("28A") || test.equals("28B") || test.equals("28C") || test.equals("2o9") || test.equals("3O9") || test.equals("3o9") || test.equals("417") || test.equals("C14") || test.equals("C18") || test.equals("C28") || test.equals("C39") || test.equals("COD") || test.equals("E28") || test.equals("GTN") || test.equals("MON") || test.equals("NW7") || test.equals("SID") || test.equals("U28") || test.equals("US3") || test.equals("US4") || test.equals("USP") || test.equals("c39") || test.equals("us3");
}
/** Set Barcode Type.
@param BarcodeType Type of barcode */
public void setBarcodeType (String BarcodeType)
{
if (!isBarcodeTypeValid(BarcodeType))
throw new IllegalArgumentException ("BarcodeType Invalid value - " + BarcodeType + " - Reference_ID=377 - 28A - 28B - 28C - 2o9 - 3O9 - 3o9 - 417 - C14 - C18 - C28 - C39 - COD - E28 - GTN - MON - NW7 - SID - U28 - US3 - US4 - USP - c39 - us3");
if (BarcodeType != null && BarcodeType.length() > 3)
{
log.warning("Length > 3 - truncated");
BarcodeType = BarcodeType.substring(0,3);
}
set_Value ("BarcodeType", BarcodeType);
}
/** Get Barcode Type.
@return Type of barcode */
public String getBarcodeType() 
{
return (String)get_Value("BarcodeType");
}
/** Set Below Column.
@param BelowColumn Print this column below the column index entered */
public void setBelowColumn (int BelowColumn)
{
set_Value ("BelowColumn", new Integer(BelowColumn));
}
/** Get Below Column.
@return Print this column below the column index entered */
public int getBelowColumn() 
{
Integer ii = (Integer)get_Value("BelowColumn");
if (ii == null) return 0;
return ii.intValue();
}
/** Set DB Column Name.
@param ColumnName Name of the column in the database */
public void setColumnName (String ColumnName)
{
if (ColumnName != null && ColumnName.length() > 120)
{
log.warning("Length > 120 - truncated");
ColumnName = ColumnName.substring(0,120);
}
set_Value ("ColumnName", ColumnName);
}
/** Get DB Column Name.
@return Name of the column in the database */
public String getColumnName() 
{
return (String)get_Value("ColumnName");
}

/** FieldAlignmentType AD_Reference_ID=253 */
public static final int FIELDALIGNMENTTYPE_AD_Reference_ID=253;
/** Block = B */
public static final String FIELDALIGNMENTTYPE_Block = "B";
/** Center = C */
public static final String FIELDALIGNMENTTYPE_Center = "C";
/** Default = D */
public static final String FIELDALIGNMENTTYPE_Default = "D";
/** Leading (left) = L */
public static final String FIELDALIGNMENTTYPE_LeadingLeft = "L";
/** Trailing (right) = T */
public static final String FIELDALIGNMENTTYPE_TrailingRight = "T";
/** Is test a valid value.
@param test testvalue
@returns true if valid **/
public boolean isFieldAlignmentTypeValid (String test)
{
return test == null || test.equals("B") || test.equals("C") || test.equals("D") || test.equals("L") || test.equals("T");
}
/** Set Field Alignment.
@param FieldAlignmentType Field Text Alignment */
public void setFieldAlignmentType (String FieldAlignmentType)
{
if (!isFieldAlignmentTypeValid(FieldAlignmentType))
throw new IllegalArgumentException ("FieldAlignmentType Invalid value - " + FieldAlignmentType + " - Reference_ID=253 - B - C - D - L - T");
if (FieldAlignmentType != null && FieldAlignmentType.length() > 1)
{
log.warning("Length > 1 - truncated");
FieldAlignmentType = FieldAlignmentType.substring(0,1);
}
set_Value ("FieldAlignmentType", FieldAlignmentType);
}
/** Get Field Alignment.
@return Field Text Alignment */
public String getFieldAlignmentType() 
{
return (String)get_Value("FieldAlignmentType");
}
/** Set Footer Margin.
@param FooterMargin Margin of the Footer in 1/72 of an inch */
public void setFooterMargin (int FooterMargin)
{
set_Value ("FooterMargin", new Integer(FooterMargin));
}
/** Get Footer Margin.
@return Margin of the Footer in 1/72 of an inch */
public int getFooterMargin() 
{
Integer ii = (Integer)get_Value("FooterMargin");
if (ii == null) return 0;
return ii.intValue();
}
/** Set FormatName.
@param FormatName FormatName */
public void setFormatName (String FormatName)
{
if (FormatName != null && FormatName.length() > 120)
{
log.warning("Length > 120 - truncated");
FormatName = FormatName.substring(0,120);
}
set_Value ("FormatName", FormatName);
}
/** Get FormatName.
@return FormatName */
public String getFormatName() 
{
return (String)get_Value("FormatName");
}
/** Set Header Margin.
@param HeaderMargin Margin of the Header in 1/72 of an inch */
public void setHeaderMargin (int HeaderMargin)
{
set_Value ("HeaderMargin", new Integer(HeaderMargin));
}
/** Get Header Margin.
@return Margin of the Header in 1/72 of an inch */
public int getHeaderMargin() 
{
Integer ii = (Integer)get_Value("HeaderMargin");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Import Error Message.
@param I_ErrorMsg Messages generated from import process */
public void setI_ErrorMsg (String I_ErrorMsg)
{
if (I_ErrorMsg != null && I_ErrorMsg.length() > 200)
{
log.warning("Length > 200 - truncated");
I_ErrorMsg = I_ErrorMsg.substring(0,200);
}
set_Value ("I_ErrorMsg", I_ErrorMsg);
}
/** Get Import Error Message.
@return Messages generated from import process */
public String getI_ErrorMsg() 
{
return (String)get_Value("I_ErrorMsg");
}
/** Set Imported.
@param I_IsImported Has this import been processed */
public void setI_IsImported (boolean I_IsImported)
{
set_Value ("I_IsImported", new Boolean(I_IsImported));
}
/** Get Imported.
@return Has this import been processed */
public boolean isI_IsImported() 
{
Object oo = get_Value("I_IsImported");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set I_PrintFormatItem_ID.
@param I_PrintFormatItem_ID I_PrintFormatItem_ID */
public void setI_PrintFormatItem_ID (int I_PrintFormatItem_ID)
{
if (I_PrintFormatItem_ID < 1) throw new IllegalArgumentException ("I_PrintFormatItem_ID is mandatory.");
set_ValueNoCheck ("I_PrintFormatItem_ID", new Integer(I_PrintFormatItem_ID));
}
/** Get I_PrintFormatItem_ID.
@return I_PrintFormatItem_ID */
public int getI_PrintFormatItem_ID() 
{
Integer ii = (Integer)get_Value("I_PrintFormatItem_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Image attached.
@param ImageIsAttached The image to be printed is attached to the record */
public void setImageIsAttached (boolean ImageIsAttached)
{
set_Value ("ImageIsAttached", new Boolean(ImageIsAttached));
}
/** Get Image attached.
@return The image to be printed is attached to the record */
public boolean isImageIsAttached() 
{
Object oo = get_Value("ImageIsAttached");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set Image URL.
@param ImageURL URL of  image */
public void setImageURL (String ImageURL)
{
if (ImageURL != null && ImageURL.length() > 240)
{
log.warning("Length > 240 - truncated");
ImageURL = ImageURL.substring(0,240);
}
set_Value ("ImageURL", ImageURL);
}
/** Get Image URL.
@return URL of  image */
public String getImageURL() 
{
return (String)get_Value("ImageURL");
}
/** Set Calculate Mean ().
@param IsAveraged Calculate Average of numeric content or length */
public void setIsAveraged (boolean IsAveraged)
{
set_Value ("IsAveraged", new Boolean(IsAveraged));
}
/** Get Calculate Mean ().
@return Calculate Average of numeric content or length */
public boolean isAveraged() 
{
Object oo = get_Value("IsAveraged");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set Centrally maintained.
@param IsCentrallyMaintained Information maintained in System Element table */
public void setIsCentrallyMaintained (boolean IsCentrallyMaintained)
{
set_Value ("IsCentrallyMaintained", new Boolean(IsCentrallyMaintained));
}
/** Get Centrally maintained.
@return Information maintained in System Element table */
public boolean isCentrallyMaintained() 
{
Object oo = get_Value("IsCentrallyMaintained");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set Calculate Count ().
@param IsCounted Count number of not empty elements */
public void setIsCounted (boolean IsCounted)
{
set_Value ("IsCounted", new Boolean(IsCounted));
}
/** Get Calculate Count ().
@return Count number of not empty elements */
public boolean isCounted() 
{
Object oo = get_Value("IsCounted");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set Calculate Deviation ().
@param IsDeviationCalc Calculate Standard Deviation */
public void setIsDeviationCalc (boolean IsDeviationCalc)
{
set_Value ("IsDeviationCalc", new Boolean(IsDeviationCalc));
}
/** Get Calculate Deviation ().
@return Calculate Standard Deviation */
public boolean isDeviationCalc() 
{
Object oo = get_Value("IsDeviationCalc");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set Fill Shape.
@param IsFilledRectangle Fill the shape with the color selected */
public void setIsFilledRectangle (boolean IsFilledRectangle)
{
set_Value ("IsFilledRectangle", new Boolean(IsFilledRectangle));
}
/** Get Fill Shape.
@return Fill the shape with the color selected */
public boolean isFilledRectangle() 
{
Object oo = get_Value("IsFilledRectangle");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set Fixed Width.
@param IsFixedWidth Column has a fixed width */
public void setIsFixedWidth (boolean IsFixedWidth)
{
set_Value ("IsFixedWidth", new Boolean(IsFixedWidth));
}
/** Get Fixed Width.
@return Column has a fixed width */
public boolean isFixedWidth() 
{
Object oo = get_Value("IsFixedWidth");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set Form.
@param IsForm If Selected, a Form is printed, if not selected a columnar List report */
public void setIsForm (boolean IsForm)
{
set_Value ("IsForm", new Boolean(IsForm));
}
/** Get Form.
@return If Selected, a Form is printed, if not selected a columnar List report */
public boolean isForm() 
{
Object oo = get_Value("IsForm");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set Group by.
@param IsGroupBy After a group change, totals, etc. are printed */
public void setIsGroupBy (boolean IsGroupBy)
{
set_Value ("IsGroupBy", new Boolean(IsGroupBy));
}
/** Get Group by.
@return After a group change, totals, etc. are printed */
public boolean isGroupBy() 
{
Object oo = get_Value("IsGroupBy");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set One Line Only.
@param IsHeightOneLine If selected, only one line is printed */
public void setIsHeightOneLine (boolean IsHeightOneLine)
{
set_Value ("IsHeightOneLine", new Boolean(IsHeightOneLine));
}
/** Get One Line Only.
@return If selected, only one line is printed */
public boolean isHeightOneLine() 
{
Object oo = get_Value("IsHeightOneLine");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set Image Field.
@param IsImageField The image is retrieved from the data column */
public void setIsImageField (boolean IsImageField)
{
set_Value ("IsImageField", new Boolean(IsImageField));
}
/** Get Image Field.
@return The image is retrieved from the data column */
public boolean isImageField() 
{
Object oo = get_Value("IsImageField");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set Calculate Maximum ().
@param IsMaxCalc Calculate the maximum amount */
public void setIsMaxCalc (boolean IsMaxCalc)
{
set_Value ("IsMaxCalc", new Boolean(IsMaxCalc));
}
/** Get Calculate Maximum ().
@return Calculate the maximum amount */
public boolean isMaxCalc() 
{
Object oo = get_Value("IsMaxCalc");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set Calculate Minimum ().
@param IsMinCalc Calculate the minimum amount */
public void setIsMinCalc (boolean IsMinCalc)
{
set_Value ("IsMinCalc", new Boolean(IsMinCalc));
}
/** Get Calculate Minimum ().
@return Calculate the minimum amount */
public boolean isMinCalc() 
{
Object oo = get_Value("IsMinCalc");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set Next Line.
@param IsNextLine Print item on next line */
public void setIsNextLine (boolean IsNextLine)
{
set_Value ("IsNextLine", new Boolean(IsNextLine));
}
/** Get Next Line.
@return Print item on next line */
public boolean isNextLine() 
{
Object oo = get_Value("IsNextLine");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set Next Page.
@param IsNextPage The column is printed on the next page */
public void setIsNextPage (boolean IsNextPage)
{
set_Value ("IsNextPage", new Boolean(IsNextPage));
}
/** Get Next Page.
@return The column is printed on the next page */
public boolean isNextPage() 
{
Object oo = get_Value("IsNextPage");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set Order by.
@param IsOrderBy Include in sort order */
public void setIsOrderBy (boolean IsOrderBy)
{
set_Value ("IsOrderBy", new Boolean(IsOrderBy));
}
/** Get Order by.
@return Include in sort order */
public boolean isOrderBy() 
{
Object oo = get_Value("IsOrderBy");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set Page break.
@param IsPageBreak Start with new page */
public void setIsPageBreak (boolean IsPageBreak)
{
set_Value ("IsPageBreak", new Boolean(IsPageBreak));
}
/** Get Page break.
@return Start with new page */
public boolean isPageBreak() 
{
Object oo = get_Value("IsPageBreak");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set Printed.
@param IsPrinted Indicates if this document / line is printed */
public void setIsPrinted (boolean IsPrinted)
{
set_Value ("IsPrinted", new Boolean(IsPrinted));
}
/** Get Printed.
@return Indicates if this document / line is printed */
public boolean isPrinted() 
{
Object oo = get_Value("IsPrinted");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set Relative Position.
@param IsRelativePosition The item is relative positioned (not absolute) */
public void setIsRelativePosition (boolean IsRelativePosition)
{
set_Value ("IsRelativePosition", new Boolean(IsRelativePosition));
}
/** Get Relative Position.
@return The item is relative positioned (not absolute) */
public boolean isRelativePosition() 
{
Object oo = get_Value("IsRelativePosition");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set Running Total.
@param IsRunningTotal Create a running total (sum) */
public void setIsRunningTotal (boolean IsRunningTotal)
{
set_Value ("IsRunningTotal", new Boolean(IsRunningTotal));
}
/** Get Running Total.
@return Create a running total (sum) */
public boolean isRunningTotal() 
{
Object oo = get_Value("IsRunningTotal");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set Set NL Position.
@param IsSetNLPosition Set New Line Position */
public void setIsSetNLPosition (boolean IsSetNLPosition)
{
set_Value ("IsSetNLPosition", new Boolean(IsSetNLPosition));
}
/** Get Set NL Position.
@return Set New Line Position */
public boolean isSetNLPosition() 
{
Object oo = get_Value("IsSetNLPosition");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set Standard Header/Footer.
@param IsStandardHeaderFooter The standard Header and Footer is used */
public void setIsStandardHeaderFooter (boolean IsStandardHeaderFooter)
{
set_Value ("IsStandardHeaderFooter", new Boolean(IsStandardHeaderFooter));
}
/** Get Standard Header/Footer.
@return The standard Header and Footer is used */
public boolean isStandardHeaderFooter() 
{
Object oo = get_Value("IsStandardHeaderFooter");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set Calculate Sum ().
@param IsSummarized Calculate the Sum of numeric content or length */
public void setIsSummarized (boolean IsSummarized)
{
set_Value ("IsSummarized", new Boolean(IsSummarized));
}
/** Get Calculate Sum ().
@return Calculate the Sum of numeric content or length */
public boolean isSummarized() 
{
Object oo = get_Value("IsSummarized");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set Suppress Null.
@param IsSuppressNull Suppress columns or elements with NULL value */
public void setIsSuppressNull (boolean IsSuppressNull)
{
set_Value ("IsSuppressNull", new Boolean(IsSuppressNull));
}
/** Get Suppress Null.
@return Suppress columns or elements with NULL value */
public boolean isSuppressNull() 
{
Object oo = get_Value("IsSuppressNull");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set Table Based.
@param IsTableBased Table based List Reporting */
public void setIsTableBased (boolean IsTableBased)
{
set_Value ("IsTableBased", new Boolean(IsTableBased));
}
/** Get Table Based.
@return Table based List Reporting */
public boolean isTableBased() 
{
Object oo = get_Value("IsTableBased");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set Calculate Variance (2).
@param IsVarianceCalc Calculate Variance */
public void setIsVarianceCalc (boolean IsVarianceCalc)
{
set_Value ("IsVarianceCalc", new Boolean(IsVarianceCalc));
}
/** Get Calculate Variance (2).
@return Calculate Variance */
public boolean isVarianceCalc() 
{
Object oo = get_Value("IsVarianceCalc");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set ItemColor.
@param ItemColor ItemColor */
public void setItemColor (String ItemColor)
{
if (ItemColor != null && ItemColor.length() > 60)
{
log.warning("Length > 60 - truncated");
ItemColor = ItemColor.substring(0,60);
}
set_Value ("ItemColor", ItemColor);
}
/** Get ItemColor.
@return ItemColor */
public String getItemColor() 
{
return (String)get_Value("ItemColor");
}
/** Set ItemFont.
@param ItemFont ItemFont */
public void setItemFont (String ItemFont)
{
if (ItemFont != null && ItemFont.length() > 10)
{
log.warning("Length > 10 - truncated");
ItemFont = ItemFont.substring(0,10);
}
set_Value ("ItemFont", ItemFont);
}
/** Get ItemFont.
@return ItemFont */
public String getItemFont() 
{
return (String)get_Value("ItemFont");
}
/** Set Print Item Name.
@param ItemName Print Item Name */
public void setItemName (String ItemName)
{
if (ItemName != null && ItemName.length() > 120)
{
log.warning("Length > 120 - truncated");
ItemName = ItemName.substring(0,120);
}
set_Value ("ItemName", ItemName);
}
/** Get Print Item Name.
@return Print Item Name */
public String getItemName() 
{
return (String)get_Value("ItemName");
}

/** LineAlignmentType AD_Reference_ID=254 */
public static final int LINEALIGNMENTTYPE_AD_Reference_ID=254;
/** Center = C */
public static final String LINEALIGNMENTTYPE_Center = "C";
/** Leading (left) = L */
public static final String LINEALIGNMENTTYPE_LeadingLeft = "L";
/** Trailing (right) = T */
public static final String LINEALIGNMENTTYPE_TrailingRight = "T";
/** None = X */
public static final String LINEALIGNMENTTYPE_None = "X";
/** Is test a valid value.
@param test testvalue
@returns true if valid **/
public boolean isLineAlignmentTypeValid (String test)
{
return test == null || test.equals("C") || test.equals("L") || test.equals("T") || test.equals("X");
}
/** Set Line Alignment.
@param LineAlignmentType Line Alignment */
public void setLineAlignmentType (String LineAlignmentType)
{
if (!isLineAlignmentTypeValid(LineAlignmentType))
throw new IllegalArgumentException ("LineAlignmentType Invalid value - " + LineAlignmentType + " - Reference_ID=254 - C - L - T - X");
if (LineAlignmentType != null && LineAlignmentType.length() > 1)
{
log.warning("Length > 1 - truncated");
LineAlignmentType = LineAlignmentType.substring(0,1);
}
set_Value ("LineAlignmentType", LineAlignmentType);
}
/** Get Line Alignment.
@return Line Alignment */
public String getLineAlignmentType() 
{
return (String)get_Value("LineAlignmentType");
}
/** Set Line Width.
@param LineWidth Width of the lines */
public void setLineWidth (int LineWidth)
{
set_Value ("LineWidth", new Integer(LineWidth));
}
/** Get Line Width.
@return Width of the lines */
public int getLineWidth() 
{
Integer ii = (Integer)get_Value("LineWidth");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Max Height.
@param MaxHeight Maximum Height in 1/72 if an inch - 0 = no restriction */
public void setMaxHeight (int MaxHeight)
{
set_Value ("MaxHeight", new Integer(MaxHeight));
}
/** Get Max Height.
@return Maximum Height in 1/72 if an inch - 0 = no restriction */
public int getMaxHeight() 
{
Integer ii = (Integer)get_Value("MaxHeight");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Max Width.
@param MaxWidth Maximum Width in 1/72 if an inch - 0 = no restriction */
public void setMaxWidth (int MaxWidth)
{
set_Value ("MaxWidth", new Integer(MaxWidth));
}
/** Get Max Width.
@return Maximum Width in 1/72 if an inch - 0 = no restriction */
public int getMaxWidth() 
{
Integer ii = (Integer)get_Value("MaxWidth");
if (ii == null) return 0;
return ii.intValue();
}

/** PrintAreaType AD_Reference_ID=256 */
public static final int PRINTAREATYPE_AD_Reference_ID=256;
/** Content = C */
public static final String PRINTAREATYPE_Content = "C";
/** Footer = F */
public static final String PRINTAREATYPE_Footer = "F";
/** Header = H */
public static final String PRINTAREATYPE_Header = "H";
/** Is test a valid value.
@param test testvalue
@returns true if valid **/
public boolean isPrintAreaTypeValid (String test)
{
return test == null || test.equals("C") || test.equals("F") || test.equals("H");
}
/** Set Area.
@param PrintAreaType Print Area */
public void setPrintAreaType (String PrintAreaType)
{
if (!isPrintAreaTypeValid(PrintAreaType))
throw new IllegalArgumentException ("PrintAreaType Invalid value - " + PrintAreaType + " - Reference_ID=256 - C - F - H");
if (PrintAreaType != null && PrintAreaType.length() > 1)
{
log.warning("Length > 1 - truncated");
PrintAreaType = PrintAreaType.substring(0,1);
}
set_Value ("PrintAreaType", PrintAreaType);
}
/** Get Area.
@return Print Area */
public String getPrintAreaType() 
{
return (String)get_Value("PrintAreaType");
}
/** Set PrintColor.
@param PrintColor PrintColor */
public void setPrintColor (String PrintColor)
{
if (PrintColor != null && PrintColor.length() > 120)
{
log.warning("Length > 120 - truncated");
PrintColor = PrintColor.substring(0,120);
}
set_Value ("PrintColor", PrintColor);
}
/** Get PrintColor.
@return PrintColor */
public String getPrintColor() 
{
return (String)get_Value("PrintColor");
}
/** Set PrintFont.
@param PrintFont PrintFont */
public void setPrintFont (String PrintFont)
{
if (PrintFont != null && PrintFont.length() > 120)
{
log.warning("Length > 120 - truncated");
PrintFont = PrintFont.substring(0,120);
}
set_Value ("PrintFont", PrintFont);
}
/** Get PrintFont.
@return PrintFont */
public String getPrintFont() 
{
return (String)get_Value("PrintFont");
}
/** Set PrintFormatChild.
@param PrintFormatChild PrintFormatChild */
public void setPrintFormatChild (String PrintFormatChild)
{
if (PrintFormatChild != null && PrintFormatChild.length() > 120)
{
log.warning("Length > 120 - truncated");
PrintFormatChild = PrintFormatChild.substring(0,120);
}
set_Value ("PrintFormatChild", PrintFormatChild);
}
/** Get PrintFormatChild.
@return PrintFormatChild */
public String getPrintFormatChild() 
{
return (String)get_Value("PrintFormatChild");
}

/** PrintFormatType AD_Reference_ID=255 */
public static final int PRINTFORMATTYPE_AD_Reference_ID=255;
/** Field = F */
public static final String PRINTFORMATTYPE_Field = "F";
/** Image = I */
public static final String PRINTFORMATTYPE_Image = "I";
/** Line = L */
public static final String PRINTFORMATTYPE_Line = "L";
/** Print Format = P */
public static final String PRINTFORMATTYPE_PrintFormat = "P";
/** Rectangle = R */
public static final String PRINTFORMATTYPE_Rectangle = "R";
/** Text = T */
public static final String PRINTFORMATTYPE_Text = "T";
/** Is test a valid value.
@param test testvalue
@returns true if valid **/
public boolean isPrintFormatTypeValid (String test)
{
return test == null || test.equals("F") || test.equals("I") || test.equals("L") || test.equals("P") || test.equals("R") || test.equals("T");
}
/** Set Format Type.
@param PrintFormatType Print Format Type */
public void setPrintFormatType (String PrintFormatType)
{
if (!isPrintFormatTypeValid(PrintFormatType))
throw new IllegalArgumentException ("PrintFormatType Invalid value - " + PrintFormatType + " - Reference_ID=255 - F - I - L - P - R - T");
if (PrintFormatType != null && PrintFormatType.length() > 1)
{
log.warning("Length > 1 - truncated");
PrintFormatType = PrintFormatType.substring(0,1);
}
set_Value ("PrintFormatType", PrintFormatType);
}
/** Get Format Type.
@return Print Format Type */
public String getPrintFormatType() 
{
return (String)get_Value("PrintFormatType");
}
/** Set PrintGraph.
@param PrintGraph PrintGraph */
public void setPrintGraph (String PrintGraph)
{
if (PrintGraph != null && PrintGraph.length() > 120)
{
log.warning("Length > 120 - truncated");
PrintGraph = PrintGraph.substring(0,120);
}
set_Value ("PrintGraph", PrintGraph);
}
/** Get PrintGraph.
@return PrintGraph */
public String getPrintGraph() 
{
return (String)get_Value("PrintGraph");
}
/** Set Print Text.
@param PrintName The label text to be printed on a document or correspondence. */
public void setPrintName (String PrintName)
{
if (PrintName != null && PrintName.length() > 200)
{
log.warning("Length > 200 - truncated");
PrintName = PrintName.substring(0,200);
}
set_Value ("PrintName", PrintName);
}
/** Get Print Text.
@return The label text to be printed on a document or correspondence. */
public String getPrintName() 
{
return (String)get_Value("PrintName");
}
/** Set Print Label Suffix.
@param PrintNameSuffix The label text to be printed on a document or correspondence after the field */
public void setPrintNameSuffix (String PrintNameSuffix)
{
if (PrintNameSuffix != null && PrintNameSuffix.length() > 120)
{
log.warning("Length > 120 - truncated");
PrintNameSuffix = PrintNameSuffix.substring(0,120);
}
set_Value ("PrintNameSuffix", PrintNameSuffix);
}
/** Get Print Label Suffix.
@return The label text to be printed on a document or correspondence after the field */
public String getPrintNameSuffix() 
{
return (String)get_Value("PrintNameSuffix");
}
/** Set PrintPaper.
@param PrintPaper PrintPaper */
public void setPrintPaper (String PrintPaper)
{
if (PrintPaper != null && PrintPaper.length() > 120)
{
log.warning("Length > 120 - truncated");
PrintPaper = PrintPaper.substring(0,120);
}
set_Value ("PrintPaper", PrintPaper);
}
/** Get PrintPaper.
@return PrintPaper */
public String getPrintPaper() 
{
return (String)get_Value("PrintPaper");
}
/** Set Processed.
@param Processed The document has been processed */
public void setProcessed (boolean Processed)
{
set_Value ("Processed", new Boolean(Processed));
}
/** Get Processed.
@return The document has been processed */
public boolean isProcessed() 
{
Object oo = get_Value("Processed");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set Process Now.
@param Processing Process Now */
public void setProcessing (boolean Processing)
{
set_Value ("Processing", new Boolean(Processing));
}
/** Get Process Now.
@return Process Now */
public boolean isProcessing() 
{
Object oo = get_Value("Processing");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set Running Total Lines.
@param RunningTotalLines Create Running Total Lines (page break) every x lines */
public void setRunningTotalLines (int RunningTotalLines)
{
set_Value ("RunningTotalLines", new Integer(RunningTotalLines));
}
/** Get Running Total Lines.
@return Create Running Total Lines (page break) every x lines */
public int getRunningTotalLines() 
{
Integer ii = (Integer)get_Value("RunningTotalLines");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Sequence.
@param SeqNo Method of ordering elements;
 lowest number comes first */
public void setSeqNo (int SeqNo)
{
set_Value ("SeqNo", new Integer(SeqNo));
}
/** Get Sequence.
@return Method of ordering elements;
 lowest number comes first */
public int getSeqNo() 
{
Integer ii = (Integer)get_Value("SeqNo");
if (ii == null) return 0;
return ii.intValue();
}

/** ShapeType AD_Reference_ID=333 */
public static final int SHAPETYPE_AD_Reference_ID=333;
/** 3D Rectangle = 3 */
public static final String SHAPETYPE_3DRectangle = "3";
/** Normal Rectangle = N */
public static final String SHAPETYPE_NormalRectangle = "N";
/** Oval = O */
public static final String SHAPETYPE_Oval = "O";
/** Round Rectangle = R */
public static final String SHAPETYPE_RoundRectangle = "R";
/** Is test a valid value.
@param test testvalue
@returns true if valid **/
public boolean isShapeTypeValid (String test)
{
return test == null || test.equals("3") || test.equals("N") || test.equals("O") || test.equals("R");
}
/** Set Shape Type.
@param ShapeType Type of the shape to be painted */
public void setShapeType (String ShapeType)
{
if (!isShapeTypeValid(ShapeType))
throw new IllegalArgumentException ("ShapeType Invalid value - " + ShapeType + " - Reference_ID=333 - 3 - N - O - R");
if (ShapeType != null && ShapeType.length() > 1)
{
log.warning("Length > 1 - truncated");
ShapeType = ShapeType.substring(0,1);
}
set_Value ("ShapeType", ShapeType);
}
/** Get Shape Type.
@return Type of the shape to be painted */
public String getShapeType() 
{
return (String)get_Value("ShapeType");
}
/** Set Record Sort No.
@param SortNo Determines in what order the records are displayed */
public void setSortNo (int SortNo)
{
set_Value ("SortNo", new Integer(SortNo));
}
/** Get Record Sort No.
@return Determines in what order the records are displayed */
public int getSortNo() 
{
Integer ii = (Integer)get_Value("SortNo");
if (ii == null) return 0;
return ii.intValue();
}
/** Set DB Table Name.
@param TableName Name of the table in the database */
public void setTableName (String TableName)
{
if (TableName != null && TableName.length() > 120)
{
log.warning("Length > 120 - truncated");
TableName = TableName.substring(0,120);
}
set_Value ("TableName", TableName);
}
/** Get DB Table Name.
@return Name of the table in the database */
public String getTableName() 
{
return (String)get_Value("TableName");
}
/** Set X Position.
@param XPosition Absolute X (horizontal) position in 1/72 of an inch */
public void setXPosition (int XPosition)
{
set_Value ("XPosition", new Integer(XPosition));
}
/** Get X Position.
@return Absolute X (horizontal) position in 1/72 of an inch */
public int getXPosition() 
{
Integer ii = (Integer)get_Value("XPosition");
if (ii == null) return 0;
return ii.intValue();
}
/** Set X Space.
@param XSpace Relative X (horizontal) space in 1/72 of an inch */
public void setXSpace (int XSpace)
{
set_Value ("XSpace", new Integer(XSpace));
}
/** Get X Space.
@return Relative X (horizontal) space in 1/72 of an inch */
public int getXSpace() 
{
Integer ii = (Integer)get_Value("XSpace");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Y Position.
@param YPosition Absolute Y (vertical) position in 1/72 of an inch */
public void setYPosition (int YPosition)
{
set_Value ("YPosition", new Integer(YPosition));
}
/** Get Y Position.
@return Absolute Y (vertical) position in 1/72 of an inch */
public int getYPosition() 
{
Integer ii = (Integer)get_Value("YPosition");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Y Space.
@param YSpace Relative Y (vertical) space in 1/72 of an inch */
public void setYSpace (int YSpace)
{
set_Value ("YSpace", new Integer(YSpace));
}
/** Get Y Space.
@return Relative Y (vertical) space in 1/72 of an inch */
public int getYSpace() 
{
Integer ii = (Integer)get_Value("YSpace");
if (ii == null) return 0;
return ii.intValue();
}
}
