/******************************************************************************
 * Product: Compiere ERP & CRM Smart Business Solution                        *
 * Copyright (C) 1999-2007 ComPiere, Inc. All Rights Reserved.                *
 * This program is free software, you can redistribute it and/or modify it    *
 * under the terms version 2 of the GNU General Public License as published   *
 * by the Free Software Foundation. This program is distributed in the hope   *
 * that it will be useful, but WITHOUT ANY WARRANTY, without even the implied *
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.           *
 * See the GNU General Public License for more details.                       *
 * You should have received a copy of the GNU General Public License along    *
 * with this program, if not, write to the Free Software Foundation, Inc.,    *
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.                     *
 * For the text or an alternative of this public license, you may reach us    *
 * ComPiere, Inc., 3600 Bridge Parkway #102, Redwood City, CA 94065, USA      *
 * or via info@compiere.org or http://www.compiere.org/license.html           *
 *****************************************************************************/

package org.compiere.install;

import java.io.*;
import javax.swing.filechooser.FileFilter;

/**
 * 	Component Name Filter
 *	@author Jorg Janke
 */
public class ComponentFileFilter extends FileFilter 
	implements FilenameFilter
{

	/**
	 * 	Accept Component File
	 */
	public boolean accept(File dir, String name)
	{
		if (name != null && name.endsWith(".car"))
			return true;
		return false;
	}	//	accept

	/**
	 * 	Accept Component File
	 */
	public boolean accept(File pathname)
	{
		return accept(pathname.getParentFile(), pathname.getName());
	}	// accept

	/**
	 * 	Description
	 */
	public String getDescription()
	{
		return "Compiere Component";
	}	//	getDescriprion

}	//	ComponentFileFilter
