/*
 * Copyright 2007 Sandy McArthur, Jr.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package org.mcarthur.sandy.gwt.plugin.client;

import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.core.client.GWT;

import java.util.List;
import java.util.ArrayList;

/**
 * TODO: Write Javadoc
 *
 * @author Sandy McArthur
 */
public class FlashInnerHtml extends Widget {
    private final Element div = DOM.createDiv();

    private static FlashInnerHtmlImpl impl = (FlashInnerHtmlImpl)GWT.create(FlashInnerHtmlImpl.class);

    public FlashInnerHtml(final String movie) {
        setElement(div);
        DOM.setInnerHTML(div, "<object type=\"application/x-shockwave-flash\" data=\"test.swf\" name=\"gwtStuffFlash0\" id=\"gwtStuffFlash0\" style=\"width: 160px; height: 120px; \"><param name=\"movie\" value=\"" + movie + "\"><param name=\"swliveconnect\" value=\"true\"></object>");
    }

    private List/*<EventsListener>*/ listeners;
    private boolean callbackRegistered = false;
    public void addFSCommandListener(final FsCommandListener listener) {
        if (!callbackRegistered) {
            listeners = new ArrayList();
            impl.registerCallbacks(FlashInnerHtml.this, "gwtStuffFlash0");
            /*
            new Timer() {
                public void run() {
                    impl.registerCallbacks(FlashInnerHtml.this, "gwtStuffFlash0");
                }
            }.schedule(1000);
            */
            /*
            DeferredCommand.add(new Command() {
                public void execute() {
                    impl.registerCallbacks(FlashInnerHtml.this, "gwtStuffFlash0");
                }
            });            
            */
        }
        listeners.add(listener);
    }
    void doFSCommand(final String command, final String args) {
        if (listeners != null) {
            final Object[] listenersArray = listeners.toArray();
            for (int i=0; i < listenersArray.length; i++) {
                final FsCommandListener fsCommandListener = (FsCommandListener)listenersArray[i];
                fsCommandListener.fsCommand(command, args);
            }
        }
    }
    private native void XregisterCallbacks(FlashInnerHtml instance, String name) /*-{
        $wnd[name+'_DoFSCommand'] = function (command, args) {
            instance.@org.mcarthur.sandy.gwt.plugin.client.FlashInnerHtml::doFSCommand(Ljava/lang/String;Ljava/lang/String;)(command, args);
        };
    }-*/;

    /**
     * Callback so GWT can receive FSCommand calls from in the Flash movie.
     *
     * @see org.mcarthur.sandy.gwt.plugin.client.Flash#addFSCommandListener(org.mcarthur.sandy.gwt.plugin.client.Flash.FsCommandListener)
     * @see <a href="http://www.adobe.com/support/flash/publishexport/scriptingwithflash/scriptingwithflash_03.html">Flash Events</a>
     */
    public interface FsCommandListener {
        public void fsCommand(String command, String args);
    }

}
