/*
 * Decompiled with CFR 0.152.
 */
package jp.co.connectone.comm;

import java.util.Date;
import java.util.HashMap;
import jp.co.connectone.comm.CmdBase;
import jp.co.connectone.exception.HandleException;
import jp.co.connectone.store.IObjectIndex;
import jp.co.connectone.store.IRecordObject;
import jp.co.connectone.store.ISearchDestination;
import jp.co.connectone.store.ISearchFormula;
import jp.co.connectone.store.db.IDBStore;
import jp.co.connectone.user.IAccountData;

public class DBStoreCmd
extends CmdBase {
    public static final DBStoreCmd searchByDate = new DBStoreCmd();
    public static final DBStoreCmd search = new DBStoreCmd();
    public static final DBStoreCmd getUniqueIndexes = new DBStoreCmd();
    public static final DBStoreCmd getDataSet = new DBStoreCmd();
    public static final DBStoreCmd getFolders = new DBStoreCmd();
    public static final DBStoreCmd read = new DBStoreCmd();
    public static final DBStoreCmd write = new DBStoreCmd();
    public static final DBStoreCmd delete = new DBStoreCmd();

    protected DBStoreCmd() {
    }

    public DBStoreCmd(IAccountData accData, String remoteClassName, CmdBase cmd, HashMap params) {
        super(accData, remoteClassName, cmd, params);
    }

    public int getRetType() throws HandleException {
        try {
            return super.getRetType();
        }
        catch (HandleException handleException) {
            if (this.cmd == delete || this.cmd == write) {
                return 0;
            }
            if (this.cmd == getFolders || this.cmd == getDataSet || this.cmd == getUniqueIndexes || this.cmd == search || this.cmd == searchByDate) {
                return 2;
            }
            if (this.cmd == read) {
                return 1;
            }
            throw new HandleException("unknown cmd type.");
        }
    }

    public IRecordObject[] runMulti() throws HandleException {
        IRecordObject[] rc = null;
        IDBStore remoteClass = (IDBStore)this.getRemoteClass();
        if (this.cmd == searchByDate) {
            ISearchDestination param1 = (ISearchDestination)this.params.get("param1");
            Date param2 = (Date)this.params.get("param2");
            rc = remoteClass.searchByDate(this.accData, param1, param2);
        } else if (this.cmd == search) {
            ISearchFormula param1 = (ISearchFormula)this.params.get("param1");
            rc = remoteClass.search(this.accData, param1);
        } else if (this.cmd == getUniqueIndexes) {
            ISearchFormula param1 = (ISearchFormula)this.params.get("param1");
            rc = remoteClass.getUniqueIndexes(this.accData, param1);
        } else if (this.cmd == getDataSet) {
            ISearchDestination param1 = (ISearchDestination)this.params.get("param1");
            IRecordObject param2 = (IRecordObject)this.params.get("param2");
            rc = remoteClass.getDataSet(this.accData, param1, param2);
        } else if (this.cmd == getFolders) {
            ISearchDestination param1 = (ISearchDestination)this.params.get("param1");
            rc = remoteClass.getFolders(this.accData, param1);
        } else {
            throw new HandleException("unknown cmd type.");
        }
        return rc;
    }

    public IRecordObject runSingle() throws HandleException {
        IRecordObject rc = null;
        IDBStore remoteClass = (IDBStore)this.getRemoteClass();
        if (this.cmd != read) {
            throw new HandleException("unknown cmd type.");
        }
        ISearchDestination param1 = (ISearchDestination)this.params.get("param1");
        IObjectIndex param2 = (IObjectIndex)this.params.get("param2");
        rc = remoteClass.read(this.accData, param1, param2);
        return rc;
    }

    public void runVoid() throws HandleException {
        IDBStore remoteClass = (IDBStore)this.getRemoteClass();
        if (this.cmd == delete) {
            ISearchDestination param1 = (ISearchDestination)this.params.get("param1");
            IObjectIndex param2 = (IObjectIndex)this.params.get("param2");
            remoteClass.delete(this.accData, param1, param2);
        } else if (this.cmd == write) {
            ISearchDestination param1 = (ISearchDestination)this.params.get("param1");
            IRecordObject param2 = (IRecordObject)this.params.get("param2");
            remoteClass.write(this.accData, param1, param2);
        } else {
            throw new HandleException("unknown cmd type.");
        }
    }
}

