/*
 * Decompiled with CFR 0.152.
 */
package jp.co.connectone.comm;

import java.util.Date;
import java.util.HashMap;
import jp.co.connectone.comm.CmdBase;
import jp.co.connectone.exception.HandleException;
import jp.co.connectone.store.IObjectIndex;
import jp.co.connectone.store.IRecordObject;
import jp.co.connectone.store.pim.IMemoDTO;
import jp.co.connectone.store.pim.IMemoStore;
import jp.co.connectone.user.IAccountData;

public class MemoStoreCmd
extends CmdBase {
    public static final MemoStoreCmd createNewMemo = new MemoStoreCmd();
    public static final MemoStoreCmd getMemosByDate = new MemoStoreCmd();
    public static final MemoStoreCmd updateMemo = new MemoStoreCmd();
    public static final MemoStoreCmd getMemoByOID = new MemoStoreCmd();
    public static final MemoStoreCmd deleteMemo = new MemoStoreCmd();
    public static final MemoStoreCmd getAllMemos = new MemoStoreCmd();

    protected MemoStoreCmd() {
    }

    public MemoStoreCmd(IAccountData accData, String remoteClassName, CmdBase cmd, HashMap params) {
        super(accData, remoteClassName, cmd, params);
    }

    public int getRetType() throws HandleException {
        try {
            return super.getRetType();
        }
        catch (HandleException handleException) {
            if (this.cmd == deleteMemo || this.cmd == updateMemo) {
                return 0;
            }
            if (this.cmd == getAllMemos || this.cmd == getMemosByDate) {
                return 2;
            }
            if (this.cmd == createNewMemo || this.cmd == getMemoByOID) {
                return 1;
            }
            throw new HandleException("unknown cmd type.");
        }
    }

    public IRecordObject[] runMulti() throws HandleException {
        IRecordObject[] rc = null;
        IMemoStore remoteClass = (IMemoStore)this.getRemoteClass();
        if (this.cmd == getMemosByDate) {
            Date param1 = (Date)this.params.get("param1");
            rc = remoteClass.getMemosByDate(this.accData, param1);
        } else if (this.cmd == getAllMemos) {
            rc = remoteClass.getAllMemos(this.accData);
        } else {
            throw new HandleException("unknown cmd type.");
        }
        return rc;
    }

    public IRecordObject runSingle() throws HandleException {
        IRecordObject rc = null;
        IMemoStore remoteClass = (IMemoStore)this.getRemoteClass();
        if (this.cmd == createNewMemo) {
            IMemoDTO param1 = (IMemoDTO)this.params.get("param1");
            rc = remoteClass.createNewMemo(this.accData, param1);
        } else if (this.cmd == getMemoByOID) {
            IObjectIndex param1 = (IObjectIndex)this.params.get("param1");
            rc = remoteClass.getMemoByOID(this.accData, param1);
        } else {
            throw new HandleException("unknown cmd type.");
        }
        return rc;
    }

    public void runVoid() throws HandleException {
        IMemoStore remoteClass = (IMemoStore)this.getRemoteClass();
        if (this.cmd == deleteMemo) {
            IObjectIndex param1 = (IObjectIndex)this.params.get("param1");
            remoteClass.deleteMemo(this.accData, param1);
        } else if (this.cmd == updateMemo) {
            IMemoDTO param1 = (IMemoDTO)this.params.get("param1");
            remoteClass.updateMemo(this.accData, param1);
        } else {
            throw new HandleException("unknown cmd type.");
        }
    }
}

