/*
 * Decompiled with CFR 0.152.
 */
package jp.co.connectone.comm;

import java.util.Date;
import java.util.HashMap;
import jp.co.connectone.comm.CmdBase;
import jp.co.connectone.exception.HandleException;
import jp.co.connectone.store.BasicRecordObject;
import jp.co.connectone.store.IObjectIndex;
import jp.co.connectone.store.IRecordObject;
import jp.co.connectone.store.ISearchFormula;
import jp.co.connectone.store.pim.IScheduleDTO;
import jp.co.connectone.store.pim.IScheduleStore;
import jp.co.connectone.user.IAccountData;

public class ScheduleStoreCmd
extends CmdBase {
    public static final ScheduleStoreCmd createNewSchedule = new ScheduleStoreCmd();
    public static final ScheduleStoreCmd deleteSchedule = new ScheduleStoreCmd();
    public static final ScheduleStoreCmd getAllSchedules = new ScheduleStoreCmd();
    public static final ScheduleStoreCmd getSchedule = new ScheduleStoreCmd();
    public static final ScheduleStoreCmd getSchedulesByDate = new ScheduleStoreCmd();
    public static final ScheduleStoreCmd isDuplicateSchedule = new ScheduleStoreCmd();
    public static final ScheduleStoreCmd isValidSchedule = new ScheduleStoreCmd();
    public static final ScheduleStoreCmd searchSchedules = new ScheduleStoreCmd();
    public static final ScheduleStoreCmd updateSchedule = new ScheduleStoreCmd();

    protected ScheduleStoreCmd() {
    }

    public ScheduleStoreCmd(IAccountData accData, String remoteClassName, CmdBase cmd, HashMap params) {
        super(accData, remoteClassName, cmd, params);
    }

    public int getRetType() throws HandleException {
        try {
            return super.getRetType();
        }
        catch (HandleException handleException) {
            if (this.cmd == deleteSchedule || this.cmd == updateSchedule) {
                return 0;
            }
            if (this.cmd == searchSchedules || this.cmd == getSchedulesByDate || this.cmd == getAllSchedules) {
                return 2;
            }
            if (this.cmd == createNewSchedule || this.cmd == isDuplicateSchedule || this.cmd == isValidSchedule || this.cmd == getSchedule) {
                return 1;
            }
            throw new HandleException("unknown cmd type.");
        }
    }

    public IRecordObject[] runMulti() throws HandleException {
        IRecordObject[] rc = null;
        IScheduleStore remoteClass = (IScheduleStore)this.getRemoteClass();
        if (this.cmd == searchSchedules) {
            ISearchFormula param1 = (ISearchFormula)this.params.get("param1");
            rc = remoteClass.searchSchedules(this.accData, param1);
        } else if (this.cmd == getSchedulesByDate) {
            Date param1 = (Date)this.params.get("param1");
            rc = remoteClass.getSchedulesByDate(this.accData, param1);
        } else if (this.cmd == getAllSchedules) {
            Date param1 = (Date)this.params.get("param1");
            rc = remoteClass.getAllSchedules(this.accData, param1);
        } else {
            throw new HandleException("unknown cmd type.");
        }
        return rc;
    }

    public IRecordObject runSingle() throws HandleException {
        IRecordObject rc = null;
        IScheduleStore remoteClass = (IScheduleStore)this.getRemoteClass();
        if (this.cmd == createNewSchedule) {
            IScheduleDTO param1 = (IScheduleDTO)this.params.get("param1");
            rc = remoteClass.createNewSchedule(this.accData, param1);
        } else if (this.cmd == getSchedule) {
            IObjectIndex param1 = (IObjectIndex)this.params.get("param1");
            rc = remoteClass.getSchedule(this.accData, param1);
        } else if (this.cmd == isValidSchedule) {
            IScheduleDTO param1 = (IScheduleDTO)this.params.get("param1");
            if (remoteClass.isValidSchedule(this.accData, param1)) {
                rc = new BasicRecordObject();
            }
        } else if (this.cmd == isDuplicateSchedule) {
            IScheduleDTO param1 = (IScheduleDTO)this.params.get("param1");
            if (remoteClass.isDuplicateSchedule(this.accData, param1)) {
                rc = new BasicRecordObject();
            }
        } else {
            throw new HandleException("unknown cmd type.");
        }
        return rc;
    }

    public void runVoid() throws HandleException {
        IScheduleStore remoteClass = (IScheduleStore)this.getRemoteClass();
        if (this.cmd == deleteSchedule) {
            IObjectIndex param1 = (IObjectIndex)this.params.get("param1");
            remoteClass.deleteSchedule(this.accData, param1);
        } else if (this.cmd == updateSchedule) {
            IScheduleDTO param1 = (IScheduleDTO)this.params.get("param1");
            remoteClass.updateSchedule(this.accData, param1);
        } else {
            throw new HandleException("unknown cmd type.");
        }
    }
}

