/*
 * Decompiled with CFR 0.152.
 */
package jp.co.connectone.comm;

import java.util.Date;
import java.util.HashMap;
import jp.co.connectone.comm.CmdBase;
import jp.co.connectone.exception.HandleException;
import jp.co.connectone.store.IObjectIndex;
import jp.co.connectone.store.IRecordObject;
import jp.co.connectone.store.ISearchDestination;
import jp.co.connectone.store.ISearchFormula;
import jp.co.connectone.store.IStore;
import jp.co.connectone.store.pim.IMailStore;
import jp.co.connectone.user.IAccountData;

public class StoreCmd
extends CmdBase {
    public static final StoreCmd getAllDatas = new StoreCmd();
    public static final StoreCmd getFolderList = new StoreCmd();
    public static final StoreCmd searchByDate = new StoreCmd();
    public static final StoreCmd search = new StoreCmd();
    public static final StoreCmd read = new StoreCmd();
    public static final StoreCmd write = new StoreCmd();
    public static final StoreCmd delete = new StoreCmd();

    protected StoreCmd() {
    }

    public StoreCmd(IAccountData accData, String remoteClassName, CmdBase cmd, HashMap params) {
        super(accData, remoteClassName, cmd, params);
    }

    public int getRetType() throws HandleException {
        try {
            return super.getRetType();
        }
        catch (HandleException handleException) {
            if (this.cmd == delete || this.cmd == write) {
                return 0;
            }
            if (this.cmd == getAllDatas || this.cmd == getFolderList || this.cmd == searchByDate || this.cmd == search) {
                return 2;
            }
            if (this.cmd == read) {
                return 1;
            }
            throw new HandleException("unknown cmd type.");
        }
    }

    public IRecordObject[] runMulti() throws Exception {
        IRecordObject[] rc = null;
        IStore remoteClass = this.getRemoteClass();
        if (this.cmd == getAllDatas) {
            ISearchDestination param1 = (ISearchDestination)this.params.get("param1");
            rc = remoteClass.getAllDatas(this.accData, param1);
        } else if (this.cmd == getFolderList) {
            ISearchDestination param1 = (ISearchDestination)this.params.get("param1");
            rc = remoteClass.getFolderList(this.accData, param1);
        } else if (this.cmd == searchByDate) {
            ISearchDestination param1 = (ISearchDestination)this.params.get("param1");
            Date param2 = (Date)this.params.get("param2");
            rc = remoteClass.searchByDate(this.accData, param1, param2);
        } else if (this.cmd == search) {
            ISearchFormula param1 = (ISearchFormula)this.params.get("param1");
            rc = remoteClass.search(this.accData, param1);
        } else {
            throw new HandleException("unknown cmd type.");
        }
        return rc;
    }

    public IRecordObject runSingle() throws Exception {
        IRecordObject rc = null;
        IMailStore remoteClass = (IMailStore)this.getRemoteClass();
        ISearchDestination param1 = (ISearchDestination)this.params.get("param1");
        IObjectIndex param2 = (IObjectIndex)this.params.get("param2");
        if (this.cmd != read) {
            throw new HandleException("unknown cmd type.");
        }
        rc = remoteClass.read(this.accData, param1, param2);
        return rc;
    }

    public void runVoid() throws Exception {
        IStore remoteClass = this.getRemoteClass();
        if (this.cmd == delete) {
            ISearchDestination param1 = (ISearchDestination)this.params.get("param1");
            IObjectIndex param2 = (IObjectIndex)this.params.get("param2");
            remoteClass.delete(this.accData, param1, param2);
        } else if (this.cmd == write) {
            ISearchDestination param1 = (ISearchDestination)this.params.get("param1");
            IRecordObject param2 = (IRecordObject)this.params.get("param2");
            remoteClass.write(this.accData, param1, param2);
        } else {
            throw new HandleException("unknown cmd type.");
        }
    }
}

