/*
 * Decompiled with CFR 0.152.
 */
package jp.co.connectone.pmm;

import java.util.Hashtable;
import java.util.Properties;
import jp.co.connectone.common.PropertyHandlerBaseImpl;
import jp.co.connectone.domain.Domain;
import jp.co.connectone.exception.DataNotFound;
import jp.co.connectone.exception.HandleException;
import jp.co.connectone.pmm.IPmm;
import jp.co.connectone.pmm.UserCacheManager;
import jp.co.connectone.user.BasicUserImpl;
import jp.co.connectone.user.IUser;
import jp.co.connectone.user.IUserKey;

public class SimplePMMImpl
implements IPmm {
    private static final UserCacheManager theManager = new UserCacheManager();
    private static Domain dom;
    private static Properties prop;
    private IUser user;

    static {
        prop = null;
    }

    private SimplePMMImpl(Domain domain) throws DataNotFound {
        if (domain == null) {
            dom = domain;
        }
        this._init();
    }

    public static SimplePMMImpl getInstance(Domain domain) throws DataNotFound {
        SimplePMMImpl rc = new SimplePMMImpl(domain);
        return rc;
    }

    public boolean isUserExist(IUserKey userID) throws Exception {
        System.err.println("SimplePMMImpl.isUserExist:userID=" + userID);
        if (theManager.getUser(userID) == null) {
            System.err.println("user not exist");
            return false;
        }
        System.err.println("user exist");
        return true;
    }

    public boolean initializeUser(IUserKey userID, Hashtable authParams) {
        System.err.println("SimplePMMImpl.initializeUser:userID=" + userID);
        this.user = theManager.getUser(userID);
        if (this.user != null) {
            System.err.println("user exist. check authParam");
            if (authParams == null) {
                if (this.user.getAuthParams() == null) {
                    return true;
                }
                this.user = null;
                return false;
            }
            System.err.println("authParam=" + authParams + ",user.getAuthParams()=" + this.user.getAuthParams());
            if (authParams.equals(this.user.getAuthParams())) {
                System.err.println("equals");
                return true;
            }
        }
        System.err.println("not equals");
        return false;
    }

    private void _init() throws DataNotFound {
        if (prop == null) {
            try {
                prop = PropertyHandlerBaseImpl.getInstance().getProperties("jp.co.connectone.pmm.SimplePMMImpl");
            }
            catch (DataNotFound dnf) {
                dnf.printStackTrace();
                throw dnf;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public IUser createNewUser(IUserKey userID) throws Exception {
        this.user = theManager.getUser(userID);
        if (this.user == null) {
            this.user = BasicUserImpl.getInstance();
            this.user.setKey(userID);
            theManager.addUser(this.user);
        }
        return this.user;
    }

    public void addUser(IUser user) throws Exception {
        this.updateUser(user);
    }

    public void updateUser(IUser user) throws Exception {
        if (user == null) {
            throw new NullPointerException("updateUser:user must not be null");
        }
        IUserKey key = user.getKey();
        if (key == null) {
            throw new HandleException("updateUser:user have not yet initialized with vaild user key");
        }
        theManager.addUser(user);
    }

    public IUser getUser() throws Exception {
        if (this.user == null) {
            throw new HandleException("initialize or create user first.");
        }
        return this.user;
    }
}

