/*
 * Decompiled with CFR 0.152.
 */
package jp.co.connectone.store.client;

import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import jp.co.connectone.store.IObjectIndex;
import jp.co.connectone.store.pim.IScheduleDTO;

public class ScheduleParseHelper {
    private String tid;
    protected IScheduleDTO schedule = null;
    protected Calendar cal = null;
    protected static final String[] dayOfWeek = new String[]{"", "\u65e5", "\u6708", "\u706b", "\u6c34", "\u6728", "\u91d1", "\u571f"};

    public ScheduleParseHelper() {
        this.cal = Calendar.getInstance(Locale.JAPAN);
    }

    public ScheduleParseHelper(IScheduleDTO sche) {
        System.err.println("ScheduleParseHelper:initialDTO=" + sche);
        this.cal = Calendar.getInstance(Locale.JAPAN);
        this.schedule = sche;
    }

    public void setScheduleDTO(IScheduleDTO sche) {
        this.schedule = sche;
    }

    public IScheduleDTO getScheduleDTO() {
        return this.schedule;
    }

    public void setUserId(String userId) {
        this.schedule.setUserId(userId);
    }

    public void setSubject(String subject) {
        this.schedule.setSubject(subject);
    }

    public void setBody(String body) {
        String[] description = new String[]{body};
        this.schedule.setBody(body);
    }

    public void setStartDate(int year, int month, int dayOfWeek, int hour, int minutes) {
        this.cal.set(year, month, dayOfWeek, hour, minutes);
        this.schedule.setStartDate(this.cal.getTime());
    }

    public void setEndDate(int year, int month, int dayOfWeek, int hour, int minutes) {
        this.cal.set(year, month, dayOfWeek, hour, minutes);
        this.schedule.setEndDate(this.cal.getTime());
    }

    public void setStartDate(Date startDate) {
        this.schedule.setStartDate(startDate);
    }

    public void setEndDate(Date endDate) {
        this.schedule.setEndDate(endDate);
    }

    public void setLocation(String location) {
        this.schedule.setLocation(location);
    }

    public String getUserId() {
        return this.schedule.getUserId();
    }

    public String getSubject() {
        return this.schedule.getSubject();
    }

    public String getBody() {
        return this.schedule.getBody();
    }

    public Date getStartDate() {
        return this.schedule.getStartDate();
    }

    public int getStartYear() {
        this.cal.setTime(this.schedule.getStartDate());
        return this.cal.get(1);
    }

    public int getStartMonth() {
        this.cal.setTime(this.schedule.getStartDate());
        return this.cal.get(2);
    }

    public int getStartDayOfMonth() {
        this.cal.setTime(this.schedule.getStartDate());
        return this.cal.get(5);
    }

    public String getStartDayOfWeek() {
        this.cal.setTime(this.schedule.getStartDate());
        int d = this.cal.get(7);
        return dayOfWeek[d];
    }

    public int getStartHour() {
        this.cal.setTime(this.schedule.getStartDate());
        return this.cal.get(11);
    }

    public int getStartMinute() {
        this.cal.setTime(this.schedule.getStartDate());
        return this.cal.get(12);
    }

    public Date getEndDate() {
        return this.schedule.getEndDate();
    }

    public int getEndYear() {
        this.cal.setTime(this.schedule.getEndDate());
        return this.cal.get(1);
    }

    public int getEndMonth() {
        this.cal.setTime(this.schedule.getEndDate());
        return this.cal.get(2);
    }

    public int getEndDayOfMonth() {
        this.cal.setTime(this.schedule.getEndDate());
        return this.cal.get(5);
    }

    public String getEndDayOfWeek() {
        this.cal.setTime(this.schedule.getEndDate());
        int d = this.cal.get(7);
        return dayOfWeek[d];
    }

    public int getEndHour() {
        this.cal.setTime(this.schedule.getEndDate());
        return this.cal.get(11);
    }

    public int getEndMinute() {
        this.cal.setTime(this.schedule.getEndDate());
        return this.cal.get(12);
    }

    public String getLocation() {
        return this.schedule.getLocation();
    }

    public Object getOid() {
        return this.schedule.getOid();
    }

    public void setOid(IObjectIndex oid) {
        this.schedule.setOid(oid);
    }

    public String getTid() {
        return this.tid;
    }

    public void setTid(String tid) {
        this.tid = tid;
    }
}

