/*
 * Decompiled with CFR 0.152.
 */
package jp.co.connectone.store.client;

import java.util.Date;
import java.util.HashMap;
import jp.co.connectone.comm.ScheduleStoreCmd;
import jp.co.connectone.store.IObjectIndex;
import jp.co.connectone.store.IRecordObject;
import jp.co.connectone.store.ISearchFormula;
import jp.co.connectone.store.client.IScheduleStoreClient;
import jp.co.connectone.store.client.StoreClient;
import jp.co.connectone.store.pim.IScheduleDTO;

public class ScheduleStoreClient
extends StoreClient
implements IScheduleStoreClient {
    public IRecordObject createNewSchedule(IScheduleDTO scheduleDTO) throws Exception {
        HashMap<String, IScheduleDTO> params = new HashMap<String, IScheduleDTO>();
        params.put("param1", scheduleDTO);
        ScheduleStoreCmd cmd = new ScheduleStoreCmd(this.userAccount, this.remoteClassName, ScheduleStoreCmd.createNewSchedule, params);
        this.protocol.functionCall(cmd);
        IRecordObject ret = this.protocol.getReturnSingle();
        return ret;
    }

    public void deleteSchedule(IObjectIndex oid) throws Exception {
        HashMap<String, IObjectIndex> params = new HashMap<String, IObjectIndex>();
        params.put("param1", oid);
        ScheduleStoreCmd cmd = new ScheduleStoreCmd(this.userAccount, this.remoteClassName, ScheduleStoreCmd.deleteSchedule, params);
        this.protocol.functionCall(cmd);
    }

    public IScheduleDTO[] getAllSchedules(Date cutOffDate) throws Exception {
        HashMap<String, Date> params = new HashMap<String, Date>();
        params.put("param1", cutOffDate);
        ScheduleStoreCmd cmd = new ScheduleStoreCmd(this.userAccount, this.remoteClassName, ScheduleStoreCmd.getAllSchedules, params);
        this.protocol.functionCall(cmd);
        IScheduleDTO[] ret = (IScheduleDTO[])this.protocol.getReturnMulti();
        return ret;
    }

    public IScheduleDTO getSchedule(IObjectIndex oid) throws Exception {
        HashMap<String, IObjectIndex> params = new HashMap<String, IObjectIndex>();
        params.put("param1", oid);
        ScheduleStoreCmd cmd = new ScheduleStoreCmd(this.userAccount, this.remoteClassName, ScheduleStoreCmd.getSchedule, params);
        this.protocol.functionCall(cmd);
        IScheduleDTO ret = (IScheduleDTO)this.protocol.getReturnSingle();
        return ret;
    }

    public IScheduleDTO[] getSchedulesByDate(Date dateObj) throws Exception {
        HashMap<String, Date> params = new HashMap<String, Date>();
        params.put("param1", dateObj);
        ScheduleStoreCmd cmd = new ScheduleStoreCmd(this.userAccount, this.remoteClassName, ScheduleStoreCmd.getSchedulesByDate, params);
        this.protocol.functionCall(cmd);
        IScheduleDTO[] ret = (IScheduleDTO[])this.protocol.getReturnMulti();
        return ret;
    }

    public boolean isDuplicateSchedule(IScheduleDTO scheduleDTO) throws Exception {
        HashMap<String, IScheduleDTO> params = new HashMap<String, IScheduleDTO>();
        params.put("param1", scheduleDTO);
        ScheduleStoreCmd cmd = new ScheduleStoreCmd(this.userAccount, this.remoteClassName, ScheduleStoreCmd.isDuplicateSchedule, params);
        this.protocol.functionCall(cmd);
        IRecordObject ret = this.protocol.getReturnSingle();
        return ret != null;
    }

    public boolean isValidSchedule(IScheduleDTO scheduleDTO) throws Exception {
        HashMap<String, IScheduleDTO> params = new HashMap<String, IScheduleDTO>();
        params.put("param1", scheduleDTO);
        ScheduleStoreCmd cmd = new ScheduleStoreCmd(this.userAccount, this.remoteClassName, ScheduleStoreCmd.isValidSchedule, params);
        this.protocol.functionCall(cmd);
        IRecordObject ret = this.protocol.getReturnSingle();
        return ret != null;
    }

    public IScheduleDTO[] searchSchedules(ISearchFormula conds) throws Exception {
        HashMap<String, ISearchFormula> params = new HashMap<String, ISearchFormula>();
        params.put("param1", conds);
        ScheduleStoreCmd cmd = new ScheduleStoreCmd(this.userAccount, this.remoteClassName, ScheduleStoreCmd.searchSchedules, params);
        this.protocol.functionCall(cmd);
        IScheduleDTO[] ret = (IScheduleDTO[])this.protocol.getReturnMulti();
        return ret;
    }

    public void updateSchedule(IScheduleDTO objScheduleDTO) throws Exception {
        HashMap<String, IScheduleDTO> params = new HashMap<String, IScheduleDTO>();
        params.put("param1", objScheduleDTO);
        ScheduleStoreCmd cmd = new ScheduleStoreCmd(this.userAccount, this.remoteClassName, ScheduleStoreCmd.updateSchedule, params);
        this.protocol.functionCall(cmd);
    }
}

