/*
 * Decompiled with CFR 0.152.
 */
package jp.co.connectone.comm;

import java.util.HashMap;
import jp.co.connectone.comm.ICmd;
import jp.co.connectone.exception.HandleException;
import jp.co.connectone.store.BasicRecordObject;
import jp.co.connectone.store.IRecordObject;
import jp.co.connectone.store.IStore;
import jp.co.connectone.user.IAccountData;

public class CmdBase
implements ICmd {
    protected ICmd cmd = null;
    protected String remoteClassName = null;
    protected IAccountData accData = null;
    protected HashMap params;
    public static final CmdBase getStoreID = new CmdBase();
    public static final CmdBase getStoreType = new CmdBase();
    public static final CmdBase getServerInfo = new CmdBase();
    public static final CmdBase getName = new CmdBase();
    public static final CmdBase getgetFolderIndexFromString = new CmdBase();
    public static final CmdBase getPresetDestination = new CmdBase();

    protected CmdBase() {
    }

    public CmdBase(IAccountData accData, String remoteClassName, CmdBase cmd, HashMap params) {
        this.remoteClassName = remoteClassName;
        this.cmd = cmd;
        this.accData = accData;
        this.params = params;
    }

    public IRecordObject[] runMulti() throws Exception {
        throw new HandleException("unknown cmd type.");
    }

    protected IStore getRemoteClass() throws HandleException {
        IStore remoteClass = null;
        try {
            remoteClass = (IStore)Class.forName(this.remoteClassName).newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HandleException("err creating remote class " + this.remoteClassName);
        }
        return remoteClass;
    }

    public IRecordObject runSingle() throws Exception {
        IStore remoteClass = this.getRemoteClass();
        IRecordObject rc = null;
        if (this.cmd == getStoreID) {
            rc = remoteClass.getStoreID();
        } else if (this.cmd == getName) {
            rc = new BasicRecordObject();
            HashMap<String, String> h = new HashMap<String, String>();
            h.put("name", remoteClass.getName());
            rc.setFieldSet(h);
        } else if (this.cmd == getgetFolderIndexFromString) {
            String param1 = (String)this.params.get("param1");
            rc = remoteClass.getFolderIndexFromString(param1);
        } else if (this.cmd == getStoreType) {
            rc = remoteClass.getStoreType();
        } else if (this.cmd == getServerInfo) {
            rc = remoteClass.getServiceInfo();
        } else if (this.cmd == getPresetDestination) {
            Integer param1 = (Integer)this.params.get("param1");
            rc = remoteClass.getPresetDestination(this.accData, param1);
        } else {
            throw new HandleException("unknown cmd type.");
        }
        return rc;
    }

    public int getRetType() throws HandleException {
        if (this.cmd == getPresetDestination || this.cmd == getStoreID || this.cmd == getStoreType || this.cmd == getServerInfo || this.cmd == getName || this.cmd == getgetFolderIndexFromString) {
            return 1;
        }
        throw new HandleException("unknown cmd type.");
    }

    public void runVoid() throws Exception {
        throw new HandleException("unknown cmd type.");
    }
}

