/*
 * Decompiled with CFR 0.152.
 */
package jp.co.connectone.domain;

import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import jp.co.connectone.common.PropertyHandlerBaseImpl;
import jp.co.connectone.domain.IDomain;
import jp.co.connectone.domain.IinnerExm;
import jp.co.connectone.domain.SimpleDomainDataProvider;
import jp.co.connectone.domain.TopDomain;
import jp.co.connectone.exception.DataNotFound;
import jp.co.connectone.exception.HandleException;
import jp.co.connectone.exm.IExM;
import jp.co.connectone.pmm.IPmm;

public class Domain
implements IDomain {
    protected String domainName;
    protected SimpleDomainDataProvider provider;
    protected static TopDomain theTop;
    protected static Properties prop;
    protected IExM exm;
    protected IPmm pmm;

    protected void _init() throws DataNotFound, HandleException {
        if (prop == null) {
            try {
                prop = PropertyHandlerBaseImpl.getInstance().getProperties("jp.co.connectone.domain.Domain");
            }
            catch (DataNotFound dnf) {
                throw dnf;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        String providerName = prop.getProperty("providerClass");
        try {
            Class<?> providerClass = Class.forName(providerName);
            this.provider = (SimpleDomainDataProvider)providerClass.getMethod("getInstance", null).invoke(null, null);
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
            throw new HandleException("error on getting IProvider class");
        }
        catch (NoSuchMethodException nsme) {
            nsme.printStackTrace();
            throw new HandleException("could not find getInstance method of IProvider class");
        }
        catch (InvocationTargetException ite) {
            ite.printStackTrace();
            throw new HandleException("error on invoke getInstance method of IProvider class");
        }
        catch (IllegalAccessException iae) {
            throw new HandleException("IllegalAccessException on invoke getInstance method of IProvider class");
        }
        if (this.domainName != null) {
            String classname = this.provider.getPmmClassname(this.domainName);
            try {
                Class[] paramType = new Class[]{this.getClass()};
                Object[] param = new Domain[]{this};
                this.pmm = (IPmm)Class.forName(classname).getMethod("getInstance", paramType).invoke(null, param);
            }
            catch (ClassNotFoundException cne) {
                cne.printStackTrace();
            }
            catch (InvocationTargetException ie) {
                ie.printStackTrace();
            }
            catch (NoSuchMethodException nsme) {
                nsme.printStackTrace();
            }
            catch (IllegalAccessException iae) {
                iae.printStackTrace();
            }
        }
    }

    protected Domain() throws DataNotFound, HandleException {
        this._init();
    }

    Domain(SimpleDomainDataProvider provider, String domainName) throws DataNotFound, HandleException {
        this.provider = provider;
        this.domainName = domainName;
        this._init();
    }

    public TopDomain getTopDomain() {
        return theTop;
    }

    public String getDomainName() {
        return this.domainName;
    }

    protected void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public IDomain getDomain(String domainName) throws DataNotFound, HandleException {
        if (!this.provider.searchDomainByName(domainName)) {
            return null;
        }
        return new Domain(this.provider, domainName);
    }

    public IPmm getPMM() {
        return this.pmm;
    }

    public IExM getPrimaryExM() {
        IinnerExm ret;
        System.err.println("getPrimaryExM");
        String classname = this.provider.getExmClassname(this.pmm);
        System.err.println("EXM_classname:" + classname);
        try {
            ret = (IinnerExm)Class.forName(classname).newInstance();
            ret.setPMM(this.pmm);
        }
        catch (ClassNotFoundException cne) {
            cne.printStackTrace();
            return null;
        }
        catch (InstantiationException ie) {
            ie.printStackTrace();
            return null;
        }
        catch (IllegalAccessException iae) {
            iae.printStackTrace();
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return ret;
    }
}

