/*
 * Decompiled with CFR 0.152.
 */
package jp.co.connectone.store.pim;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Date;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import jp.co.connectone.store.BasicRecordObject;
import jp.co.connectone.store.IObjectIndex;
import jp.co.connectone.store.client.AttachmentDataSource;
import jp.co.connectone.store.pim.AttachmentDTO;
import jp.co.connectone.store.pim.HeaderDTO;
import jp.co.connectone.store.pim.IMailDTO;
import jp.co.connectone.store.pim.MailAddress;

public class BasicMailDTO
extends BasicRecordObject
implements IMailDTO {
    protected HeaderDTO header = null;
    protected String body = null;
    protected AttachmentDTO[] attachments = null;

    public BasicMailDTO() {
        this.header = null;
    }

    public BasicMailDTO(HeaderDTO header) {
        this.header = header;
    }

    public MailAddress[] getBCC() {
        return this.header.getHeaderBCC();
    }

    public MailAddress[] getCC() {
        return this.header.getHeaderCC();
    }

    public MailAddress getFrom() {
        return this.header.getHeaderFrom();
    }

    public int getPriority() {
        return this.header.getHeaderPriority();
    }

    public MailAddress getReplyTo() {
        return this.header.getHeaderReplyTo();
    }

    public Date getSentDate() {
        return this.header.getHeaderSendDate();
    }

    public Date getReceivedDate() {
        return this.header.getHeaderReceivedDate();
    }

    public int getSize() {
        return this.header.getHeaderSize();
    }

    public String getSubject() {
        return this.header.getHeaderSubject();
    }

    public MailAddress[] getTo() {
        return this.header.getHeaderTo();
    }

    public void setBCC(MailAddress[] bcc) {
        this.header.setHeaderBCC(bcc);
    }

    public void setCC(MailAddress[] cc) {
        this.header.setHeaderCC(cc);
    }

    public void setFrom(MailAddress from) {
        this.header.setHeaderFrom(from);
    }

    public void setPriority(int priority) {
        this.header.setHeaderPriority(priority);
    }

    public void setReplyTo(MailAddress replyTo) {
        this.header.setHeaderReplyTo(replyTo);
    }

    public void setSentDate(Date date) {
        this.header.setHeaderSendDate(date);
    }

    public void setSize(int size) {
        this.header.setHeaderSize(size);
    }

    public void setSubject(String subject) {
        this.header.setHeaderSubject(subject);
    }

    public void setTo(MailAddress[] to) {
        this.header.setHeaderTo(to);
    }

    public String getBody() {
        return this.body;
    }

    public int getNumberOfAttachments() {
        if (this.attachments == null) {
            return 0;
        }
        return this.attachments.length;
    }

    public AttachmentDTO getAttachment(int number) {
        return this.attachments[number];
    }

    public HeaderDTO getHeader() {
        return this.header;
    }

    public String getMailBinary() {
        String rc = "";
        if (this.attachments == null) {
            return this.body;
        }
        try {
            String tmp;
            MimeMessage msg = new MimeMessage(null);
            MimeMultipart part = new MimeMultipart();
            MimeBodyPart body = new MimeBodyPart();
            body.setText(this.body);
            part.addBodyPart((BodyPart)body);
            int i = 0;
            while (i < this.attachments.length) {
                MimeBodyPart attach = new MimeBodyPart();
                attach.setDataHandler(new DataHandler((DataSource)new AttachmentDataSource(this.attachments[i])));
                attach.setFileName(this.attachments[i].getFileName());
                part.addBodyPart((BodyPart)attach);
                ++i;
            }
            msg.setContent((Multipart)part);
            msg.saveChanges();
            rc = "MIME-Version: 1.0\r\nContent-Type: " + msg.getHeader("Content-Type", null) + "\r\n\r\n";
            InputStream is = msg.getInputStream();
            BufferedReader b = new BufferedReader(new InputStreamReader(is));
            while ((tmp = b.readLine()) != null) {
                rc = String.valueOf(rc) + tmp + "\n";
            }
        }
        catch (Exception e) {
            System.err.println("Exception on creating MimeMessage");
        }
        return rc;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public void setHeaderDTO(HeaderDTO header) {
        this.header = header;
    }

    public void setAttachments(AttachmentDTO[] attachments) {
        this.attachments = attachments;
    }

    public AttachmentDTO[] getAttachments() {
        return this.attachments;
    }

    public String toString() {
        String rc = super.toString();
        if (this.header != null) {
            rc = String.valueOf(rc) + ":" + this.header.getHeaderUIDL() + ":" + this.header.getHeaderSubject();
        }
        if (this.getNumberOfAttachments() > 0) {
            rc = String.valueOf(rc) + " attachments:" + this.getNumberOfAttachments();
        }
        return rc;
    }

    public IObjectIndex getOid() {
        if (this.header == null) {
            return null;
        }
        return this.header.getOid();
    }

    public void setOid(IObjectIndex oid) {
        if (this.header == null) {
            this.header = new HeaderDTO();
        }
        this.header.setOid(oid);
    }
}

