package jp.cssj.cti.helpers;

/**
 * @author <a href="mailto:miyabe at gnn.co.jp">MIYABE Tatsuhiko </a>
 * @version $Id: StdioErrorHandler.java,v 1.3 2005/09/06 22:13:47 harumanx Exp $
 */
public final class StdioErrorHandler extends ErrorHandler {
	private static StdioErrorHandler instance = null;

	public static StdioErrorHandler getInstance() {
		if (instance == null) {
			instance = new StdioErrorHandler();
		}
		return instance;
	}

	private StdioErrorHandler() {
		// singleton
	}

	public void message(byte level, String message) {
		switch (level) {
		case WARN:
			System.out.println("xF" + message);
			break;

		case ERROR:
			System.out.println("G[F" + message);
			break;

		case FATAL:
			System.out.println("fF" + message);
			break;

		case INFO:
			System.out.println("F" + message);
			break;
		}
	}
}