package jp.cssj.cti.examples;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;

import jp.cssj.cti.CTIDriver;
import jp.cssj.cti.CTIDriverManager;
import jp.cssj.cti.CTISession;
import jp.cssj.cti.CTIUtils;
import jp.cssj.cti.helpers.StdioErrorHandler;

/**
 * NCAgɒuꂽt@Cϊ܂B
 */
public class ClientResource {
	/** ڑ̃zXgB */
	private static final String HOST = "localhost";

	/** ڑ̃|[gԍB */
	private static final int PORT = 8099;

	/** pX[hB */
	private static final String PASSWORD = "kappa";

	public static void main(String[] args) throws Exception {
		// hCo擾
		CTIDriver driver = CTIDriverManager.createDriverFor(HOST, PORT);
		// ڑ([U["user"ŌŒ)
		CTISession session = driver.createSession("user", PASSWORD);
		try {
			// test.pdfɌʂo͂
			OutputStream out = new BufferedOutputStream(new FileOutputStream(
					"test.pdf"));
			try {
				session.setOutput(out, "application/pdf");
				// G[bZ[WWo͂ɕ\
				session.setErrorHandler(StdioErrorHandler.getInstance());

				// Ytt@C
				File file = new File("test/test.gif");
				session.setProperty("output.pdf.attachments.0.uri", file
						.toURI().toASCIIString());
				session
						.setProperty("output.pdf.attachments.0.name",
								"cssj.gif");
				session.setProperty("output.pdf.attachments.0.description",
						"CSSJ̃S");
				CTIUtils.sendResourceFile(session, file, "image/gif", null);

				// X^CV[g𑗂
				// MIME^text/css,LN^EGR[fBO͏ȗ
				CTIUtils.sendResourceFile(session, new File("test/test.css"),
						"text/css", null);

				// HTMLt@C𑗂
				// MIME^text/html,LN^EGR[fBO͏ȗ
				CTIUtils.sendMainFile(session, new File("test/test.html"),
						"text/html", null);
			} finally {
				out.close();
			}
		} finally {
			// ZbV(Y₷̂Œ!)
			session.close();
		}
	}
}