<%@ page language="java" contentType="text/html; charset=Shift_JIS"
         import="java.math.BigDecimal,java.util.ArrayList,java.text.DateFormat,java.text.NumberFormat,java.util.Date" %>
<%!
    static String escape(String str) {
      return str.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }
%>
<%
    DateFormat dateFormat = DateFormat.getDateInstance();
    String date = dateFormat.format(new Date(System.currentTimeMillis()));
    request.setCharacterEncoding("Shift_JIS");

	String senderPostalCode = escape(request.getParameter("senderPostalCode"));
    String senderAddress1 = escape(request.getParameter("senderAddress1"));
    String senderAddress2 = escape(request.getParameter("senderAddress2"));
    String senderAddress3 = escape(request.getParameter("senderAddress3"));
    String senderPhone = escape(request.getParameter("senderPhone"));
    String senderFax = escape(request.getParameter("senderFax"));
    String senderName = escape(request.getParameter("senderName"));

	String receiverPostalCode = escape(request.getParameter("receiverPostalCode"));
    String receiverAddress1 = escape(request.getParameter("receiverAddress1"));
    String receiverAddress2 = escape(request.getParameter("receiverAddress2"));
    String receiverAddress3 = escape(request.getParameter("receiverAddress3"));
    String receiverPhone = escape(request.getParameter("receiverPhone"));
    String receiverFax = escape(request.getParameter("receiverFax"));
    String receiverName = escape(request.getParameter("receiverName"));

    class Item {
      final String name;
      final BigDecimal unitPrice;
      final int quantity;

      Item(String name, BigDecimal unitPrice, int quantity) {
        this.name = name;
        this.unitPrice = unitPrice;
        this.quantity = quantity;
      }
    }
    ArrayList items = new ArrayList();

    for (int i = 0; ; ++i) {
      String prefix = "item["+i+"].";
      String name = request.getParameter(prefix+"name");
      if (name == null) {
        break;
      }
      if (name.length() == 0) {
        continue;
      }
      String quantityS = request.getParameter(prefix+"quantity");
      String unitPriceS = request.getParameter(prefix+"unitPrice");
      int quantity;
      try {
        quantity = Integer.parseInt(quantityS);
      } catch (Exception e) {
        quantity = 0;
      }
      BigDecimal unitPrice;
      try {
        unitPrice = new BigDecimal(unitPriceS);
      } catch (Exception e) {
        unitPrice = new BigDecimal(0);
      }
      items.add(new Item(escape(name), unitPrice, quantity));
    }

    NumberFormat moneyFormat = NumberFormat.getNumberInstance();
%>
<html>
<head>
<title>[i̎</title>
<style type="text/css">
@import url(/resources/skin.css);
</style>
</head>
<body>
<h1>
[i
</h1>
<div class="date">
<%= date %>
</div>
<div class="receiver">
<div> <%= receiverPostalCode %></div>
<div><%= receiverAddress1 %><%= receiverAddress2 %></div>
<div><%= receiverAddress3 %></div>
<div>TEL <%= receiverPhone %></div>
<div>FAX <%= receiverFax %></div>
<div class="name">
<span><%= receiverName %></span> 䒆
</div>
</div>
<div class="sender">
<div> <%= senderPostalCode %></div>
<div><%= senderAddress1 %><%= senderAddress2 %></div>
<div><%= senderAddress3 %></div>
<div>TEL <%= senderPhone %></div>
<div>FAX <%= senderFax %></div>
<div class="name"><%= senderName %><span></span></div>
</div>
<div>
<div class="text">L̒ʂ[i܂B</div>
<table>
  <thead>
    <tr>
      <th width="70%">i</th>
      <th width="10%"></th>
      <th width="10%">P</th>
      <th width="10%">z</th>
    </tr>
  </thead>
  <tbody>
    <%
      BigDecimal total = new BigDecimal("0");
      for (int i = 0; i < items.size(); ++i) {
         Item item = (Item)items.get(i);
         BigDecimal subtotal = item.unitPrice.multiply(new BigDecimal(item.quantity));
    %>
    <tr>
      <td><%= item.name %></td>
      <td><%= item.quantity %></td>
      <td><%= moneyFormat.format(item.unitPrice) %></td>
      <td><%= moneyFormat.format(subtotal) %></td>
    </tr>
    <%
        total = total.add(subtotal);
      }
      BigDecimal tax = new BigDecimal(total.multiply(new BigDecimal(0.05)).toBigInteger());
    %>
  </tbody>
  <tbody class="total">
    <tr>
      <td colspan="2"></td>
      <td>v</td>
      <td><%= moneyFormat.format(total) %></td>
    </tr>
    <tr>
      <td colspan="2"></td>
      <td></td>
      <td><%= moneyFormat.format(tax) %></td>
    </tr>
    <tr>
      <td colspan="2"></td>
      <td>v</td>
      <td><%= moneyFormat.format(total = total.add(tax)) %></td>
    </tr>
  </tbody>
</table>

<h1>̎</h1>
<div class="date">
<%= date %>
</div>
<div class="receiver">
<div> <%= receiverPostalCode %></div>
<div><%= receiverAddress1 %><%= receiverAddress2 %></div>
<div><%= receiverAddress3 %></div>
<div>TEL <%= receiverPhone %></div>
<div>FAX <%= receiverFax %></div>
<div class="name">
<span><%= receiverName %></span> 䒆
</div>
</div>
<div class="sender">
<div> <%= senderPostalCode %></div>
<div><%= senderAddress1 %><%= senderAddress2 %></div>
<div><%= senderAddress3 %></div>
<div>TEL <%= senderPhone %></div>
<div>FAX <%= senderFax %></div>
<div class="name"><%= senderName %><span></span></div>
</div>
<div>
<div class="text">L̋z̎܂B</div>
<span class="total"><%= moneyFormat.format(total) %> ~</span>
</div>
</body>
</html>
