#!/usr/bin/perl
=head1 NAME

クライアント側リソース変換サンプル

=head2 概要

test.css,test.htmlを変換します。

=cut
use strict;
use lib '../code';
use CSSJ::Driver;

print "Content-Type: application/pdf\n";

my $driver = CSSJ::Driver::create_driver_for('localhost', 8099, 'UTF-8');
my $session = $driver->create_session('user', 'kappa');
$session->set_property('output.pdf.compression', 'ascii');
$session->set_content_length_func (sub {
	my $length = shift;
	print "Content-Length: $length\n\n";
	binmode(STDOUT);
});

$session->start_resource(*STDOUT, 'file:/test.css');
open(RFP, '<test.css');
while (<RFP>) {print};
close(RFP);
$session->end_resource(*STDOUT);

$session->start_main(*STDOUT, 'file:/test.html');
open(MFP, '<test.html');
while (<MFP>) {print};
close(MFP);
$session->end_main(*STDOUT);

$session->close();
