/*
 * Decompiled with CFR 0.152.
 */
package jp.cssj.resolver.restricted;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import jp.cssj.resolver.Source;
import jp.cssj.resolver.SourceResolver;
import jp.cssj.resolver.restricted.WildcardHelper;

public class RestrictedSourceResolver
implements SourceResolver {
    private SourceResolver enclosedSourceResolver;
    private final List acl = new ArrayList();
    static final /* synthetic */ boolean $assertionsDisabled;

    public RestrictedSourceResolver(SourceResolver enclosedSourceResolver) {
        this.enclosedSourceResolver = enclosedSourceResolver;
    }

    public RestrictedSourceResolver() {
        this(null);
    }

    public void include(URI uriPattern) {
        this.acl.add(new Pattern(true, WildcardHelper.compilePattern(uriPattern.normalize().toString())));
    }

    public void exclude(URI uriPattern) {
        this.acl.add(new Pattern(false, WildcardHelper.compilePattern(uriPattern.normalize().toString())));
    }

    public Source resolve(URI uri) throws IOException, SecurityException {
        return this.resolve(uri, false);
    }

    public Source resolve(URI uri, boolean force) throws IOException, SecurityException {
        uri = uri.normalize();
        String uriStr = uri.toString();
        if (force) {
            if (this.enclosedSourceResolver == null) {
                throw new FileNotFoundException(uriStr);
            }
            return this.enclosedSourceResolver.resolve(uri);
        }
        for (int i = 0; i < this.acl.size(); ++i) {
            Pattern pattern = (Pattern)this.acl.get(i);
            if (!WildcardHelper.match(uriStr, pattern.pattern)) continue;
            if (pattern.permit) {
                if (this.enclosedSourceResolver == null) {
                    throw new FileNotFoundException(uriStr);
                }
                return this.enclosedSourceResolver.resolve(uri);
            }
            throw new SecurityException(uriStr);
        }
        if ("data".equals(uri.getScheme())) {
            return this.enclosedSourceResolver.resolve(uri);
        }
        throw new SecurityException(uriStr);
    }

    public void release(Source source) {
        if (!$assertionsDisabled && this.enclosedSourceResolver == null) {
            throw new AssertionError();
        }
        this.enclosedSourceResolver.release(source);
    }

    public SourceResolver getEnclosedSourceResolver() {
        return this.enclosedSourceResolver;
    }

    public void setEnclosedSourceResolver(SourceResolver enclosedSourceResolver) {
        this.enclosedSourceResolver = enclosedSourceResolver;
    }

    public void reset() {
        this.enclosedSourceResolver = null;
        this.acl.clear();
    }

    static {
        $assertionsDisabled = !RestrictedSourceResolver.class.desiredAssertionStatus();
    }

    protected static class Pattern {
        public final boolean permit;
        public final int[] pattern;

        public Pattern(boolean permit, int[] pattern) {
            this.permit = permit;
            this.pattern = pattern;
        }
    }
}

