/*
 * Decompiled with CFR 0.152.
 */
package jp.cssj.cti2.examples;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.cssj.cti2.CTIDriverManager;
import jp.cssj.cti2.CTISession;
import jp.cssj.cti2.helpers.CTIHttpServletResponseWrapper;
import jp.cssj.cti2.helpers.ServletHelper;
import jp.cssj.resolver.Source;
import jp.cssj.resolver.SourceResolver;
import jp.cssj.resolver.url.URLSource;

public class SampleFilter
implements Filter {
    private static final URI SERVER_URI = URI.create("ctip://127.0.0.1:8099/");
    private static final String USER = "user";
    private static final String PASSWORD = "kappa";
    private FilterConfig config;

    public void init(FilterConfig config) throws ServletException {
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest _req, ServletResponse _res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)_req;
        HttpServletResponse res = (HttpServletResponse)_res;
        CTISession session = CTIDriverManager.getSession(SERVER_URI, USER, PASSWORD);
        try {
            ServletHelper.setServletResponse(session, (ServletResponse)res);
            session.setSourceResolver(new ServletContextResolver(this.config.getServletContext()));
            URI uri = URI.create(req.getRequestURI().substring(req.getContextPath().length()));
            CTIHttpServletResponseWrapper ctiRes = new CTIHttpServletResponseWrapper(res, session, uri);
            try {
                chain.doFilter((ServletRequest)req, (ServletResponse)ctiRes);
            }
            finally {
                ctiRes.close();
            }
        }
        finally {
            session.close();
        }
    }

    public void destroy() {
    }

    static class ServletContextResolver
    implements SourceResolver {
        protected final ServletContext context;

        public ServletContextResolver(ServletContext context) {
            this.context = context;
        }

        public Source resolve(URI uri) throws IOException {
            URL url = this.context.getResource(uri.toString());
            if (url == null) {
                throw new FileNotFoundException(uri.toString());
            }
            try {
                return new URLSource(url);
            }
            catch (URISyntaxException e) {
                IOException ioe = new IOException();
                ioe.initCause(e);
                throw ioe;
            }
        }

        public void release(Source source) {
            ((URLSource)source).close();
        }
    }
}

