package jp.cssj.cti2.examples;

import java.io.File;
import java.net.URI;

import jp.cssj.cti2.CTIDriverManager;
import jp.cssj.cti2.CTISession;
import jp.cssj.cti2.helpers.CTISessionHelper;

/**
 * クライアントから送ったデータを変換します。
 */
public class Continuous {
	/** 接続先。 */
	private static final URI SERVER_URI = URI.create("ctip://neko:8101/");

	/** ユーザー。 */
	private static final String USER = "user";

	/** パスワード。 */
	private static final String PASSWORD = "kappa";

	public static void main(String[] args) throws Exception {
		// 接続する
		CTISession session = CTIDriverManager.getSession(SERVER_URI, USER,
				PASSWORD);
		try {
			// test.pdfに結果を出力する
			File file = new File("test.pdf");
			CTISessionHelper.setResultFile(session, file);
			session.property("processing.pass-count", "2");
			session.setContinuous(true);

			// リソースの送信
			CTISessionHelper.sendResourceFile(session, new File(
					"examples/files/test.css"), "text/css", null);

			// 文書の送信
			CTISessionHelper.transcodeFile(session, new File(
					"examples/files/test.html"), "text/html", null);

			// 文書の送信
			CTISessionHelper.transcodeFile(session, new File(
					"examples/files/test.html"), "text/html", null);

			// 結果を結合
			session.join();
		} finally {
			// セッションを閉じる(忘れやすいので注意!)
			session.close();
		}
	}
}