/*
 * Decompiled with CFR 0.152.
 */
package jp.cssj.resolver.helpers;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.BitSet;

public final class URIHelper {
    private static final char[] HEX;
    private static BitSet SAFE_CHARS;
    private static final boolean WINDOWS;
    public static final URI CURRENT_URI;

    private URIHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String filter(String encoding, String uri) {
        uri = uri.trim();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            Charset cs = Charset.forName(encoding);
            CharsetEncoder enc = cs.canEncode() ? cs.newEncoder() : Charset.forName("UTF-8").newEncoder();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, enc);
            try {
                for (int i = 0; i < uri.length(); ++i) {
                    char c = uri.charAt(i);
                    if (Character.isISOControl(c)) continue;
                    ((Writer)writer).write(c);
                }
            }
            finally {
                ((Writer)writer).close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        byte[] bytes = out.toByteArray();
        StringBuffer buff = new StringBuffer(bytes.length);
        for (int i = 0; i < bytes.length; ++i) {
            int b = bytes[i] & 0xFF;
            if (SAFE_CHARS.get(b)) {
                buff.append((char)b);
                continue;
            }
            buff.append('%');
            buff.append(HEX[b >> 4]);
            buff.append(HEX[b & 0xF]);
        }
        uri = buff.toString();
        return uri;
    }

    private static URI filter(URI uri) throws URISyntaxException {
        String ssp;
        String path = uri.getPath();
        if (path == null) {
            return uri;
        }
        while (path.startsWith("/../")) {
            path = path.substring(3);
            uri = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), path, uri.getQuery(), uri.getFragment());
        }
        String schema = uri.getScheme();
        if (schema != null && schema.equals("file") && (ssp = uri.getSchemeSpecificPart()) != null && ssp.length() >= 2 && ssp.charAt(0) == '/' && ssp.charAt(1) != '/') {
            uri = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), "//" + path, uri.getQuery(), uri.getFragment());
        }
        return uri;
    }

    public static URI create(String encoding, String href) throws URISyntaxException {
        href = URIHelper.filter(encoding, href);
        URI uri = new URI(href);
        return URIHelper.filter(uri);
    }

    public static URI resolve(String encoding, URI baseURI, String href) throws URISyntaxException {
        URI hrefURI;
        URI uri;
        if (URIHelper.isWindowsDrive(href = URIHelper.filter(encoding, href))) {
            href = "file:///" + href;
        }
        if ((uri = baseURI.resolve(hrefURI = new URI(href))).getScheme() == null && baseURI.getScheme() != null) {
            uri = new URI(baseURI.getScheme(), uri.getSchemeSpecificPart(), uri.getFragment());
        }
        if (URIHelper.hasWindowsDrive(baseURI) && !hrefURI.isAbsolute() || URIHelper.hasWindowsDrive(hrefURI)) {
            int start;
            String path = uri.getSchemeSpecificPart();
            for (start = 0; start < path.length() && path.charAt(start) == '/'; ++start) {
            }
            if (++start <= path.length() && path.charAt(start) != ':') {
                uri = new URI(uri.getScheme(), path.substring(0, start) + ':' + path.substring(start), uri.getFragment());
            }
        }
        uri = URIHelper.filter(uri);
        return uri;
    }

    public static URI resolve(String encoding, String baseURI, String href) throws URISyntaxException {
        return URIHelper.resolve(encoding, URIHelper.create(encoding, baseURI), href);
    }

    private static boolean hasWindowsDrive(URI uri) {
        int start;
        if (!WINDOWS) {
            return false;
        }
        if (!"file".equalsIgnoreCase(uri.getScheme())) {
            return false;
        }
        String path = uri.getSchemeSpecificPart();
        for (start = 0; start < path.length() && path.charAt(start) == '/'; ++start) {
        }
        return start > 0 && path.length() >= start + 2 && path.charAt(start + 1) == ':' && (path.charAt(start) >= 'A' && path.charAt(start) <= 'Z' || path.charAt(start) >= 'a' && path.charAt(start) <= 'z');
    }

    private static boolean isWindowsDrive(String href) {
        if (!WINDOWS) {
            return false;
        }
        return href.length() >= 2 && (href.charAt(0) >= 'A' && href.charAt(0) <= 'Z' || href.charAt(0) >= 'a' && href.charAt(0) <= 'z') && href.charAt(1) == ':';
    }

    public static String decode(String uri) {
        uri = uri.replace("+", "%2B");
        try {
            return URLDecoder.decode(uri, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        int i;
        HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        SAFE_CHARS = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            SAFE_CHARS.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            SAFE_CHARS.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            SAFE_CHARS.set(i);
        }
        SAFE_CHARS.set(36);
        SAFE_CHARS.set(45);
        SAFE_CHARS.set(95);
        SAFE_CHARS.set(46);
        SAFE_CHARS.set(43);
        SAFE_CHARS.set(37);
        SAFE_CHARS.set(33);
        SAFE_CHARS.set(42);
        SAFE_CHARS.set(39);
        SAFE_CHARS.set(40);
        SAFE_CHARS.set(41);
        SAFE_CHARS.set(44);
        SAFE_CHARS.set(47);
        SAFE_CHARS.set(58);
        SAFE_CHARS.set(59);
        SAFE_CHARS.set(64);
        SAFE_CHARS.set(38);
        SAFE_CHARS.set(61);
        SAFE_CHARS.set(63);
        SAFE_CHARS.set(35);
        WINDOWS = System.getProperty("os.name").startsWith("Windows");
        CURRENT_URI = URI.create(".");
    }
}

