/*
 * Decompiled with CFR 0.152.
 */
package jp.cssj.cti2;

import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import jp.cssj.cti2.CTIDriver;
import jp.cssj.cti2.CTISession;
import jp.cssj.plugin.PluginLoader;

public class CTIDriverManager {
    private CTIDriverManager() {
    }

    public static CTIDriver getDriver(URI uri) {
        CTIDriver driver = (CTIDriver)((Object)PluginLoader.getPluginLoader().search(CTIDriver.class, uri));
        if (driver == null) {
            throw new RuntimeException(uri + " \u306b\u63a5\u7d9a\u3059\u308b\u30c9\u30e9\u30a4\u30d0\u304c\u3042\u308a\u307e\u305b\u3093\u3002");
        }
        return driver;
    }

    public static CTISession getSession(URI uri) throws IOException {
        return CTIDriverManager.getSession(uri, null);
    }

    public static CTISession getSession(URI uri, Map<String, String> props) throws IOException {
        CTIDriver driver = CTIDriverManager.getDriver(uri);
        return driver.getSession(uri, props);
    }

    public static CTISession getSession(URI uri, String user, String password) throws IOException {
        CTIDriver driver = CTIDriverManager.getDriver(uri);
        HashMap<String, String> props = null;
        if (user != null || password != null) {
            props = new HashMap<String, String>();
            props.put("user", user);
            props.put("password", password);
        }
        return driver.getSession(uri, props);
    }
}

