/*
 * Decompiled with CFR 0.152.
 */
package jp.cssj.driver.ctip.v1;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.HashMap;
import java.util.Map;
import jp.cssj.driver.ctip.common.ChannelIO;
import jp.cssj.driver.ctip.v1.V1RequestConsumer;

public class V1ContentProducer {
    public static final byte ADD = 1;
    public static final byte INSERT = 2;
    public static final byte MESSAGE = 3;
    public static final byte DATA = 4;
    public static final byte ERROR_WARN = 1;
    public static final byte ERROR_ERROR = 2;
    public static final byte ERROR_FATAL = 3;
    protected final String encoding;
    protected final URI uri;
    protected ChannelIO io;
    private byte type;
    private int id;
    private int anchorId;
    private int progress;
    private short code;
    private String[] args = new String[1];
    private String message;
    private ByteBuffer data;
    private ByteBuffer destInt = ByteBuffer.allocate(4);
    private ByteBuffer destShort = ByteBuffer.allocate(2);
    private ByteBuffer destByte = ByteBuffer.allocate(1);
    private static final Map<String, Short> NAME_TO_CODE = new HashMap<String, Short>();

    static {
        NAME_TO_CODE.put("page-number", new Short(6145));
        NAME_TO_CODE.put("heading-title", new Short(6146));
        NAME_TO_CODE.put("broken-image-uri", new Short(10257));
        NAME_TO_CODE.put("pass-remainder", new Short(6147));
        NAME_TO_CODE.put("annot", new Short(6148));
    }

    public V1ContentProducer(URI uri, String encoding) throws IOException {
        this.encoding = encoding;
        this.uri = uri;
    }

    public V1RequestConsumer connect() throws IOException {
        String host = this.uri.getHost();
        int port = this.uri.getPort();
        if (port == -1) {
            port = 8099;
        }
        SocketChannel channel = SelectorProvider.provider().openSocketChannel();
        channel.connect(new InetSocketAddress(host, port));
        channel.configureBlocking(true);
        byte[] header = ("CTIP/1.0 " + this.encoding + "\n").getBytes("ISO-8859-1");
        this.io = new ChannelIO(channel, 0L);
        this.io.writeAll(ByteBuffer.wrap(header));
        return new V1RequestConsumer(this.io, this.encoding);
    }

    protected void close() throws IOException {
        if (this.io != null) {
            this.io.close();
            this.io = null;
        }
    }

    public boolean next() throws IOException {
        int payload = this.io.readInt(this.destInt);
        if (payload == 0) {
            this.close();
            return false;
        }
        this.type = this.io.readByte(this.destByte);
        switch (this.type) {
            case 1: {
                break;
            }
            case 2: {
                this.anchorId = this.io.readInt(this.destInt);
                break;
            }
            case 4: {
                this.id = this.io.readInt(this.destInt);
                this.progress = this.io.readInt(this.destInt);
                this.data = ByteBuffer.allocate(payload -= 9);
                this.io.readAll(this.data);
                this.data.position(0);
                break;
            }
            case 3: {
                String name;
                Short scode;
                this.code = this.io.readByte(this.destByte);
                this.code = this.code == 4 ? (short)1 : (this.code == 2 ? (short)2 : (short)(this.code + 1));
                this.code = (short)(this.code << 12);
                this.message = this.args[0] = this.io.readString(this.destShort, this.encoding);
                int colon = this.args[0].indexOf(58);
                if (colon == -1 || (scode = NAME_TO_CODE.get(name = this.args[0].substring(0, colon))) == null) break;
                this.code = scode;
                this.args[0] = this.args[0].substring(colon + 1);
                break;
            }
            default: {
                throw new IOException("Bad response: type " + this.type);
            }
        }
        return true;
    }

    public int getId() throws IOException {
        return this.id;
    }

    public int getAnchorId() throws IOException {
        return this.anchorId;
    }

    public byte getType() throws IOException {
        return this.type;
    }

    public long getProgress() throws IOException {
        return this.progress;
    }

    public String[] getArgs() throws IOException {
        return this.args;
    }

    public String getMessage() throws IOException {
        return this.message;
    }

    public short getCode() throws IOException {
        return this.code;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.data.remaining() <= 0) {
            return -1;
        }
        len = Math.min(len, this.data.remaining());
        this.data.get(b, off, len);
        return len;
    }
}

