/*
 * Decompiled with CFR 0.152.
 */
package jp.cssj.resolver.zip;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import jp.cssj.resolver.SourceValidity;
import jp.cssj.resolver.helpers.AbstractSource;
import jp.cssj.resolver.helpers.URIHelper;
import jp.cssj.resolver.zip.ZipFileSourceValidity;

public class ZipFileSource
extends AbstractSource {
    private static final Logger LOG = Logger.getLogger(ZipFileSource.class.getName());
    private final ZipFile zip;
    private final ZipEntry entry;
    private final String encoding;
    private String mimeType = null;

    public ZipFileSource(ZipFile zip, String path, URI uri, String mimeType, String encoding) {
        super(uri);
        if (zip == null) {
            throw new NullPointerException();
        }
        if (path == null) {
            path = uri.getSchemeSpecificPart();
            try {
                path = URIHelper.decode(path);
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "URI\u3092\u30c7\u30b3\u30fc\u30c9\u3067\u304d\u307e\u305b\u3093\u3002", e);
            }
        }
        this.entry = zip.getEntry(path);
        this.zip = zip;
        this.mimeType = mimeType;
        this.encoding = encoding;
    }

    public ZipFileSource(ZipFile zip, URI uri, String mimeType, String encoding) {
        this(zip, null, uri, mimeType, encoding);
    }

    public ZipFileSource(ZipFile zip, URI uri, String mimeType) {
        this(zip, uri, mimeType, null);
    }

    public ZipFileSource(ZipFile zip, URI uri) throws IOException {
        this(zip, uri, null);
    }

    public ZipFileSource(ZipFile zip, String path, URI uri, String mimeType) {
        this(zip, path, uri, mimeType, null);
    }

    public ZipFileSource(ZipFile zip, String path, URI uri) {
        this(zip, path, uri, null, null);
    }

    @Override
    public String getMimeType() throws IOException {
        String name;
        int dot;
        if (this.mimeType == null && (dot = (name = this.entry.getName()).indexOf(46)) != -1) {
            String suffix = name.substring(dot, name.length());
            if (suffix.equalsIgnoreCase(".html") || suffix.equalsIgnoreCase(".htm")) {
                this.mimeType = "text/html";
            } else if (suffix.equalsIgnoreCase(".xml") || suffix.equalsIgnoreCase(".xhtml") || suffix.equalsIgnoreCase(".xht")) {
                this.mimeType = "text/xml";
            }
        }
        return this.mimeType;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public boolean exists() throws IOException {
        return this.entry != null;
    }

    @Override
    public boolean isFile() throws IOException {
        return false;
    }

    @Override
    public boolean isInputStream() throws IOException {
        return true;
    }

    @Override
    public boolean isReader() throws IOException {
        return this.encoding != null;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.entry == null) {
            throw new FileNotFoundException(this.uri.toString());
        }
        return this.zip.getInputStream(this.entry);
    }

    @Override
    public Reader getReader() throws IOException {
        if (!this.isReader()) {
            throw new UnsupportedOperationException();
        }
        return new InputStreamReader(this.getInputStream(), this.encoding);
    }

    @Override
    public File getFile() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLength() throws IOException {
        if (this.exists()) {
            return -1L;
        }
        return 0L;
    }

    @Override
    public SourceValidity getValidity() throws IOException {
        File file = new File(this.zip.getName());
        long timestamp = file.lastModified();
        return new ZipFileSourceValidity(timestamp, file);
    }
}

