/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import org.h2.Driver;
import org.h2.message.Message;
import org.h2.store.fs.FileObject;
import org.h2.store.fs.FileObjectDatabase;
import org.h2.store.fs.FileObjectInputStream;
import org.h2.store.fs.FileObjectOutputStream;
import org.h2.store.fs.FileSystem;
import org.h2.util.IOUtils;
import org.h2.util.JdbcUtils;
import org.h2.util.StringUtils;

public class FileSystemDatabase
extends FileSystem {
    private Connection conn;
    private String url;
    private static final HashMap INSTANCES = new HashMap();
    private HashMap preparedMap = new HashMap();
    private boolean log;

    public static synchronized FileSystem getInstance(String url) {
        FileSystemDatabase fs;
        int idx = url.indexOf(47);
        if (idx > 0) {
            url = url.substring(0, idx);
        }
        if ((fs = (FileSystemDatabase)INSTANCES.get(url)) != null) {
            return fs;
        }
        try {
            Connection conn = url.startsWith("jdbc:h2:") ? Driver.load().connect(url, new Properties()) : JdbcUtils.getConnection(null, url, new Properties());
            boolean log = url.toUpperCase().indexOf("TRACE_") >= 0;
            fs = new FileSystemDatabase(url, conn, log);
            INSTANCES.put(url, fs);
            return fs;
        }
        catch (SQLException e) {
            throw Message.getInternalError("Can not connect to " + url, e);
        }
    }

    public void close() {
        JdbcUtils.closeSilently(this.conn);
    }

    private FileSystemDatabase(String url, Connection conn, boolean log) throws SQLException {
        this.url = url;
        this.conn = conn;
        this.log = log;
        Statement stat = conn.createStatement();
        conn.setAutoCommit(false);
        stat.execute("SET ALLOW_LITERALS NONE");
        stat.execute("CREATE TABLE IF NOT EXISTS FILES(ID IDENTITY, PARENTID BIGINT, NAME VARCHAR, LASTMODIFIED BIGINT, LENGTH BIGINT, UNIQUE(PARENTID, NAME))");
        stat.execute("CREATE TABLE IF NOT EXISTS FILEDATA(ID BIGINT PRIMARY KEY, DATA BLOB)");
        PreparedStatement prep = conn.prepareStatement("SET MAX_LENGTH_INPLACE_LOB ?");
        prep.setLong(1, 4096L);
        prep.execute();
        stat.execute("MERGE INTO FILES VALUES(ZERO(), NULL, SPACE(ZERO()), ZERO(), NULL)");
        this.commit();
        if (log) {
            ResultSet rs = stat.executeQuery("SELECT * FROM FILES ORDER BY PARENTID, NAME");
            while (rs.next()) {
                long id = rs.getLong("ID");
                long parentId = rs.getLong("PARENTID");
                String name = rs.getString("NAME");
                long lastModified = rs.getLong("LASTMODIFIED");
                long length = rs.getLong("LENGTH");
                this.log(id + " " + name + " parent:" + parentId + " length:" + length + " lastMod:" + lastModified);
            }
        }
    }

    private void commit() {
        block2: {
            try {
                this.conn.commit();
            }
            catch (SQLException e) {
                if (!this.log) break block2;
                e.printStackTrace();
            }
        }
    }

    private void rollback() {
        block2: {
            try {
                this.conn.rollback();
            }
            catch (SQLException e) {
                if (!this.log) break block2;
                e.printStackTrace();
            }
        }
    }

    private void log(String s) {
        if (this.log) {
            System.out.println(s);
        }
    }

    private long getId(String fileName, boolean parent) {
        fileName = this.translateFileName(fileName);
        this.log(fileName);
        try {
            int len;
            String[] path = StringUtils.arraySplit(fileName, '/', false);
            long id = 0L;
            int n = len = parent ? path.length - 1 : path.length;
            if (fileName.endsWith("/")) {
                --len;
            }
            for (int i = 1; i < len; ++i) {
                PreparedStatement prep = this.prepare("SELECT ID FROM FILES WHERE PARENTID=? AND NAME=?");
                prep.setLong(1, id);
                prep.setString(2, path[i]);
                ResultSet rs = prep.executeQuery();
                if (!rs.next()) {
                    return -1L;
                }
                id = rs.getLong(1);
            }
            return id;
        }
        catch (SQLException e) {
            throw this.convert(e);
        }
    }

    private String translateFileName(String fileName) {
        if (fileName.startsWith(this.url)) {
            fileName = fileName.substring(this.url.length());
        }
        return fileName;
    }

    private PreparedStatement prepare(String sql) throws SQLException {
        PreparedStatement prep = (PreparedStatement)this.preparedMap.get(sql);
        if (prep == null) {
            prep = this.conn.prepareStatement(sql);
            this.preparedMap.put(sql, prep);
        }
        return prep;
    }

    private RuntimeException convert(SQLException e) {
        if (this.log) {
            e.printStackTrace();
        }
        return new RuntimeException(e.toString());
    }

    public boolean canWrite(String fileName) {
        return true;
    }

    public void copy(String original, String copy) throws SQLException {
        try {
            OutputStream out = this.openFileOutputStream(copy, false);
            InputStream in = this.openFileInputStream(original);
            IOUtils.copyAndClose(in, out);
        }
        catch (IOException e) {
            this.rollback();
            throw Message.convertIOException(e, "Can not copy " + original + " to " + copy);
        }
    }

    public void createDirs(String fileName) throws SQLException {
        fileName = this.translateFileName(fileName);
        try {
            String[] path = StringUtils.arraySplit(fileName, '/', false);
            long parentId = 0L;
            int len = path.length;
            if (fileName.endsWith("/")) {
                --len;
            }
            --len;
            for (int i = 1; i < len; ++i) {
                PreparedStatement prep = this.prepare("SELECT ID FROM FILES WHERE PARENTID=? AND NAME=?");
                prep.setLong(1, parentId);
                prep.setString(2, path[i]);
                ResultSet rs = prep.executeQuery();
                if (!rs.next()) {
                    prep = this.prepare("INSERT INTO FILES(NAME, PARENTID, LASTMODIFIED) VALUES(?, ?, ?)");
                    prep.setString(1, path[i]);
                    prep.setLong(2, parentId);
                    prep.setLong(3, System.currentTimeMillis());
                    prep.execute();
                    rs = JdbcUtils.getGeneratedKeys(prep);
                    rs.next();
                    parentId = rs.getLong(1);
                    continue;
                }
                parentId = rs.getLong(1);
            }
            this.commit();
        }
        catch (SQLException e) {
            this.rollback();
            throw this.convert(e);
        }
    }

    public boolean createNewFile(String fileName) throws SQLException {
        try {
            if (this.exists(fileName)) {
                return false;
            }
            this.openFileObject(fileName, "rw").close();
            return true;
        }
        catch (IOException e) {
            throw Message.convert(e);
        }
    }

    public String createTempFile(String name, String suffix, boolean deleteOnExit, boolean inTempDir) throws IOException {
        name = this.translateFileName(name);
        name = name + ".";
        int i = 0;
        while (true) {
            String n;
            if (!this.exists(n = name + i + suffix)) {
                this.openFileObject(n, "rw").close();
                return n;
            }
            ++i;
        }
    }

    public synchronized void delete(String fileName) throws SQLException {
        try {
            long id = this.getId(fileName, false);
            PreparedStatement prep = this.prepare("DELETE FROM FILES WHERE ID=?");
            prep.setLong(1, id);
            prep.execute();
            prep = this.prepare("DELETE FROM FILEDATA WHERE ID=?");
            prep.setLong(1, id);
            prep.execute();
            this.commit();
        }
        catch (SQLException e) {
            this.rollback();
            throw this.convert(e);
        }
    }

    public void deleteRecursive(String fileName) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public boolean exists(String fileName) {
        long id = this.getId(fileName, false);
        return id >= 0L;
    }

    public boolean fileStartsWith(String fileName, String prefix) {
        fileName = this.translateFileName(fileName);
        return fileName.startsWith(prefix);
    }

    public String getAbsolutePath(String fileName) {
        return fileName;
    }

    public String getFileName(String fileName) throws SQLException {
        fileName = this.translateFileName(fileName);
        String[] path = StringUtils.arraySplit(fileName, '/', false);
        return path[path.length - 1];
    }

    public synchronized long getLastModified(String fileName) {
        try {
            long id = this.getId(fileName, false);
            PreparedStatement prep = this.prepare("SELECT LASTMODIFIED FROM FILES WHERE ID=?");
            prep.setLong(1, id);
            ResultSet rs = prep.executeQuery();
            rs.next();
            return rs.getLong(1);
        }
        catch (SQLException e) {
            throw this.convert(e);
        }
    }

    public String getParent(String fileName) {
        int idx = Math.max(fileName.indexOf(58), fileName.lastIndexOf(47));
        return fileName.substring(0, idx);
    }

    public boolean isAbsolute(String fileName) {
        return true;
    }

    public synchronized boolean isDirectory(String fileName) {
        try {
            long id = this.getId(fileName, false);
            PreparedStatement prep = this.prepare("SELECT LENGTH FROM FILES WHERE ID=?");
            prep.setLong(1, id);
            ResultSet rs = prep.executeQuery();
            rs.next();
            rs.getLong(1);
            return rs.wasNull();
        }
        catch (SQLException e) {
            throw this.convert(e);
        }
    }

    public boolean isReadOnly(String fileName) {
        return false;
    }

    public synchronized long length(String fileName) {
        try {
            long id = this.getId(fileName, false);
            PreparedStatement prep = this.prepare("SELECT LENGTH FROM FILES WHERE ID=?");
            prep.setLong(1, id);
            ResultSet rs = prep.executeQuery();
            rs.next();
            return rs.getLong(1);
        }
        catch (SQLException e) {
            throw this.convert(e);
        }
    }

    public synchronized String[] listFiles(String path) throws SQLException {
        try {
            String name = path;
            if (!name.endsWith("/")) {
                name = name + "/";
            }
            long id = this.getId(path, false);
            PreparedStatement prep = this.prepare("SELECT NAME FROM FILES WHERE PARENTID=? ORDER BY NAME");
            prep.setLong(1, id);
            ResultSet rs = prep.executeQuery();
            ArrayList<String> list = new ArrayList<String>();
            while (rs.next()) {
                list.add(name + rs.getString(1));
            }
            String[] result = new String[list.size()];
            list.toArray(result);
            return result;
        }
        catch (SQLException e) {
            throw this.convert(e);
        }
    }

    public String normalize(String fileName) throws SQLException {
        return fileName;
    }

    public InputStream openFileInputStream(String fileName) throws IOException {
        return new FileObjectInputStream(this.openFileObject(fileName, "r"));
    }

    public FileObject openFileObject(String fileName, String mode) throws IOException {
        try {
            long id = this.getId(fileName, false);
            PreparedStatement prep = this.prepare("SELECT DATA FROM FILEDATA WHERE ID=?");
            prep.setLong(1, id);
            ResultSet rs = prep.executeQuery();
            if (rs.next()) {
                InputStream in = rs.getBinaryStream(1);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                IOUtils.copyAndClose(in, out);
                byte[] data = out.toByteArray();
                return new FileObjectDatabase(this, fileName, data, false);
            }
            return new FileObjectDatabase(this, fileName, new byte[0], true);
        }
        catch (SQLException e) {
            throw this.convert(e);
        }
    }

    public OutputStream openFileOutputStream(String fileName, boolean append) throws SQLException {
        try {
            return new FileObjectOutputStream(this.openFileObject(fileName, "rw"), append);
        }
        catch (IOException e) {
            throw Message.convertIOException(e, fileName);
        }
    }

    public synchronized void rename(String oldName, String newName) throws SQLException {
        try {
            long parentOld = this.getId(oldName, true);
            long parentNew = this.getId(newName, true);
            if (parentOld != parentNew) {
                throw Message.getUnsupportedException();
            }
            newName = this.getFileName(newName);
            long id = this.getId(oldName, false);
            PreparedStatement prep = this.prepare("UPDATE FILES SET NAME=? WHERE ID=?");
            prep.setString(1, newName);
            prep.setLong(2, id);
            prep.execute();
            this.commit();
        }
        catch (SQLException e) {
            this.rollback();
            throw this.convert(e);
        }
    }

    public boolean tryDelete(String fileName) {
        try {
            this.delete(fileName);
        }
        catch (SQLException e) {
            return false;
        }
        return true;
    }

    synchronized void write(String fileName, byte[] b, int len) throws IOException {
        try {
            long id = this.getId(fileName, false);
            if (id >= 0L) {
                PreparedStatement prep = this.prepare("DELETE FROM FILES WHERE ID=?");
                prep.setLong(1, id);
                prep.execute();
                prep = this.prepare("DELETE FROM FILEDATA WHERE ID=?");
                prep.setLong(1, id);
                prep.execute();
            }
            long parentId = this.getId(fileName, true);
            PreparedStatement prep = this.prepare("INSERT INTO FILES(PARENTID, NAME, LASTMODIFIED) VALUES(?, ?, ?)");
            prep.setLong(1, parentId);
            prep.setString(2, this.getFileName(fileName));
            prep.setLong(3, System.currentTimeMillis());
            prep.execute();
            ResultSet rs = JdbcUtils.getGeneratedKeys(prep);
            rs.next();
            id = rs.getLong(1);
            prep = this.prepare("INSERT INTO FILEDATA(ID, DATA) VALUES(?, ?)");
            prep.setLong(1, id);
            ByteArrayInputStream in = new ByteArrayInputStream(b, 0, len);
            prep.setBinaryStream(2, (InputStream)in, -1);
            prep.execute();
            prep = this.prepare("UPDATE FILES SET LENGTH=(SELECT LENGTH(DATA) FROM FILEDATA WHERE ID=?) WHERE ID=?");
            prep.setLong(1, id);
            prep.setLong(2, id);
            prep.execute();
            this.commit();
        }
        catch (SQLException e) {
            this.rollback();
            throw this.convert(e);
        }
    }
}

