/* $Id: FfmpegCommand.java 372 2010-05-01 07:17:25Z yuki $ */
package saccubus.converter;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import saccubus.ConvertStopFlag;
import saccubus.conv.ConvertToVideoHook;
import saccubus.converter.profile.Ffmpeg;
import saccubus.converter.profile.FfmpegOption;
import saccubus.converter.profile.GeneralSetting;
import saccubus.converter.profile.NgSetting;
import saccubus.net.TextProgressListener;
import yukihane.swf.Cws2Fws;

/**
 *
 * @author yuki
 */
public class FfmpegCommand extends AbstractCommand {

    private final File commentMiddleFile;
    private final File tcommMiddleFile;
    private final File TMP_CWS;
    private final File commentFile;
    private final File tcommFile;
    private final File videoFile;
    private final File convertedVideoFile;
    private final Ffmpeg ffmpeg;

    FfmpegCommand(TextProgressListener listener, ConvertStopFlag flag, File commentFile, File tcommFile,
            File videoFile, File convertedVideoFile, Ffmpeg ffmpeg, GeneralSetting general) throws IOException {
        super(listener, flag);
        this.commentFile = commentFile;
        this.tcommFile = tcommFile;
        this.videoFile = videoFile;
        this.convertedVideoFile = convertedVideoFile;
        this.ffmpeg = ffmpeg;

        File tmpDir = general.getTempDir();
        commentMiddleFile = File.createTempFile("vhk", ".tmp", tmpDir);
        tcommMiddleFile = File.createTempFile("tcom", ".tmp", tmpDir);
        TMP_CWS = File.createTempFile("cws", ".swf", tmpDir);
    }

    public boolean execute() throws InterruptedException, IOException {
        try {
            return exec();
        } finally {
            if (commentMiddleFile.exists()) {
                commentMiddleFile.delete();
            }
            if (tcommMiddleFile.exists()) {
                tcommMiddleFile.delete();
            }
            if (TMP_CWS.exists()) {
                TMP_CWS.delete();
            }
        }
    }

    private boolean exec() throws InterruptedException, IOException {
        final NgSetting ngSetting = getFfmpeg().getNgSetting();
        if (commentFile != null) {
            sendText("Rg̒ԃt@Cւ̕ϊ");
            boolean conv = ConvertToVideoHook.convert(commentFile, commentMiddleFile, ngSetting.getId(), ngSetting.
                    getWord());
            if (!conv) {
                sendText("RgϊɎsBt@CɎgpłȂ܂܂Ă邩K\̊ԈႢH");
                return false;
            }
        }
        stopFlagReturn();
        if (tcommFile != null) {
            sendText("e҃Rg̒ԃt@Cւ̕ϊ");
            boolean conv = ConvertToVideoHook.convert(tcommFile, tcommMiddleFile, ngSetting.getId(), ngSetting.getWord());
            if (!conv) {
                sendText("RgϊɎsBt@CɎgpłȂ܂܂Ă邩K\̊ԈႢH");
                return false;
            }
        }
        stopFlagReturn();
        sendText("̕ϊJn");
        int code;
        if ((code = converting_video(videoFile, convertedVideoFile, (commentFile != null), commentMiddleFile.getPath(), (tcommFile
                != null), tcommMiddleFile.getPath(), getFfmpeg().getFfmpegOption())) == 0) {
            sendText("ϊɏI܂B");
            return true;
        } else {
            sendText("ϊG[:" + convertedVideoFile.getPath());
        }
        return false;
    }

    private int converting_video(File videoFile, File convertedVideoFile, boolean addComment, String vhook_path,
            boolean addTcomment, String tcommPath, FfmpegOption ov) throws InterruptedException, IOException {
        File fwsFile = Cws2Fws.createFws(videoFile, TMP_CWS);

        List<String> cmdList = new ArrayList<String>();
        cmdList.add(getFfmpeg().getFfmpeg().getPath());
        cmdList.add("-y");
        String[] mainOptions = ov.getMainOption().split(" +");
        for (String opt : mainOptions) {
            if (StringUtils.isNotBlank(opt)) {
                cmdList.add(opt);
            }
        }
        String[] inOptions = ov.getInOption().split(" +");
        for (String opt : inOptions) {
            if (StringUtils.isNotBlank(opt)) {
                cmdList.add(opt);
            }
        }
        cmdList.add("-i");

        if (fwsFile == null) {
            cmdList.add(videoFile.getPath());
        } else {
            cmdList.add(fwsFile.getPath());
        }
        String[] outOptions = ov.getOutOption().split(" +");
        for (String opt : outOptions) {
            if (StringUtils.isNotBlank(opt)) {
                cmdList.add(opt);
            }
        }
        if (!getFfmpeg().isVhookDisabled()) {
            if (!addVhookSetting(cmdList, addComment, vhook_path, addTcomment, tcommPath)) {
                return -1;
            }
        }
        cmdList.add(convertedVideoFile.getPath());

        System.out.print("arg:");
        for (String s : cmdList) {
            System.out.print(" " + s);
        }
        System.out.println();

        try {
            System.out.println("\n\n----\nProcessing FFmpeg...\n----\n\n");
            Process process = Runtime.getRuntime().exec(cmdList.toArray(new String[0]));
            BufferedReader ebr = new BufferedReader(new InputStreamReader(
                    process.getErrorStream()));
            String e;
            while ((e = ebr.readLine()) != null) {
                String state = e;
                if (state.startsWith("frame=")) {
                    sendText(state);
                } else if (!state.endsWith("No accelerated colorspace conversion found")) {
                    System.out.println(e);
                }

                try {
                    stopFlagReturn();
                } catch (InterruptedException ex) {
                    process.destroy();
                    throw ex;
                }

            }
            process.waitFor();
            return process.exitValue();
        } finally {
            if (fwsFile != null) {
                fwsFile.delete();
            }
        }
    }

    private boolean addVhookSetting(List cmdList, boolean addComment, String vhook_path, boolean addTcomment,
            String tcommPath) {
        try {
            cmdList.add("-vfilters");
            StringBuffer sb = new StringBuffer();
            sb.append("vhext=");
            sb.append(getFfmpeg().getVhook().getPath().replace("\\", "/"));
            if (addComment) {
                sb.append("|");
                sb.append("--data-user:");
                sb.append(URLEncoder.encode(vhook_path.replace("\\", "/"), "Shift_JIS"));
            }
            if (addTcomment) {
                sb.append("|");
                sb.append("--data-owner:");
                sb.append(URLEncoder.encode(tcommPath.replace("\\", "/"), "Shift_JIS"));
            }
            sb.append("|");
            sb.append("--font:");
            sb.append(URLEncoder.encode(
                    getFfmpeg().getFont().getPath().replace("\\", "/"), "Shift_JIS"));
            sb.append("|");
            sb.append("--font-index:");
            sb.append(getFfmpeg().getFontIndex());
            sb.append("|");
            sb.append("--show-user:");
            sb.append(getFfmpeg().getMaxNumOfComment());
            sb.append("|");
            sb.append("--shadow:");
            sb.append(getFfmpeg().getShadowIndex());
            sb.append("|");
            if (getFfmpeg().isShowConverting()) {
                sb.append("--enable-show-video");
                sb.append("|");
            }
            if (getFfmpeg().isSelfAdjustFontSize()) {
                sb.append("--enable-fix-font-size");
                sb.append("|");
            }
            if (getFfmpeg().isCommentOpaque()) {
                sb.append("--enable-opaque-comment");
            }
            cmdList.add(sb.toString());
            return true;
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return false;
        }
    }

    private Ffmpeg getFfmpeg() {
        return ffmpeg;
    }
}
