/* $Id: FileLocator.java 402 2010-05-28 14:47:40Z yuki $ */
package saccubus.converter.filegetter;

import java.io.File;
import java.io.FilenameFilter;
import org.apache.commons.io.FilenameUtils;

/**
 *
 * @author yuki
 */
class FileLocator {

    private final boolean autoFileName;
    private final File initFile;
    private final String prefix;
    private final String title;
    private final String[] suffixes;

    FileLocator(boolean autoFileName, File initFile, String prefix, String title, String... suffixes) {
        this.autoFileName = autoFileName;
        this.initFile = initFile;
        this.prefix = prefix;
        this.title = title;
        this.suffixes = suffixes;
    }

    /**
     * RXgN^Ŏw肵Ńt@CB
     * autoFileNamefalsȅꍇAږOwł邽ߎw肳ꂽt@Ĉ܂ܕԂB
     * autoFileNametruȅꍇAinitFilefBNgprefixŎn܂suffixŏIt@C݂邩
     * ΂ԂB
     * ̃t@CꍇAw肳ꂽp[^ɏ]t@CԂB
     * ̂Ƃgq(suffixes)w肳Ăꍇ͍ŏ̂̂ԂB
     * @return ]̃t@CBt@C݂͑ꍇA݂Ȃꍇ邱ƂɒӁB
     */
    File getFile() {
        if (!isAutoNaming()) {
            return initFile;
        } else {
            File res = searchFile();
            if (res != null) {
                return res;
            }
            return new File(initFile, prefix + title + suffixes[0]);
        }
    }

    private final File searchFile() {
        FilenameFilter filter = new FilenameFilter() {

            public boolean accept(File dir, String name) {
                if (name.startsWith(prefix)) {
                    for (String suffix : suffixes) {
                        if (name.endsWith(suffix)) {
                            return true;
                        }
                    }
                }
                return false;
            }
        };
        File[] res = initFile.listFiles(filter);
        if (res == null || res.length == 0) {
            return null;
        }
        if (res.length > 1) {
            System.out.println("̌t@Cqbg܂. Ӑ}Ȃt@CIĂ\܂:" + res[0]);
        }
        return res[0];
    }

    protected boolean isAutoNaming() {
        return autoFileName;
    }

    protected final boolean getAutoFileName() {
        return autoFileName;
    }
}
