/* $Id: InputCommentSetting.java 413 2010-06-05 12:26:38Z yuki $ */
package saccubus.properties;

import java.io.File;
import java.util.Properties;

/**
 * ̓Rgݒ.
 * @author yuki
 */
public class InputCommentSetting extends InputFileSetting<Boolean> {

    /** Rg_E[h. */
    private static final String PROP_SAVE_COMMENT = "SaveCommentFile";
    /** ϊɃRgt@C폜. */
    private static final String PROP_DEL_COMMENT_AFTER_CONV = "DeleteCommentAfterConv";
    /** Rg擾͎Œ. */
    private static final String PROP_FIX_COMMENT_NUM = "FixCommentSize";
    /** 擾Rg. */
    private static final String PROP_BACK_COMMENT = "BackComment";
    /** tH_/t@CۑIWI{^. */
    private static final String PROP_COMMENT_FIX_FILE_NAME = "CommentFixFileName";
    /** tH_. */
    private static final String PROP_COMMENT_FOLDER = "CommentFixFileNameFolder";
    /** t@C. */
    private static final String PROP_COMMENT_FILE = "CommentFile";
    private final boolean selfAdjustNumOfComment;
    private final int numOfComment;

    public InputCommentSetting(boolean download, boolean autoNaming, File folder, File file, boolean deleteAfterConvert,
            boolean adjust, int numOfCom) {
        super(Boolean.valueOf(download), autoNaming, folder, file, deleteAfterConvert);
        this.selfAdjustNumOfComment = adjust;
        this.numOfComment = numOfCom;
    }

    public void save(Properties prop) {
        prop.setProperty(PROP_SAVE_COMMENT, getProcessKind().toString());
        prop.setProperty(PROP_DEL_COMMENT_AFTER_CONV, Boolean.toString(isDeleteAfterConvert()));
        prop.setProperty(PROP_FIX_COMMENT_NUM, Boolean.toString(isSelfAdjustNumOfComment()));
        prop.setProperty(PROP_BACK_COMMENT, Integer.toString(getNumOfComment()));
        prop.setProperty(PROP_COMMENT_FIX_FILE_NAME, Boolean.toString(isAutoNaming()));
        prop.setProperty(PROP_COMMENT_FOLDER, getFolder().getPath());
        prop.setProperty(PROP_COMMENT_FILE, getFile().getPath());

    }

    public static InputCommentSetting load(Properties prop) {
        boolean download = Boolean.parseBoolean(prop.getProperty(PROP_SAVE_COMMENT, "true"));
        boolean delete = Boolean.parseBoolean(prop.getProperty(PROP_DEL_COMMENT_AFTER_CONV, "false"));
        boolean adjustNumOfComment = Boolean.parseBoolean(prop.getProperty(PROP_FIX_COMMENT_NUM, "true"));
        String numOfComment = prop.getProperty(PROP_BACK_COMMENT, "500");
        boolean autoNaming = Boolean.parseBoolean(prop.getProperty(PROP_COMMENT_FIX_FILE_NAME, "true"));
        String folder = prop.getProperty(PROP_COMMENT_FOLDER, "[out]comment");
        String file = prop.getProperty(PROP_COMMENT_FILE, "comment.xml");

        return new InputCommentSetting(download, autoNaming, new File(folder), new File(file), delete,
                adjustNumOfComment,
                Integer.parseInt(numOfComment));
    }

    public final boolean isSelfAdjustNumOfComment() {
        return selfAdjustNumOfComment;
    }

    public final int getNumOfComment() {
        return numOfComment;
    }
}
