/* $Id: InputVideoSetting.java 372 2010-05-01 07:17:25Z yuki $ */
package saccubus.properties;

import java.io.File;
import java.util.Properties;
import saccubus.VideoSaveKind;

/**
 * ͓ݒێNX.
 * @author yuki
 */
public class InputVideoSetting extends InputFileSetting<VideoSaveKind> {

    private static final String PROP_SAVE_VIDEO = "SaveVideoFile";
    private static final String PROP_VIDEO_FIX_FILE_NAME = "VideoFixFileName";
    private static final String PROP_VIDEO_FIX_FILE_NAME_FOLDER = "VideoFixFileNameFolder";
    private static final String PROP_VIDEO_FILE = "VideoFile";
    private static final String PROP_DEL_VIDEO_AFTER_CONV = "DeleteVideoAfterConv";
    private static final String PROP_NICO_BROWSER_FILE_NAME = "NicoBrowserFileName";
    private final File nicoBrowserFile;

    public InputVideoSetting(VideoSaveKind download, boolean autoNaming, File folder,
            File file, boolean deleteAfterConvert, File nicoBrowserFile) {
        super(download, autoNaming, folder, file, deleteAfterConvert);
        this.nicoBrowserFile = nicoBrowserFile;
    }

    public void save(Properties prop) {
        prop.setProperty(PROP_SAVE_VIDEO, getProcessKind().toString());
        prop.setProperty(PROP_VIDEO_FILE, getFile().getPath());
        prop.setProperty(PROP_VIDEO_FIX_FILE_NAME, Boolean.toString(isAutoNaming()));
        prop.setProperty(PROP_VIDEO_FIX_FILE_NAME_FOLDER, getFolder().getPath());
        prop.setProperty(PROP_DEL_VIDEO_AFTER_CONV, Boolean.toString(isDeleteAfterConvert()));
        prop.setProperty(PROP_NICO_BROWSER_FILE_NAME, getNicoBrowserFile().getPath());
    }

    public static InputVideoSetting load(Properties prop) {
        final VideoSaveKind kind = convertVideoSaveKind(prop);
        boolean autoNaming = Boolean.parseBoolean(prop.getProperty(PROP_VIDEO_FIX_FILE_NAME, "true"));
        String folder = prop.getProperty(PROP_VIDEO_FIX_FILE_NAME_FOLDER, "[out]video");
        String file = prop.getProperty(PROP_VIDEO_FILE, "video.flv");
        boolean delete = Boolean.parseBoolean(prop.getProperty(PROP_DEL_VIDEO_AFTER_CONV, "false"));
        String nibrFile = prop.getProperty(PROP_NICO_BROWSER_FILE_NAME, "");

        return new InputVideoSetting(kind, autoNaming, new File(folder), new File(file), delete, new File(nibrFile));
    }

    /** {Ƃ΂ŕۑĂꍇAPROP_SAVE_VIDEOtrue/falseȂ̂ŕϊ. */
    private static VideoSaveKind convertVideoSaveKind(Properties prop) {
        VideoSaveKind kind;
        String saveVideo = prop.getProperty(PROP_SAVE_VIDEO);
        if (Boolean.toString(true).equals(saveVideo) || saveVideo == null) {
            kind = VideoSaveKind.SAVE;
        } else if (Boolean.toString(false).equals(saveVideo)) {
            kind = VideoSaveKind.NO_SAVE;
        } else {
            kind = VideoSaveKind.valueOf(saveVideo);
        }
        return kind;
    }

    public File getNicoBrowserFile() {
        return nicoBrowserFile;
    }
}
